/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.googlecode.cqengine.quantizer;

import selogger.com.googlecode.cqengine.quantizer.Quantizer;

public class IntegerQuantizer {
    public static Quantizer<Integer> withCompressionFactor(int compressionFactor) {
        return new CompressingQuantizer(compressionFactor);
    }

    IntegerQuantizer() {
    }

    static class CompressingQuantizer
    implements Quantizer<Integer> {
        private final int compressionFactor;

        public CompressingQuantizer(int compressionFactor) {
            if (compressionFactor < 2) {
                throw new IllegalArgumentException("Invalid compression factor, must be >= 2: " + compressionFactor);
            }
            this.compressionFactor = compressionFactor;
        }

        @Override
        public Integer getQuantizedValue(Integer attributeValue) {
            return attributeValue / this.compressionFactor * this.compressionFactor;
        }
    }
}

