/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.googlecode.cqengine.quantizer;

import selogger.com.googlecode.cqengine.quantizer.Quantizer;

public class LongQuantizer {
    public static Quantizer<Long> withCompressionFactor(int compressionFactor) {
        return new CompressingQuantizer(compressionFactor);
    }

    LongQuantizer() {
    }

    static class CompressingQuantizer
    implements Quantizer<Long> {
        private final int compressionFactor;

        public CompressingQuantizer(int compressionFactor) {
            if (compressionFactor < 2) {
                throw new IllegalArgumentException("Invalid compression factor, must be >= 2: " + compressionFactor);
            }
            this.compressionFactor = compressionFactor;
        }

        @Override
        public Long getQuantizedValue(Long attributeValue) {
            return attributeValue / (long)this.compressionFactor * (long)this.compressionFactor;
        }
    }
}

