/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.googlecode.cqengine.query.logical;

import java.util.Collection;
import java.util.Iterator;
import selogger.com.googlecode.cqengine.query.Query;
import selogger.com.googlecode.cqengine.query.logical.LogicalQuery;
import selogger.com.googlecode.cqengine.query.option.QueryOptions;

public class Or<O>
extends LogicalQuery<O> {
    private final boolean disjoint;

    public Or(Collection<Query<O>> childQueries) {
        this(childQueries, false);
    }

    public Or(Collection<Query<O>> childQueries, boolean disjoint) {
        super(childQueries);
        if (this.size() < 2) {
            throw new IllegalStateException("An 'Or' query cannot have fewer than 2 child queries, " + childQueries.size() + " were supplied");
        }
        this.disjoint = disjoint;
    }

    @Override
    public boolean matches(O object, QueryOptions queryOptions) {
        if (super.hasComparativeQueries()) {
            throw new UnsupportedOperationException("This method is not supported on logical queries which encapsulate comparative queries");
        }
        for (Query query : super.getSimpleQueries()) {
            if (!query.matches(object, queryOptions)) continue;
            return true;
        }
        for (Query<O> query : super.getLogicalQueries()) {
            if (!query.matches(object, queryOptions)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Or)) {
            return false;
        }
        Or or = (Or)o;
        if (this.disjoint != or.disjoint) {
            return false;
        }
        return this.childQueries.equals(or.childQueries);
    }

    public boolean isDisjoint() {
        return this.disjoint;
    }

    @Override
    protected int calcHashCode() {
        int result2 = this.childQueries.hashCode();
        result2 = 31 * result2 + (this.disjoint ? 1 : 0);
        return result2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("or(");
        Iterator iterator2 = this.childQueries.iterator();
        while (iterator2.hasNext()) {
            Query childQuery = (Query)iterator2.next();
            sb.append(childQuery);
            if (!iterator2.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }
}

