/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.googlecode.cqengine.query.option;

import selogger.com.googlecode.cqengine.attribute.Attribute;
import selogger.com.googlecode.cqengine.attribute.OrderControlAttribute;
import selogger.com.googlecode.cqengine.attribute.OrderMissingFirstAttribute;
import selogger.com.googlecode.cqengine.attribute.OrderMissingLastAttribute;

public class AttributeOrder<O> {
    private final Attribute<O, ? extends Comparable> attribute;
    private final boolean descending;

    public AttributeOrder(Attribute<O, ? extends Comparable> attribute, boolean descending) {
        this.attribute = attribute;
        this.descending = descending;
    }

    public Attribute<O, ? extends Comparable> getAttribute() {
        return this.attribute;
    }

    public boolean isDescending() {
        return this.descending;
    }

    public String toString() {
        if (this.attribute instanceof OrderMissingLastAttribute) {
            OrderControlAttribute orderControlAttribute = (OrderControlAttribute)this.attribute;
            Attribute delegateAttribute = orderControlAttribute.getDelegateAttribute();
            return this.descending ? "descending(missingLast(" + delegateAttribute.getObjectType().getSimpleName() + "." + delegateAttribute.getAttributeName() + "))" : "ascending(missingLast(" + delegateAttribute.getObjectType().getSimpleName() + "." + delegateAttribute.getAttributeName() + "))";
        }
        if (this.attribute instanceof OrderMissingFirstAttribute) {
            OrderControlAttribute orderControlAttribute = (OrderControlAttribute)this.attribute;
            Attribute delegateAttribute = orderControlAttribute.getDelegateAttribute();
            return this.descending ? "descending(missingFirst(" + delegateAttribute.getObjectType().getSimpleName() + "." + delegateAttribute.getAttributeName() + "))" : "ascending(missingFirst(" + delegateAttribute.getObjectType().getSimpleName() + "." + delegateAttribute.getAttributeName() + "))";
        }
        return this.descending ? "descending(" + this.attribute.getObjectType().getSimpleName() + "." + this.attribute.getAttributeName() + ")" : "ascending(" + this.attribute.getObjectType().getSimpleName() + "." + this.attribute.getAttributeName() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AttributeOrder)) {
            return false;
        }
        AttributeOrder that = (AttributeOrder)o;
        if (this.descending != that.descending) {
            return false;
        }
        return this.attribute.equals(that.attribute);
    }

    public int hashCode() {
        int result2 = this.attribute.hashCode();
        result2 = 31 * result2 + (this.descending ? 1 : 0);
        return result2;
    }
}

