/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.googlecode.cqengine.query.option;

import selogger.com.googlecode.cqengine.query.option.DeduplicationStrategy;
import selogger.com.googlecode.cqengine.query.option.QueryOptions;

public class DeduplicationOption {
    private final DeduplicationStrategy strategy;

    public DeduplicationOption(DeduplicationStrategy strategy) {
        this.strategy = strategy;
    }

    public DeduplicationStrategy getStrategy() {
        return this.strategy;
    }

    public static <O> boolean isLogicalElimination(QueryOptions queryOptions) {
        DeduplicationOption option = queryOptions.get(DeduplicationOption.class);
        return option != null && DeduplicationStrategy.LOGICAL_ELIMINATION.equals((Object)option.getStrategy());
    }

    public static <O> boolean isMaterialize(QueryOptions queryOptions) {
        DeduplicationOption option = queryOptions.get(DeduplicationOption.class);
        return option != null && DeduplicationStrategy.MATERIALIZE.equals((Object)option.getStrategy());
    }

    public String toString() {
        return "deduplicate(" + (Object)((Object)this.strategy) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeduplicationOption)) {
            return false;
        }
        DeduplicationOption that = (DeduplicationOption)o;
        return this.strategy == that.strategy;
    }

    public int hashCode() {
        return this.strategy.hashCode();
    }
}

