/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.googlecode.cqengine.query.parser.common;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import selogger.com.googlecode.cqengine.IndexedCollection;
import selogger.com.googlecode.cqengine.attribute.Attribute;
import selogger.com.googlecode.cqengine.query.Query;
import selogger.com.googlecode.cqengine.query.option.QueryOptions;
import selogger.com.googlecode.cqengine.query.parser.common.InvalidQueryException;
import selogger.com.googlecode.cqengine.query.parser.common.ParseResult;
import selogger.com.googlecode.cqengine.query.parser.common.ValueParser;
import selogger.com.googlecode.cqengine.query.parser.common.valuetypes.BigDecimalParser;
import selogger.com.googlecode.cqengine.query.parser.common.valuetypes.BigIntegerParser;
import selogger.com.googlecode.cqengine.query.parser.common.valuetypes.BooleanParser;
import selogger.com.googlecode.cqengine.query.parser.common.valuetypes.ByteParser;
import selogger.com.googlecode.cqengine.query.parser.common.valuetypes.CharacterParser;
import selogger.com.googlecode.cqengine.query.parser.common.valuetypes.DoubleParser;
import selogger.com.googlecode.cqengine.query.parser.common.valuetypes.FloatParser;
import selogger.com.googlecode.cqengine.query.parser.common.valuetypes.IntegerParser;
import selogger.com.googlecode.cqengine.query.parser.common.valuetypes.LongParser;
import selogger.com.googlecode.cqengine.query.parser.common.valuetypes.ShortParser;
import selogger.com.googlecode.cqengine.resultset.ResultSet;

public abstract class QueryParser<O> {
    protected final Class<O> objectType;
    protected final Map<String, Attribute<O, ?>> attributes = new HashMap();
    protected final Map<Class<?>, ValueParser<?>> valueParsers = new HashMap();
    protected volatile ValueParser<Object> fallbackValueParser = null;
    protected static final BaseErrorListener SYNTAX_ERROR_LISTENER = new BaseErrorListener(){

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) throws ParseCancellationException {
            throw new InvalidQueryException("Failed to parse query at line " + line + ":" + charPositionInLine + ": " + msg);
        }
    };

    public QueryParser(Class<O> objectType) {
        this.registerValueParser(Boolean.class, new BooleanParser());
        this.registerValueParser(Byte.class, new ByteParser());
        this.registerValueParser(Character.class, new CharacterParser());
        this.registerValueParser(Short.class, new ShortParser());
        this.registerValueParser(Integer.class, new IntegerParser());
        this.registerValueParser(Long.class, new LongParser());
        this.registerValueParser(Float.class, new FloatParser());
        this.registerValueParser(Double.class, new DoubleParser());
        this.registerValueParser(BigInteger.class, new BigIntegerParser());
        this.registerValueParser(BigDecimal.class, new BigDecimalParser());
        this.objectType = objectType;
    }

    public <A> void registerAttribute(Attribute<O, A> attribute) {
        this.attributes.put(attribute.getAttributeName(), attribute);
    }

    public void registerAttributes(Map<String, ? extends Attribute<O, ?>> attributes) {
        this.registerAttributes(attributes.values());
    }

    public void registerAttributes(Iterable<? extends Attribute<O, ?>> attributes) {
        for (Attribute<O, ?> attribute : attributes) {
            this.registerAttribute(attribute);
        }
    }

    public <A> void registerValueParser(Class<A> valueType, ValueParser<A> valueParser) {
        this.valueParsers.put(valueType, valueParser);
    }

    public void registerFallbackValueParser(ValueParser<Object> fallbackValueParser) {
        this.fallbackValueParser = fallbackValueParser;
    }

    public Class<O> getObjectType() {
        return this.objectType;
    }

    public <A> Attribute<O, A> getAttribute(ParseTree attributeNameContext, Class<A> expectedSuperType) {
        String attributeName = this.parseValue(String.class, attributeNameContext.getText());
        Attribute<O, ?> attribute = this.attributes.get(attributeName);
        if (attribute == null) {
            throw new IllegalStateException("No such attribute has been registered with the parser: " + attributeName);
        }
        if (!expectedSuperType.isAssignableFrom(attribute.getAttributeType())) {
            throw new IllegalStateException("Non-" + expectedSuperType.getSimpleName() + " attribute used in a query which requires a " + expectedSuperType.getSimpleName() + " attribute: " + attribute.getAttributeName());
        }
        Attribute<O, ?> result2 = attribute;
        return result2;
    }

    public <A> A parseValue(Attribute<O, A> attribute, ParseTree parameterContext) {
        return this.parseValue(attribute.getAttributeType(), parameterContext.getText());
    }

    public <A> A parseValue(Class<A> valueType, ParseTree parameterContext) {
        return this.parseValue(valueType, parameterContext.getText());
    }

    public <A> A parseValue(Class<A> valueType, String text) {
        ValueParser<?> valueParser = this.valueParsers.get(valueType);
        if (valueParser != null) {
            return (A)valueParser.validatedParse(valueType, text);
        }
        ValueParser<Object> fallbackValueParser = this.fallbackValueParser;
        if (fallbackValueParser != null) {
            return valueType.cast(fallbackValueParser.parse(valueType, text));
        }
        throw new IllegalStateException("No value parser has been registered to parse type: " + valueType.getName());
    }

    public abstract ParseResult<O> parse(String var1);

    public ResultSet<O> retrieve(IndexedCollection<O> collection, String query) {
        ParseResult<O> parseResult = this.parse(query);
        return collection.retrieve(parseResult.getQuery(), parseResult.getQueryOptions());
    }

    public Query<O> query(String query) {
        return this.parse(query).getQuery();
    }

    public QueryOptions queryOptions(String query) {
        return this.parse(query).getQueryOptions();
    }
}

