/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.googlecode.cqengine.query.parser.cqn.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import selogger.com.googlecode.cqengine.attribute.Attribute;
import selogger.com.googlecode.cqengine.query.Query;
import selogger.com.googlecode.cqengine.query.QueryFactory;
import selogger.com.googlecode.cqengine.query.logical.And;
import selogger.com.googlecode.cqengine.query.logical.Or;
import selogger.com.googlecode.cqengine.query.option.AttributeOrder;
import selogger.com.googlecode.cqengine.query.option.QueryOptions;
import selogger.com.googlecode.cqengine.query.parser.common.ParserUtils;
import selogger.com.googlecode.cqengine.query.parser.common.QueryParser;
import selogger.com.googlecode.cqengine.query.parser.cqn.grammar.CQNGrammarBaseListener;
import selogger.com.googlecode.cqengine.query.parser.cqn.grammar.CQNGrammarParser;

public class CQNAntlrListener<O>
extends CQNGrammarBaseListener {
    protected final QueryParser<O> queryParser;
    protected final Map<ParserRuleContext, Collection<Query<O>>> childQueries = new HashMap<ParserRuleContext, Collection<Query<O>>>();
    protected int numQueriesEncountered = 0;
    protected int numQueriesParsed = 0;
    protected final List<AttributeOrder<O>> attributeOrders = new LinkedList<AttributeOrder<O>>();

    public CQNAntlrListener(QueryParser<O> queryParser) {
        this.queryParser = queryParser;
    }

    @Override
    public void exitAndQuery(CQNGrammarParser.AndQueryContext ctx) {
        this.addParsedQuery(ctx, new And<O>(this.childQueries.get(ctx)));
    }

    @Override
    public void exitOrQuery(CQNGrammarParser.OrQueryContext ctx) {
        this.addParsedQuery(ctx, new Or<O>(this.childQueries.get(ctx)));
    }

    @Override
    public void exitNotQuery(CQNGrammarParser.NotQueryContext ctx) {
        this.addParsedQuery(ctx, QueryFactory.not(this.childQueries.get(ctx).iterator().next()));
    }

    @Override
    public void exitEqualQuery(CQNGrammarParser.EqualQueryContext ctx) {
        Attribute<O, Object> attribute = this.queryParser.getAttribute(ctx.attributeName(), Object.class);
        Object value = this.queryParser.parseValue(attribute, (ParseTree)ctx.queryParameter());
        this.addParsedQuery(ctx, QueryFactory.equal(attribute, value));
    }

    @Override
    public void exitLessThanOrEqualToQuery(CQNGrammarParser.LessThanOrEqualToQueryContext ctx) {
        Attribute<O, Comparable> attribute = this.queryParser.getAttribute(ctx.attributeName(), Comparable.class);
        Comparable value = this.queryParser.parseValue(attribute, (ParseTree)ctx.queryParameter());
        this.addParsedQuery(ctx, QueryFactory.lessThanOrEqualTo(attribute, value));
    }

    @Override
    public void exitLessThanQuery(CQNGrammarParser.LessThanQueryContext ctx) {
        Attribute<O, Comparable> attribute = this.queryParser.getAttribute(ctx.attributeName(), Comparable.class);
        Comparable value = this.queryParser.parseValue(attribute, (ParseTree)ctx.queryParameter());
        this.addParsedQuery(ctx, QueryFactory.lessThan(attribute, value));
    }

    @Override
    public void exitGreaterThanOrEqualToQuery(CQNGrammarParser.GreaterThanOrEqualToQueryContext ctx) {
        Attribute<O, Comparable> attribute = this.queryParser.getAttribute(ctx.attributeName(), Comparable.class);
        Comparable value = this.queryParser.parseValue(attribute, (ParseTree)ctx.queryParameter());
        this.addParsedQuery(ctx, QueryFactory.greaterThanOrEqualTo(attribute, value));
    }

    @Override
    public void exitGreaterThanQuery(CQNGrammarParser.GreaterThanQueryContext ctx) {
        Attribute<O, Comparable> attribute = this.queryParser.getAttribute(ctx.attributeName(), Comparable.class);
        Comparable value = this.queryParser.parseValue(attribute, (ParseTree)ctx.queryParameter());
        this.addParsedQuery(ctx, QueryFactory.greaterThan(attribute, value));
    }

    @Override
    public void exitVerboseBetweenQuery(CQNGrammarParser.VerboseBetweenQueryContext ctx) {
        Attribute<O, Comparable> attribute = this.queryParser.getAttribute(ctx.attributeName(), Comparable.class);
        List<CQNGrammarParser.QueryParameterContext> queryParameters = ctx.queryParameter();
        List<TerminalNode> booleanParameters = ctx.BooleanLiteral();
        Comparable lowerValue = this.queryParser.parseValue(attribute, (ParseTree)queryParameters.get(0));
        boolean lowerInclusive = this.queryParser.parseValue(Boolean.class, (ParseTree)booleanParameters.get(0));
        Comparable upperValue = this.queryParser.parseValue(attribute, (ParseTree)queryParameters.get(1));
        boolean upperInclusive = this.queryParser.parseValue(Boolean.class, (ParseTree)booleanParameters.get(1));
        this.addParsedQuery(ctx, QueryFactory.between(attribute, lowerValue, lowerInclusive, upperValue, upperInclusive));
    }

    @Override
    public void exitBetweenQuery(CQNGrammarParser.BetweenQueryContext ctx) {
        Attribute<O, Comparable> attribute = this.queryParser.getAttribute(ctx.attributeName(), Comparable.class);
        List<CQNGrammarParser.QueryParameterContext> queryParameters = ctx.queryParameter();
        Comparable lowerValue = this.queryParser.parseValue(attribute, (ParseTree)queryParameters.get(0));
        Comparable upperValue = this.queryParser.parseValue(attribute, (ParseTree)queryParameters.get(1));
        this.addParsedQuery(ctx, QueryFactory.between(attribute, lowerValue, upperValue));
    }

    @Override
    public void exitInQuery(CQNGrammarParser.InQueryContext ctx) {
        Attribute<O, Object> attribute = this.queryParser.getAttribute(ctx.attributeName(), Object.class);
        List<CQNGrammarParser.QueryParameterContext> queryParameters = ctx.queryParameter();
        ArrayList<Object> values2 = new ArrayList<Object>(queryParameters.size());
        for (ParseTree parseTree : queryParameters) {
            Object value = this.queryParser.parseValue(attribute, parseTree);
            values2.add(value);
        }
        this.addParsedQuery(ctx, QueryFactory.in(attribute, values2));
    }

    @Override
    public void exitStartsWithQuery(CQNGrammarParser.StartsWithQueryContext ctx) {
        Attribute<O, String> attribute = this.queryParser.getAttribute(ctx.attributeName(), String.class);
        String value = this.queryParser.parseValue(attribute, (ParseTree)ctx.stringQueryParameter());
        this.addParsedQuery(ctx, QueryFactory.startsWith(attribute, value));
    }

    @Override
    public void exitEndsWithQuery(CQNGrammarParser.EndsWithQueryContext ctx) {
        Attribute<O, String> attribute = this.queryParser.getAttribute(ctx.attributeName(), String.class);
        String value = this.queryParser.parseValue(attribute, (ParseTree)ctx.stringQueryParameter());
        this.addParsedQuery(ctx, QueryFactory.endsWith(attribute, value));
    }

    @Override
    public void exitContainsQuery(CQNGrammarParser.ContainsQueryContext ctx) {
        Attribute<O, String> attribute = this.queryParser.getAttribute(ctx.attributeName(), String.class);
        String value = this.queryParser.parseValue(attribute, (ParseTree)ctx.stringQueryParameter());
        this.addParsedQuery(ctx, QueryFactory.contains(attribute, value));
    }

    @Override
    public void exitIsContainedInQuery(CQNGrammarParser.IsContainedInQueryContext ctx) {
        Attribute<O, String> attribute = this.queryParser.getAttribute(ctx.attributeName(), String.class);
        String value = this.queryParser.parseValue(attribute, (ParseTree)ctx.stringQueryParameter());
        this.addParsedQuery(ctx, QueryFactory.isContainedIn(attribute, value));
    }

    @Override
    public void exitMatchesRegexQuery(CQNGrammarParser.MatchesRegexQueryContext ctx) {
        Attribute<O, String> attribute = this.queryParser.getAttribute(ctx.attributeName(), String.class);
        String value = this.queryParser.parseValue(attribute, (ParseTree)ctx.stringQueryParameter());
        this.addParsedQuery(ctx, QueryFactory.matchesRegex(attribute, value));
    }

    @Override
    public void exitHasQuery(CQNGrammarParser.HasQueryContext ctx) {
        Attribute<O, Object> attribute = this.queryParser.getAttribute(ctx.attributeName(), Object.class);
        this.addParsedQuery(ctx, QueryFactory.has(attribute));
    }

    @Override
    public void exitAllQuery(CQNGrammarParser.AllQueryContext ctx) {
        ParserUtils.validateObjectTypeParameter(this.queryParser.getObjectType(), ctx.objectType().getText());
        this.addParsedQuery(ctx, QueryFactory.all(this.queryParser.getObjectType()));
    }

    @Override
    public void exitNoneQuery(CQNGrammarParser.NoneQueryContext ctx) {
        ParserUtils.validateObjectTypeParameter(this.queryParser.getObjectType(), ctx.objectType().getText());
        this.addParsedQuery(ctx, QueryFactory.none(this.queryParser.getObjectType()));
    }

    @Override
    public void exitLongestPrefixQuery(CQNGrammarParser.LongestPrefixQueryContext ctx) {
        Attribute<O, String> attribute = this.queryParser.getAttribute(ctx.attributeName(), String.class);
        String value = this.queryParser.parseValue(attribute, (ParseTree)ctx.stringQueryParameter());
        this.addParsedQuery(ctx, QueryFactory.longestPrefix(attribute, value));
    }

    @Override
    public void exitIsPrefixOfQuery(CQNGrammarParser.IsPrefixOfQueryContext ctx) {
        Attribute<O, String> attribute = this.queryParser.getAttribute(ctx.attributeName(), String.class);
        String value = this.queryParser.parseValue(attribute, (ParseTree)ctx.stringQueryParameter());
        this.addParsedQuery(ctx, QueryFactory.isPrefixOf(attribute, value));
    }

    @Override
    public void exitQuery(CQNGrammarParser.QueryContext ctx) {
        ++this.numQueriesEncountered;
        ParserUtils.validateAllQueriesParsed(this.numQueriesEncountered, this.numQueriesParsed);
    }

    @Override
    public void exitOrderByOption(CQNGrammarParser.OrderByOptionContext ctx) {
        for (CQNGrammarParser.AttributeOrderContext attributeOrderContext : ctx.attributeOrder()) {
            Attribute<O, Comparable> attribute = this.queryParser.getAttribute(attributeOrderContext.attributeName(), Comparable.class);
            boolean descending = "descending".equals(attributeOrderContext.direction().getText());
            this.attributeOrders.add(new AttributeOrder<O>(attribute, descending));
        }
    }

    void addParsedQuery(ParserRuleContext currentContext, Query<O> parsedQuery) {
        ParserRuleContext parentContext = ParserUtils.getParentContextOfType(currentContext, this.getAndOrNotContextClasses());
        Collection<Query<O>> childrenOfParent = this.childQueries.get(parentContext);
        if (childrenOfParent == null) {
            childrenOfParent = new ArrayList<Query<O>>();
            this.childQueries.put(parentContext, childrenOfParent);
        }
        childrenOfParent.add(parsedQuery);
        ++this.numQueriesParsed;
    }

    public Query<O> getParsedQuery() {
        Collection<Query<O>> rootQuery = this.childQueries.get(null);
        ParserUtils.validateExpectedNumberOfChildQueries(1, rootQuery.size());
        return rootQuery.iterator().next();
    }

    public QueryOptions getQueryOptions() {
        return this.attributeOrders.isEmpty() ? QueryFactory.noQueryOptions() : QueryFactory.queryOptions(QueryFactory.orderBy(this.attributeOrders));
    }

    protected Class[] getAndOrNotContextClasses() {
        return new Class[]{CQNGrammarParser.AndQueryContext.class, CQNGrammarParser.OrQueryContext.class, CQNGrammarParser.NotQueryContext.class};
    }
}

