/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.googlecode.cqengine.query.simple;

import java.util.Objects;
import selogger.com.googlecode.cqengine.IndexedCollection;
import selogger.com.googlecode.cqengine.attribute.Attribute;
import selogger.com.googlecode.cqengine.attribute.SimpleAttribute;
import selogger.com.googlecode.cqengine.query.Query;
import selogger.com.googlecode.cqengine.query.QueryFactory;
import selogger.com.googlecode.cqengine.query.option.QueryOptions;
import selogger.com.googlecode.cqengine.query.simple.SimpleQuery;
import selogger.com.googlecode.cqengine.resultset.ResultSet;

public class ExistsIn<O, F, A>
extends SimpleQuery<O, A> {
    final IndexedCollection<F> foreignCollection;
    final Attribute<O, A> localKeyAttribute;
    final Attribute<F, A> foreignKeyAttribute;
    final Query<F> foreignRestrictions;

    public ExistsIn(IndexedCollection<F> foreignCollection, Attribute<O, A> localKeyAttribute, Attribute<F, A> foreignKeyAttribute) {
        this(foreignCollection, localKeyAttribute, foreignKeyAttribute, null);
    }

    public ExistsIn(IndexedCollection<F> foreignCollection, Attribute<O, A> localKeyAttribute, Attribute<F, A> foreignKeyAttribute, Query<F> foreignRestrictions) {
        super(Objects.requireNonNull(localKeyAttribute, "The localKeyAttribute cannot be null"));
        this.foreignCollection = Objects.requireNonNull(foreignCollection, "The foreignCollection cannot be null");
        this.localKeyAttribute = Objects.requireNonNull(localKeyAttribute, "The localKeyAttribute cannot be null");
        this.foreignKeyAttribute = Objects.requireNonNull(foreignKeyAttribute, "The foreignKeyAttribute cannot be null");
        this.foreignRestrictions = foreignRestrictions;
    }

    @Override
    protected boolean matchesSimpleAttribute(SimpleAttribute<O, A> attribute, O object, QueryOptions queryOptions) {
        A localValue = attribute.getValue(object, queryOptions);
        return this.foreignRestrictions == null ? ExistsIn.foreignCollectionContains(this.foreignCollection, QueryFactory.equal(this.foreignKeyAttribute, localValue)) : ExistsIn.foreignCollectionContains(this.foreignCollection, QueryFactory.and(QueryFactory.equal(this.foreignKeyAttribute, localValue), this.foreignRestrictions));
    }

    @Override
    protected boolean matchesNonSimpleAttribute(Attribute<O, A> attribute, O object, QueryOptions queryOptions) {
        if (this.foreignRestrictions == null) {
            for (A localValue : attribute.getValues(object, queryOptions)) {
                boolean contained = ExistsIn.foreignCollectionContains(this.foreignCollection, QueryFactory.equal(this.foreignKeyAttribute, localValue));
                if (!contained) continue;
                return true;
            }
            return false;
        }
        for (A localValue : attribute.getValues(object, queryOptions)) {
            boolean contained = ExistsIn.foreignCollectionContains(this.foreignCollection, QueryFactory.and(QueryFactory.equal(this.foreignKeyAttribute, localValue), this.foreignRestrictions));
            if (!contained) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.foreignRestrictions == null) {
            return "existsIn(IndexedCollection<" + this.foreignKeyAttribute.getObjectType().getSimpleName() + ">, " + ExistsIn.asLiteral(this.localKeyAttribute.getAttributeName()) + ", " + ExistsIn.asLiteral(this.foreignKeyAttribute.getAttributeName()) + ")";
        }
        return "existsIn(IndexedCollection<" + this.foreignKeyAttribute.getObjectType().getSimpleName() + ">, " + ExistsIn.asLiteral(this.localKeyAttribute.getAttributeName()) + ", " + ExistsIn.asLiteral(this.foreignKeyAttribute.getAttributeName()) + ", " + this.foreignRestrictions + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExistsIn)) {
            return false;
        }
        ExistsIn existsIn = (ExistsIn)o;
        if (!this.foreignKeyAttribute.equals(existsIn.foreignKeyAttribute)) {
            return false;
        }
        if (this.foreignRestrictions != null ? !this.foreignRestrictions.equals(existsIn.foreignRestrictions) : existsIn.foreignRestrictions != null) {
            return false;
        }
        if (!this.localKeyAttribute.equals(existsIn.localKeyAttribute)) {
            return false;
        }
        return this.foreignCollection.equals(existsIn.foreignCollection);
    }

    @Override
    protected int calcHashCode() {
        int result2 = System.identityHashCode(this.foreignCollection);
        result2 = 31 * result2 + this.localKeyAttribute.hashCode();
        result2 = 31 * result2 + this.foreignKeyAttribute.hashCode();
        result2 = 31 * result2 + (this.foreignRestrictions != null ? this.foreignRestrictions.hashCode() : 0);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <F> boolean foreignCollectionContains(IndexedCollection<F> foreignCollection, Query<F> query) {
        try (ResultSet<F> resultSet = foreignCollection.retrieve(query);){
            boolean bl = resultSet.isNotEmpty();
            return bl;
        }
    }
}

