/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.googlecode.cqengine.query.simple;

import selogger.com.googlecode.cqengine.attribute.Attribute;
import selogger.com.googlecode.cqengine.attribute.SimpleAttribute;
import selogger.com.googlecode.cqengine.query.option.QueryOptions;
import selogger.com.googlecode.cqengine.query.simple.SimpleQuery;
import selogger.com.googlecode.cqengine.query.support.QueryValidation;

public class GreaterThan<O, A extends Comparable<A>>
extends SimpleQuery<O, A> {
    private final A value;
    private final boolean valueInclusive;

    public GreaterThan(Attribute<O, A> attribute, A value, boolean valueInclusive) {
        super(attribute);
        this.value = (Comparable)QueryValidation.checkQueryValueNotNull(value);
        this.valueInclusive = valueInclusive;
    }

    public A getValue() {
        return this.value;
    }

    public boolean isValueInclusive() {
        return this.valueInclusive;
    }

    public String toString() {
        if (this.valueInclusive) {
            return "greaterThanOrEqualTo(" + GreaterThan.asLiteral(super.getAttributeName()) + ", " + GreaterThan.asLiteral(this.value) + ")";
        }
        return "greaterThan(" + GreaterThan.asLiteral(super.getAttributeName()) + ", " + GreaterThan.asLiteral(this.value) + ")";
    }

    @Override
    protected boolean matchesSimpleAttribute(SimpleAttribute<O, A> attribute, O object, QueryOptions queryOptions) {
        Comparable attributeValue = (Comparable)attribute.getValue(object, queryOptions);
        if (this.valueInclusive) {
            return this.value.compareTo((Comparable)attributeValue) <= 0;
        }
        return this.value.compareTo((Comparable)attributeValue) < 0;
    }

    @Override
    protected boolean matchesNonSimpleAttribute(Attribute<O, A> attribute, O object, QueryOptions queryOptions) {
        Iterable<A> attributeValues = attribute.getValues(object, queryOptions);
        if (this.valueInclusive) {
            for (Comparable attributeValue : attributeValues) {
                if (this.value.compareTo((Comparable)attributeValue) > 0) continue;
                return true;
            }
        } else {
            for (Comparable attributeValue : attributeValues) {
                if (this.value.compareTo((Comparable)attributeValue) >= 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GreaterThan)) {
            return false;
        }
        GreaterThan that = (GreaterThan)o;
        if (!this.attribute.equals(that.attribute)) {
            return false;
        }
        if (this.valueInclusive != that.valueInclusive) {
            return false;
        }
        return this.value.equals(that.value);
    }

    @Override
    protected int calcHashCode() {
        int result2 = this.attribute.hashCode();
        result2 = 31 * result2 + this.value.hashCode();
        result2 = 31 * result2 + (this.valueInclusive ? 1 : 0);
        return result2;
    }
}

