/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.googlecode.cqengine.query.simple;

import java.util.Set;
import selogger.com.googlecode.cqengine.attribute.Attribute;
import selogger.com.googlecode.cqengine.attribute.SimpleAttribute;
import selogger.com.googlecode.cqengine.query.option.QueryOptions;
import selogger.com.googlecode.cqengine.query.simple.SimpleQuery;

public class In<O, A>
extends SimpleQuery<O, A> {
    private final Set<A> values;
    private final boolean disjoint;

    public In(Attribute<O, A> attribute, boolean disjoint, Set<A> values2) {
        super(attribute);
        if (values2 == null || values2.size() == 0) {
            throw new IllegalArgumentException("The IN query must have at least one value.");
        }
        this.values = values2;
        this.disjoint = disjoint;
    }

    public Set<A> getValues() {
        return this.values;
    }

    public boolean isDisjoint() {
        return this.disjoint;
    }

    @Override
    protected boolean matchesSimpleAttribute(SimpleAttribute<O, A> attribute, O object, QueryOptions queryOptions) {
        return this.values.contains(attribute.getValue(object, queryOptions));
    }

    @Override
    protected boolean matchesNonSimpleAttribute(Attribute<O, A> attribute, O object, QueryOptions queryOptions) {
        for (A attributeValue : attribute.getValues(object, queryOptions)) {
            if (!this.values.contains(attributeValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int calcHashCode() {
        int result2 = this.attribute.hashCode();
        result2 = 31 * result2 + this.values.hashCode();
        result2 = 31 * result2 + (this.disjoint ? 1 : 0);
        return result2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof In)) {
            return false;
        }
        In in = (In)o;
        if (this.disjoint != in.disjoint) {
            return false;
        }
        if (!this.attribute.equals(in.attribute)) {
            return false;
        }
        return this.values.equals(in.values);
    }

    public String toString() {
        return "in(" + In.asLiteral(super.getAttributeName()) + ", " + In.asLiteral(this.values) + ")";
    }
}

