/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.googlecode.cqengine.query.simple;

import selogger.com.googlecode.cqengine.attribute.Attribute;
import selogger.com.googlecode.cqengine.attribute.SimpleAttribute;
import selogger.com.googlecode.cqengine.query.Query;
import selogger.com.googlecode.cqengine.query.option.QueryOptions;

public abstract class SimpleQuery<O, A>
implements Query<O> {
    protected final boolean attributeIsSimple;
    protected final Attribute<O, A> attribute;
    protected final SimpleAttribute<O, A> simpleAttribute;
    private transient int cachedHashCode = 0;

    public SimpleQuery(Attribute<O, A> attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException("The attribute argument was null.");
        }
        this.attribute = attribute;
        if (attribute instanceof SimpleAttribute) {
            this.attributeIsSimple = true;
            this.simpleAttribute = (SimpleAttribute)attribute;
        } else {
            this.attributeIsSimple = false;
            this.simpleAttribute = null;
        }
    }

    public Class<A> getAttributeType() {
        return this.attribute.getAttributeType();
    }

    public String getAttributeName() {
        return this.attribute.getAttributeName();
    }

    public Attribute<O, A> getAttribute() {
        return this.attribute;
    }

    @Override
    public final boolean matches(O object, QueryOptions queryOptions) {
        if (this.attributeIsSimple) {
            return this.matchesSimpleAttribute(this.simpleAttribute, object, queryOptions);
        }
        return this.matchesNonSimpleAttribute(this.attribute, object, queryOptions);
    }

    protected abstract boolean matchesSimpleAttribute(SimpleAttribute<O, A> var1, O var2, QueryOptions var3);

    protected abstract boolean matchesNonSimpleAttribute(Attribute<O, A> var1, O var2, QueryOptions var3);

    public int hashCode() {
        int h = this.cachedHashCode;
        if (h == 0) {
            h = this.calcHashCode();
            if (h == 0) {
                h = -1838660945;
            }
            this.cachedHashCode = h;
        }
        return h;
    }

    protected abstract int calcHashCode();

    public static String asLiteral(Object value) {
        return value instanceof String ? "\"" + value + "\"" : String.valueOf(value);
    }

    public static String asLiteral(String value) {
        return "\"" + value + "\"";
    }
}

