/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.googlecode.cqengine.query.simple;

import selogger.com.googlecode.cqengine.attribute.Attribute;
import selogger.com.googlecode.cqengine.attribute.SimpleAttribute;
import selogger.com.googlecode.cqengine.query.option.QueryOptions;
import selogger.com.googlecode.cqengine.query.simple.SimpleQuery;
import selogger.com.googlecode.cqengine.query.support.QueryValidation;

public class StringContains<O, A extends CharSequence>
extends SimpleQuery<O, A> {
    private final A value;

    public StringContains(Attribute<O, A> attribute, A value) {
        super(attribute);
        this.value = (CharSequence)QueryValidation.checkQueryValueNotNull(value);
    }

    public A getValue() {
        return this.value;
    }

    @Override
    protected boolean matchesSimpleAttribute(SimpleAttribute<O, A> attribute, O object, QueryOptions queryOptions) {
        CharSequence attributeValue = (CharSequence)attribute.getValue(object, queryOptions);
        return StringContains.containsFragment(attributeValue, this.value);
    }

    @Override
    protected boolean matchesNonSimpleAttribute(Attribute<O, A> attribute, O object, QueryOptions queryOptions) {
        for (CharSequence attributeValue : attribute.getValues(object, queryOptions)) {
            if (!StringContains.containsFragment(attributeValue, this.value)) continue;
            return true;
        }
        return false;
    }

    static boolean containsFragment(CharSequence document, CharSequence fragment) {
        int documentLength = document.length();
        int fragmentLength = fragment.length();
        int lastStartOffset = documentLength - fragmentLength;
        for (int startOffset = 0; startOffset <= lastStartOffset; ++startOffset) {
            char fragmentChar;
            char documentChar;
            int charsMatched = 0;
            int endOffset = startOffset;
            int j = 0;
            while (j < fragmentLength && (documentChar = document.charAt(endOffset)) == (fragmentChar = fragment.charAt(j))) {
                ++charsMatched;
                ++j;
                ++endOffset;
            }
            if (charsMatched != fragmentLength) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringContains)) {
            return false;
        }
        StringContains that = (StringContains)o;
        if (!this.attribute.equals(that.attribute)) {
            return false;
        }
        return this.value.equals(that.value);
    }

    @Override
    protected int calcHashCode() {
        int result2 = this.attribute.hashCode();
        result2 = 31 * result2 + this.value.hashCode();
        return result2;
    }

    public String toString() {
        return "contains(" + StringContains.asLiteral(super.getAttributeName()) + ", " + StringContains.asLiteral(this.value) + ")";
    }
}

