/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.googlecode.cqengine.resultset;

import java.io.Closeable;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import selogger.com.googlecode.cqengine.query.Query;
import selogger.com.googlecode.cqengine.query.option.QueryOptions;
import selogger.com.googlecode.cqengine.resultset.common.NoSuchObjectException;
import selogger.com.googlecode.cqengine.resultset.common.NonUniqueObjectException;

public abstract class ResultSet<O>
implements Iterable<O>,
Closeable {
    @Override
    public abstract Iterator<O> iterator();

    public abstract boolean contains(O var1);

    public abstract boolean matches(O var1);

    public abstract Query<O> getQuery();

    public abstract QueryOptions getQueryOptions();

    public O uniqueResult() {
        Iterator<O> iterator2 = this.iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchObjectException("ResultSet is empty");
        }
        O result2 = iterator2.next();
        if (iterator2.hasNext()) {
            throw new NonUniqueObjectException("ResultSet contains more than one object");
        }
        return result2;
    }

    public abstract int getRetrievalCost();

    public abstract int getMergeCost();

    public abstract int size();

    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    public boolean isNotEmpty() {
        return this.iterator().hasNext();
    }

    @Override
    public abstract void close();

    @Override
    public Spliterator<O> spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 16);
    }

    public Stream<O> stream() {
        return (Stream)StreamSupport.stream(this.spliterator(), false).onClose(this::close);
    }
}

