/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.googlecode.cqengine.resultset.closeable;

import java.io.Closeable;
import java.util.Iterator;
import selogger.com.googlecode.cqengine.query.Query;
import selogger.com.googlecode.cqengine.query.option.QueryOptions;
import selogger.com.googlecode.cqengine.resultset.ResultSet;
import selogger.com.googlecode.cqengine.resultset.filter.FilteringResultSet;

public abstract class CloseableFilteringResultSet<O>
extends FilteringResultSet<O>
implements Closeable {
    boolean closed = false;

    public CloseableFilteringResultSet(ResultSet<O> wrappedResultSet, Query<O> query, QueryOptions queryOptions) {
        super(wrappedResultSet, query, queryOptions);
    }

    @Override
    public Iterator<O> iterator() {
        this.ensureNotClosed();
        return super.iterator();
    }

    @Override
    public int size() {
        this.ensureNotClosed();
        return super.size();
    }

    @Override
    public int getRetrievalCost() {
        this.ensureNotClosed();
        return super.getRetrievalCost();
    }

    @Override
    public int getMergeCost() {
        this.ensureNotClosed();
        return super.getMergeCost();
    }

    @Override
    public O uniqueResult() {
        this.ensureNotClosed();
        return super.uniqueResult();
    }

    @Override
    public boolean isEmpty() {
        this.ensureNotClosed();
        return super.isEmpty();
    }

    @Override
    public boolean isNotEmpty() {
        this.ensureNotClosed();
        return super.isNotEmpty();
    }

    void ensureNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("ResultSet is closed");
        }
    }

    @Override
    public void close() {
        super.close();
        this.closed = true;
    }
}

