/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.googlecode.cqengine.resultset.connective;

import java.util.Iterator;
import selogger.com.googlecode.cqengine.query.Query;
import selogger.com.googlecode.cqengine.query.option.QueryOptions;
import selogger.com.googlecode.cqengine.resultset.ResultSet;
import selogger.com.googlecode.cqengine.resultset.common.ResultSets;
import selogger.com.googlecode.cqengine.resultset.filter.FilteringIterator;
import selogger.com.googlecode.cqengine.resultset.iterator.IteratorUtil;

public class ResultSetDifference<O>
extends ResultSet<O> {
    final ResultSet<O> firstResultSet;
    final ResultSet<O> secondResultSet;
    final Query<O> query;
    final QueryOptions queryOptions;
    final boolean indexMergeStrategyEnabled;

    public ResultSetDifference(ResultSet<O> firstResultSet, ResultSet<O> secondResultSet, Query<O> query, QueryOptions queryOptions) {
        this(firstResultSet, secondResultSet, query, queryOptions, false);
    }

    public ResultSetDifference(ResultSet<O> firstResultSet, ResultSet<O> secondResultSet, Query<O> query, QueryOptions queryOptions, boolean indexMergeStrategyEnabled) {
        this.firstResultSet = ResultSets.wrapWithCostCachingIfNecessary(firstResultSet);
        this.secondResultSet = ResultSets.wrapWithCostCachingIfNecessary(secondResultSet);
        this.query = query;
        this.queryOptions = queryOptions;
        if (indexMergeStrategyEnabled && this.secondResultSet.getRetrievalCost() == Integer.MAX_VALUE) {
            indexMergeStrategyEnabled = false;
        }
        this.indexMergeStrategyEnabled = indexMergeStrategyEnabled;
    }

    @Override
    public Iterator<O> iterator() {
        if (this.indexMergeStrategyEnabled) {
            return new FilteringIterator<O>(this.firstResultSet.iterator(), this.queryOptions){

                @Override
                public boolean isValid(O object, QueryOptions queryOptions) {
                    return !ResultSetDifference.this.secondResultSet.contains(object);
                }
            };
        }
        return new FilteringIterator<O>(this.firstResultSet.iterator(), this.queryOptions){

            @Override
            public boolean isValid(O object, QueryOptions queryOptions) {
                return !ResultSetDifference.this.secondResultSet.matches(object);
            }
        };
    }

    @Override
    public boolean contains(O object) {
        return this.firstResultSet.contains(object) && !this.secondResultSet.contains(object);
    }

    @Override
    public boolean matches(O object) {
        return this.query.matches(object, this.queryOptions);
    }

    @Override
    public int size() {
        return IteratorUtil.countElements(this);
    }

    @Override
    public int getRetrievalCost() {
        return this.firstResultSet.getRetrievalCost();
    }

    @Override
    public int getMergeCost() {
        return this.firstResultSet.getMergeCost();
    }

    @Override
    public void close() {
        this.firstResultSet.close();
        this.secondResultSet.close();
    }

    @Override
    public Query<O> getQuery() {
        return this.query;
    }

    @Override
    public QueryOptions getQueryOptions() {
        return this.queryOptions;
    }
}

