/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.googlecode.cqengine.resultset.connective;

import java.util.Iterator;
import selogger.com.googlecode.cqengine.query.Query;
import selogger.com.googlecode.cqengine.query.option.QueryOptions;
import selogger.com.googlecode.cqengine.resultset.ResultSet;
import selogger.com.googlecode.cqengine.resultset.common.ResultSets;
import selogger.com.googlecode.cqengine.resultset.iterator.ConcatenatingIterator;

public class ResultSetUnionAll<O>
extends ResultSet<O> {
    final Query<O> query;
    final QueryOptions queryOptions;
    private final Iterable<? extends ResultSet<O>> resultSets;

    public ResultSetUnionAll(Iterable<? extends ResultSet<O>> resultSets, Query<O> query, QueryOptions queryOptions) {
        this.resultSets = ResultSets.wrapWithCostCachingIfNecessary(resultSets);
        this.query = query;
        this.queryOptions = queryOptions;
    }

    @Override
    public Iterator<O> iterator() {
        return new ConcatenatingIterator<O>(){
            Iterator<? extends ResultSet<O>> resultSetsIterator;
            {
                this.resultSetsIterator = ResultSetUnionAll.this.resultSets.iterator();
            }

            @Override
            public Iterator<O> getNextIterator() {
                return this.resultSetsIterator.hasNext() ? this.resultSetsIterator.next().iterator() : null;
            }
        };
    }

    @Override
    public boolean contains(O object) {
        for (ResultSet<O> resultSet : this.resultSets) {
            if (!resultSet.contains(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(O object) {
        return this.query.matches(object, this.queryOptions);
    }

    @Override
    public int size() {
        int size = 0;
        for (ResultSet<O> resultSet : this.resultSets) {
            size += resultSet.size();
        }
        return size;
    }

    @Override
    public int getRetrievalCost() {
        long retrievalCost = 0L;
        for (ResultSet<O> resultSet : this.resultSets) {
            retrievalCost += (long)resultSet.getRetrievalCost();
        }
        return (int)Math.min(retrievalCost, Integer.MAX_VALUE);
    }

    @Override
    public int getMergeCost() {
        long mergeCost = 0L;
        for (ResultSet<O> resultSet : this.resultSets) {
            mergeCost += (long)resultSet.getMergeCost();
        }
        return (int)Math.min(mergeCost, Integer.MAX_VALUE);
    }

    @Override
    public void close() {
        for (ResultSet<O> resultSet : this.resultSets) {
            resultSet.close();
        }
    }

    @Override
    public Query<O> getQuery() {
        return this.query;
    }

    @Override
    public QueryOptions getQueryOptions() {
        return this.queryOptions;
    }
}

