/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.googlecode.cqengine.resultset.filter;

import java.util.Iterator;
import selogger.com.googlecode.cqengine.query.Query;
import selogger.com.googlecode.cqengine.query.option.QueryOptions;
import selogger.com.googlecode.cqengine.resultset.ResultSet;
import selogger.com.googlecode.cqengine.resultset.filter.FilteringIterator;
import selogger.com.googlecode.cqengine.resultset.iterator.IteratorUtil;

public abstract class FilteringResultSet<O>
extends ResultSet<O> {
    final ResultSet<O> wrappedResultSet;
    final Query<O> query;
    final QueryOptions queryOptions;

    public FilteringResultSet(ResultSet<O> wrappedResultSet, Query<O> query, QueryOptions queryOptions) {
        this.wrappedResultSet = wrappedResultSet;
        this.query = query;
        this.queryOptions = queryOptions;
    }

    @Override
    public Iterator<O> iterator() {
        return new FilteringIterator<O>(this.wrappedResultSet.iterator(), this.queryOptions){

            @Override
            public boolean isValid(O object, QueryOptions queryOptions) {
                return FilteringResultSet.this.isValid(object, queryOptions);
            }
        };
    }

    @Override
    public boolean contains(O object) {
        return IteratorUtil.iterableContains(this, object);
    }

    @Override
    public boolean matches(O object) {
        return this.query.matches(object, this.queryOptions);
    }

    public abstract boolean isValid(O var1, QueryOptions var2);

    @Override
    public int size() {
        return IteratorUtil.countElements(this);
    }

    @Override
    public int getRetrievalCost() {
        return this.wrappedResultSet.getRetrievalCost();
    }

    @Override
    public int getMergeCost() {
        return this.wrappedResultSet.getMergeCost();
    }

    @Override
    public void close() {
        this.wrappedResultSet.close();
    }

    @Override
    public Query<O> getQuery() {
        return this.query;
    }

    @Override
    public QueryOptions getQueryOptions() {
        return this.queryOptions;
    }
}

