/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.googlecode.cqengine.resultset.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import selogger.com.googlecode.cqengine.resultset.iterator.UnmodifiableIterator;

public abstract class ConcatenatingIterator<O>
extends UnmodifiableIterator<O> {
    private Iterator<O> currentIterator = null;

    @Override
    public boolean hasNext() {
        while (this.currentIterator == null || !this.currentIterator.hasNext()) {
            this.currentIterator = this.getNextIterator();
            if (this.currentIterator != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public O next() {
        Iterator<O> currentIterator = this.currentIterator;
        if (currentIterator == null) {
            throw new NoSuchElementException("No more elements");
        }
        return currentIterator.next();
    }

    public abstract Iterator<O> getNextIterator();

    public static <O> ConcatenatingIterator<O> concatenate(final Iterable<Iterator<O>> iterators) {
        return new ConcatenatingIterator<O>(){
            final Iterator<Iterator<O>> iteratorIterator;
            {
                this.iteratorIterator = iterators.iterator();
            }

            @Override
            public Iterator<O> getNextIterator() {
                return this.iteratorIterator.hasNext() ? this.iteratorIterator.next() : null;
            }
        };
    }
}

