/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.googlecode.cqengine.resultset.iterator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class MarkableIterator<T>
implements Iterator<T> {
    final Iterator<T> emptyIterator = Collections.emptyList().iterator();
    final Iterator<T> backingIterator;
    State state = State.READ;
    List<T> replayBuffer = Collections.emptyList();
    Iterator<T> replayIterator = this.emptyIterator;
    int readLimit = 0;

    public MarkableIterator(Iterator<T> backingIterator) {
        this.backingIterator = backingIterator;
    }

    @Override
    public boolean hasNext() {
        switch (this.state) {
            case READ: 
            case BUFFER: {
                return this.backingIterator.hasNext();
            }
            case REPLAY: {
                return this.replayIterator.hasNext() || this.backingIterator.hasNext();
            }
        }
        throw new IllegalStateException(String.valueOf((Object)this.state));
    }

    @Override
    public T next() {
        switch (this.state) {
            case READ: {
                return this.backingIterator.next();
            }
            case BUFFER: {
                if (this.replayBuffer.size() >= this.readLimit) {
                    this.replayBuffer.clear();
                    this.replayIterator = this.emptyIterator;
                    this.state = State.READ;
                    return this.next();
                }
                T next = this.backingIterator.next();
                this.replayBuffer.add(next);
                return next;
            }
            case REPLAY: {
                if (this.replayIterator.hasNext()) {
                    return this.replayIterator.next();
                }
                this.replayIterator = this.emptyIterator;
                this.state = State.BUFFER;
                return this.next();
            }
        }
        throw new IllegalStateException(String.valueOf((Object)this.state));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void mark(int readLimit) {
        this.readLimit = readLimit;
        switch (this.state) {
            case READ: {
                this.replayBuffer = new ArrayList<T>();
                this.replayIterator = this.emptyIterator;
                this.state = State.BUFFER;
                return;
            }
            case BUFFER: {
                this.replayBuffer.clear();
                this.replayIterator = this.emptyIterator;
                return;
            }
            case REPLAY: {
                this.replayBuffer = this.populateFromIterator(new ArrayList(), this.replayIterator);
                this.replayIterator = this.replayBuffer.iterator();
                return;
            }
        }
        throw new IllegalStateException(String.valueOf((Object)this.state));
    }

    public void reset() {
        if (this.state == State.READ) {
            throw new IllegalStateException("Iterator has not been marked or the mark has been invalidated");
        }
        this.replayIterator = this.replayBuffer.iterator();
        this.state = State.REPLAY;
    }

    List<T> populateFromIterator(List<T> collection, Iterator<T> iterator2) {
        while (iterator2.hasNext()) {
            collection.add(iterator2.next());
        }
        return collection;
    }

    static enum State {
        READ,
        BUFFER,
        REPLAY;

    }
}

