/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.googlecode.cqengine.resultset.order;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import selogger.com.googlecode.cqengine.attribute.Attribute;
import selogger.com.googlecode.cqengine.attribute.OrderControlAttribute;
import selogger.com.googlecode.cqengine.attribute.SimpleAttribute;
import selogger.com.googlecode.cqengine.query.option.AttributeOrder;
import selogger.com.googlecode.cqengine.query.option.QueryOptions;

public class AttributeOrdersComparator<O>
implements Comparator<O> {
    final List<AttributeOrder<O>> attributeSortOrders;
    final QueryOptions queryOptions;

    public AttributeOrdersComparator(List<AttributeOrder<O>> attributeSortOrders, QueryOptions queryOptions) {
        this.attributeSortOrders = attributeSortOrders;
        this.queryOptions = queryOptions;
    }

    @Override
    public int compare(O o1, O o2) {
        for (AttributeOrder<O> attributeOrder : this.attributeSortOrders) {
            int comparison;
            Attribute<O, Comparable<Object>> attribute = attributeOrder.getAttribute();
            if (attribute instanceof OrderControlAttribute) {
                OrderControlAttribute orderControl = (OrderControlAttribute)attribute;
                comparison = ((Integer)orderControl.getValue(o1, this.queryOptions)).compareTo((Integer)orderControl.getValue(o2, this.queryOptions));
                if (comparison != 0) {
                    return comparison;
                }
                attribute = orderControl.getDelegateAttribute();
            }
            if ((comparison = this.compareAttributeValues(attribute, o1, o2)) == 0) continue;
            return attributeOrder.isDescending() ? comparison * -1 : comparison;
        }
        if (o1.equals(o2)) {
            return 0;
        }
        return o1.hashCode() >= o2.hashCode() ? 1 : -1;
    }

    <A extends Comparable<A>> int compareAttributeValues(Attribute<O, A> attribute, O o1, O o2) {
        if (attribute instanceof SimpleAttribute) {
            SimpleAttribute simpleAttribute = (SimpleAttribute)attribute;
            return ((Comparable)simpleAttribute.getValue(o1, this.queryOptions)).compareTo((Comparable)simpleAttribute.getValue(o2, this.queryOptions));
        }
        Iterator<A> o1attributeValues = attribute.getValues(o1, this.queryOptions).iterator();
        Iterator<A> o2attributeValues = attribute.getValues(o2, this.queryOptions).iterator();
        while (o1attributeValues.hasNext() && o2attributeValues.hasNext()) {
            Comparable o2attributeValue;
            Comparable o1attributeValue = (Comparable)o1attributeValues.next();
            int comparison = o1attributeValue.compareTo(o2attributeValue = (Comparable)o2attributeValues.next());
            if (comparison == 0) continue;
            return comparison;
        }
        if (o2attributeValues.hasNext()) {
            return -1;
        }
        if (o1attributeValues.hasNext()) {
            return 1;
        }
        return 0;
    }
}

