/*
 * Decompiled with CFR 0.152.
 */
package selogger.com.googlecode.cqengine.resultset.order;

import java.util.Comparator;
import java.util.Iterator;
import selogger.com.googlecode.cqengine.resultset.ResultSet;
import selogger.com.googlecode.cqengine.resultset.common.WrappedResultSet;
import selogger.com.googlecode.cqengine.resultset.iterator.IteratorUtil;

public class MaterializedOrderedResultSet<O>
extends WrappedResultSet<O> {
    final Comparator<O> comparator;

    public MaterializedOrderedResultSet(ResultSet<O> wrappedResultSet, Comparator<O> comparator) {
        super(wrappedResultSet);
        this.comparator = comparator;
    }

    @Override
    public Iterator<O> iterator() {
        return IteratorUtil.materializedSort(super.iterator(), this.comparator);
    }

    @Override
    public int getMergeCost() {
        long mergeCost = super.getMergeCost();
        mergeCost = (mergeCost = 2L * mergeCost + mergeCost * (long)Math.log(mergeCost)) < 0L ? Long.MAX_VALUE : mergeCost;
        return (int)Math.min(mergeCost, Integer.MAX_VALUE);
    }

    @Override
    public int size() {
        return IteratorUtil.countElements(this);
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedResultSet.isEmpty();
    }

    @Override
    public boolean isNotEmpty() {
        return this.wrappedResultSet.isNotEmpty();
    }
}

