/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.io;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.util.Pool;
import java.io.IOException;
import java.io.OutputStream;

public class Output
extends OutputStream
implements AutoCloseable,
Pool.Poolable {
    protected int maxCapacity;
    protected long total;
    protected int position;
    protected int capacity;
    protected byte[] buffer;
    protected OutputStream outputStream;
    protected boolean varEncoding = true;

    public Output() {
    }

    public Output(int bufferSize) {
        this(bufferSize, bufferSize);
    }

    public Output(int bufferSize, int maxBufferSize) {
        if (bufferSize > maxBufferSize && maxBufferSize != -1) {
            throw new IllegalArgumentException("bufferSize: " + bufferSize + " cannot be greater than maxBufferSize: " + maxBufferSize);
        }
        if (maxBufferSize < -1) {
            throw new IllegalArgumentException("maxBufferSize cannot be < -1: " + maxBufferSize);
        }
        this.capacity = bufferSize;
        this.maxCapacity = maxBufferSize == -1 ? 0x7FFFFFF7 : maxBufferSize;
        this.buffer = new byte[bufferSize];
    }

    public Output(byte[] buffer) {
        this(buffer, buffer.length);
    }

    public Output(byte[] buffer, int maxBufferSize) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer cannot be null.");
        }
        this.setBuffer(buffer, maxBufferSize);
    }

    public Output(OutputStream outputStream) {
        this(4096, 4096);
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream cannot be null.");
        }
        this.outputStream = outputStream;
    }

    public Output(OutputStream outputStream, int bufferSize) {
        this(bufferSize, bufferSize);
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream cannot be null.");
        }
        this.outputStream = outputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.reset();
    }

    public void setBuffer(byte[] buffer) {
        this.setBuffer(buffer, buffer.length);
    }

    public void setBuffer(byte[] buffer, int maxBufferSize) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer cannot be null.");
        }
        if (buffer.length > maxBufferSize && maxBufferSize != -1) {
            throw new IllegalArgumentException("buffer has length: " + buffer.length + " cannot be greater than maxBufferSize: " + maxBufferSize);
        }
        if (maxBufferSize < -1) {
            throw new IllegalArgumentException("maxBufferSize cannot be < -1: " + maxBufferSize);
        }
        this.buffer = buffer;
        this.maxCapacity = maxBufferSize == -1 ? 0x7FFFFFF7 : maxBufferSize;
        this.capacity = buffer.length;
        this.position = 0;
        this.total = 0L;
        this.outputStream = null;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public byte[] toBytes() {
        byte[] newBuffer = new byte[this.position];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.position);
        return newBuffer;
    }

    public boolean getVariableLengthEncoding() {
        return this.varEncoding;
    }

    public void setVariableLengthEncoding(boolean varEncoding) {
        this.varEncoding = varEncoding;
    }

    public int position() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public long total() {
        return this.total + (long)this.position;
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    @Override
    public void reset() {
        this.position = 0;
        this.total = 0L;
    }

    protected boolean require(int required) throws KryoException {
        if (this.capacity - this.position >= required) {
            return false;
        }
        this.flush();
        if (this.capacity - this.position >= required) {
            return true;
        }
        if (required > this.maxCapacity - this.position) {
            if (required > this.maxCapacity) {
                throw new KryoException("Buffer overflow. Max capacity: " + this.maxCapacity + ", required: " + required);
            }
            throw new KryoException("Buffer overflow. Available: " + (this.maxCapacity - this.position) + ", required: " + required);
        }
        if (this.capacity == 0) {
            this.capacity = 16;
        }
        do {
            this.capacity = Math.min(this.capacity * 2, this.maxCapacity);
        } while (this.capacity - this.position < required);
        byte[] newBuffer = new byte[this.capacity];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.position);
        this.buffer = newBuffer;
        return true;
    }

    @Override
    public void flush() throws KryoException {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.write(this.buffer, 0, this.position);
            this.outputStream.flush();
        }
        catch (IOException ex) {
            throw new KryoException(ex);
        }
        this.total += (long)this.position;
        this.position = 0;
    }

    @Override
    public void close() throws KryoException {
        this.flush();
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void write(int value) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.buffer[this.position++] = (byte)value;
    }

    @Override
    public void write(byte[] bytes) throws KryoException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        this.writeBytes(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws KryoException {
        this.writeBytes(bytes, offset, length);
    }

    public void writeByte(byte value) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.buffer[this.position++] = value;
    }

    public void writeByte(int value) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.buffer[this.position++] = (byte)value;
    }

    public void writeBytes(byte[] bytes) throws KryoException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        this.writeBytes(bytes, 0, bytes.length);
    }

    public void writeBytes(byte[] bytes, int offset, int count) throws KryoException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        int copyCount = Math.min(this.capacity - this.position, count);
        while (true) {
            System.arraycopy(bytes, offset, this.buffer, this.position, copyCount);
            this.position += copyCount;
            if ((count -= copyCount) == 0) {
                return;
            }
            offset += copyCount;
            copyCount = Math.min(this.capacity, count);
            this.require(copyCount);
        }
    }

    public void writeInt(int value) throws KryoException {
        this.require(4);
        byte[] buffer = this.buffer;
        int p = this.position;
        this.position = p + 4;
        buffer[p] = (byte)value;
        buffer[p + 1] = (byte)(value >> 8);
        buffer[p + 2] = (byte)(value >> 16);
        buffer[p + 3] = (byte)(value >> 24);
    }

    public int writeInt(int value, boolean optimizePositive) throws KryoException {
        if (this.varEncoding) {
            return this.writeVarInt(value, optimizePositive);
        }
        this.writeInt(value);
        return 4;
    }

    public int writeVarInt(int value, boolean optimizePositive) throws KryoException {
        if (!optimizePositive) {
            value = value << 1 ^ value >> 31;
        }
        if (value >>> 7 == 0) {
            if (this.position == this.capacity) {
                this.require(1);
            }
            this.buffer[this.position++] = (byte)value;
            return 1;
        }
        if (value >>> 14 == 0) {
            this.require(2);
            int p = this.position;
            this.position = p + 2;
            this.buffer[p] = (byte)(value & 0x7F | 0x80);
            this.buffer[p + 1] = (byte)(value >>> 7);
            return 2;
        }
        if (value >>> 21 == 0) {
            this.require(3);
            int p = this.position;
            this.position = p + 3;
            byte[] buffer = this.buffer;
            buffer[p] = (byte)(value & 0x7F | 0x80);
            buffer[p + 1] = (byte)(value >>> 7 | 0x80);
            buffer[p + 2] = (byte)(value >>> 14);
            return 3;
        }
        if (value >>> 28 == 0) {
            this.require(4);
            int p = this.position;
            this.position = p + 4;
            byte[] buffer = this.buffer;
            buffer[p] = (byte)(value & 0x7F | 0x80);
            buffer[p + 1] = (byte)(value >>> 7 | 0x80);
            buffer[p + 2] = (byte)(value >>> 14 | 0x80);
            buffer[p + 3] = (byte)(value >>> 21);
            return 4;
        }
        this.require(5);
        int p = this.position;
        this.position = p + 5;
        byte[] buffer = this.buffer;
        buffer[p] = (byte)(value & 0x7F | 0x80);
        buffer[p + 1] = (byte)(value >>> 7 | 0x80);
        buffer[p + 2] = (byte)(value >>> 14 | 0x80);
        buffer[p + 3] = (byte)(value >>> 21 | 0x80);
        buffer[p + 4] = (byte)(value >>> 28);
        return 5;
    }

    public int writeVarIntFlag(boolean flag, int value, boolean optimizePositive) throws KryoException {
        if (!optimizePositive) {
            value = value << 1 ^ value >> 31;
        }
        int first = value & 0x3F | (flag ? 128 : 0);
        if (value >>> 6 == 0) {
            if (this.position == this.capacity) {
                this.require(1);
            }
            this.buffer[this.position++] = (byte)first;
            return 1;
        }
        if (value >>> 13 == 0) {
            this.require(2);
            int p = this.position;
            this.position = p + 2;
            this.buffer[p] = (byte)(first | 0x40);
            this.buffer[p + 1] = (byte)(value >>> 6);
            return 2;
        }
        if (value >>> 20 == 0) {
            this.require(3);
            byte[] buffer = this.buffer;
            int p = this.position;
            this.position = p + 3;
            buffer[p] = (byte)(first | 0x40);
            buffer[p + 1] = (byte)(value >>> 6 | 0x80);
            buffer[p + 2] = (byte)(value >>> 13);
            return 3;
        }
        if (value >>> 27 == 0) {
            this.require(4);
            byte[] buffer = this.buffer;
            int p = this.position;
            this.position = p + 4;
            buffer[p] = (byte)(first | 0x40);
            buffer[p + 1] = (byte)(value >>> 6 | 0x80);
            buffer[p + 2] = (byte)(value >>> 13 | 0x80);
            buffer[p + 3] = (byte)(value >>> 20);
            return 4;
        }
        this.require(5);
        byte[] buffer = this.buffer;
        int p = this.position;
        this.position = p + 5;
        buffer[p] = (byte)(first | 0x40);
        buffer[p + 1] = (byte)(value >>> 6 | 0x80);
        buffer[p + 2] = (byte)(value >>> 13 | 0x80);
        buffer[p + 3] = (byte)(value >>> 20 | 0x80);
        buffer[p + 4] = (byte)(value >>> 27);
        return 5;
    }

    public int intLength(int value, boolean optimizePositive) {
        if (this.varEncoding) {
            return Output.varIntLength(value, optimizePositive);
        }
        return 4;
    }

    public void writeLong(long value) throws KryoException {
        this.require(8);
        byte[] buffer = this.buffer;
        int p = this.position;
        this.position = p + 8;
        buffer[p] = (byte)value;
        buffer[p + 1] = (byte)(value >>> 8);
        buffer[p + 2] = (byte)(value >>> 16);
        buffer[p + 3] = (byte)(value >>> 24);
        buffer[p + 4] = (byte)(value >>> 32);
        buffer[p + 5] = (byte)(value >>> 40);
        buffer[p + 6] = (byte)(value >>> 48);
        buffer[p + 7] = (byte)(value >>> 56);
    }

    public int writeLong(long value, boolean optimizePositive) throws KryoException {
        if (this.varEncoding) {
            return this.writeVarLong(value, optimizePositive);
        }
        this.writeLong(value);
        return 8;
    }

    public int writeVarLong(long value, boolean optimizePositive) throws KryoException {
        if (!optimizePositive) {
            value = value << 1 ^ value >> 63;
        }
        if (value >>> 7 == 0L) {
            if (this.position == this.capacity) {
                this.require(1);
            }
            this.buffer[this.position++] = (byte)value;
            return 1;
        }
        if (value >>> 14 == 0L) {
            this.require(2);
            int p = this.position;
            this.position = p + 2;
            this.buffer[p] = (byte)(value & 0x7FL | 0x80L);
            this.buffer[p + 1] = (byte)(value >>> 7);
            return 2;
        }
        if (value >>> 21 == 0L) {
            this.require(3);
            int p = this.position;
            this.position = p + 3;
            byte[] buffer = this.buffer;
            buffer[p] = (byte)(value & 0x7FL | 0x80L);
            buffer[p + 1] = (byte)(value >>> 7 | 0x80L);
            buffer[p + 2] = (byte)(value >>> 14);
            return 3;
        }
        if (value >>> 28 == 0L) {
            this.require(4);
            int p = this.position;
            this.position = p + 4;
            byte[] buffer = this.buffer;
            buffer[p] = (byte)(value & 0x7FL | 0x80L);
            buffer[p + 1] = (byte)(value >>> 7 | 0x80L);
            buffer[p + 2] = (byte)(value >>> 14 | 0x80L);
            buffer[p + 3] = (byte)(value >>> 21);
            return 4;
        }
        if (value >>> 35 == 0L) {
            this.require(5);
            int p = this.position;
            this.position = p + 5;
            byte[] buffer = this.buffer;
            buffer[p] = (byte)(value & 0x7FL | 0x80L);
            buffer[p + 1] = (byte)(value >>> 7 | 0x80L);
            buffer[p + 2] = (byte)(value >>> 14 | 0x80L);
            buffer[p + 3] = (byte)(value >>> 21 | 0x80L);
            buffer[p + 4] = (byte)(value >>> 28);
            return 5;
        }
        if (value >>> 42 == 0L) {
            this.require(6);
            int p = this.position;
            this.position = p + 6;
            byte[] buffer = this.buffer;
            buffer[p] = (byte)(value & 0x7FL | 0x80L);
            buffer[p + 1] = (byte)(value >>> 7 | 0x80L);
            buffer[p + 2] = (byte)(value >>> 14 | 0x80L);
            buffer[p + 3] = (byte)(value >>> 21 | 0x80L);
            buffer[p + 4] = (byte)(value >>> 28 | 0x80L);
            buffer[p + 5] = (byte)(value >>> 35);
            return 6;
        }
        if (value >>> 49 == 0L) {
            this.require(7);
            int p = this.position;
            this.position = p + 7;
            byte[] buffer = this.buffer;
            buffer[p] = (byte)(value & 0x7FL | 0x80L);
            buffer[p + 1] = (byte)(value >>> 7 | 0x80L);
            buffer[p + 2] = (byte)(value >>> 14 | 0x80L);
            buffer[p + 3] = (byte)(value >>> 21 | 0x80L);
            buffer[p + 4] = (byte)(value >>> 28 | 0x80L);
            buffer[p + 5] = (byte)(value >>> 35 | 0x80L);
            buffer[p + 6] = (byte)(value >>> 42);
            return 7;
        }
        if (value >>> 56 == 0L) {
            this.require(8);
            int p = this.position;
            this.position = p + 8;
            byte[] buffer = this.buffer;
            buffer[p] = (byte)(value & 0x7FL | 0x80L);
            buffer[p + 1] = (byte)(value >>> 7 | 0x80L);
            buffer[p + 2] = (byte)(value >>> 14 | 0x80L);
            buffer[p + 3] = (byte)(value >>> 21 | 0x80L);
            buffer[p + 4] = (byte)(value >>> 28 | 0x80L);
            buffer[p + 5] = (byte)(value >>> 35 | 0x80L);
            buffer[p + 6] = (byte)(value >>> 42 | 0x80L);
            buffer[p + 7] = (byte)(value >>> 49);
            return 8;
        }
        this.require(9);
        int p = this.position;
        this.position = p + 9;
        byte[] buffer = this.buffer;
        buffer[p] = (byte)(value & 0x7FL | 0x80L);
        buffer[p + 1] = (byte)(value >>> 7 | 0x80L);
        buffer[p + 2] = (byte)(value >>> 14 | 0x80L);
        buffer[p + 3] = (byte)(value >>> 21 | 0x80L);
        buffer[p + 4] = (byte)(value >>> 28 | 0x80L);
        buffer[p + 5] = (byte)(value >>> 35 | 0x80L);
        buffer[p + 6] = (byte)(value >>> 42 | 0x80L);
        buffer[p + 7] = (byte)(value >>> 49 | 0x80L);
        buffer[p + 8] = (byte)(value >>> 56);
        return 9;
    }

    public int longLength(int value, boolean optimizePositive) {
        if (this.varEncoding) {
            return Output.varLongLength(value, optimizePositive);
        }
        return 8;
    }

    public void writeFloat(float value) throws KryoException {
        this.require(4);
        byte[] buffer = this.buffer;
        int p = this.position;
        this.position = p + 4;
        int intValue = Float.floatToIntBits(value);
        buffer[p] = (byte)intValue;
        buffer[p + 1] = (byte)(intValue >> 8);
        buffer[p + 2] = (byte)(intValue >> 16);
        buffer[p + 3] = (byte)(intValue >> 24);
    }

    public int writeVarFloat(float value, float precision, boolean optimizePositive) throws KryoException {
        return this.writeVarInt((int)(value * precision), optimizePositive);
    }

    public void writeDouble(double value) throws KryoException {
        this.require(8);
        byte[] buffer = this.buffer;
        int p = this.position;
        this.position = p + 8;
        long longValue = Double.doubleToLongBits(value);
        buffer[p] = (byte)longValue;
        buffer[p + 1] = (byte)(longValue >>> 8);
        buffer[p + 2] = (byte)(longValue >>> 16);
        buffer[p + 3] = (byte)(longValue >>> 24);
        buffer[p + 4] = (byte)(longValue >>> 32);
        buffer[p + 5] = (byte)(longValue >>> 40);
        buffer[p + 6] = (byte)(longValue >>> 48);
        buffer[p + 7] = (byte)(longValue >>> 56);
    }

    public int writeVarDouble(double value, double precision, boolean optimizePositive) throws KryoException {
        return this.writeVarLong((long)(value * precision), optimizePositive);
    }

    public void writeShort(int value) throws KryoException {
        this.require(2);
        int p = this.position;
        this.position = p + 2;
        this.buffer[p] = (byte)value;
        this.buffer[p + 1] = (byte)(value >>> 8);
    }

    public void writeChar(char value) throws KryoException {
        this.require(2);
        int p = this.position;
        this.position = p + 2;
        this.buffer[p] = (byte)value;
        this.buffer[p + 1] = (byte)(value >>> 8);
    }

    public void writeBoolean(boolean value) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.buffer[this.position++] = value ? (byte)1 : 0;
    }

    public void writeString(String value) throws KryoException {
        int charCount;
        block10: {
            if (value == null) {
                this.writeByte(128);
                return;
            }
            charCount = value.length();
            if (charCount == 0) {
                this.writeByte(129);
                return;
            }
            if (charCount > 1 && charCount <= 32) {
                for (int i2 = 0; i2 < charCount; ++i2) {
                    if (value.charAt(i2) <= '\u007f') {
                        continue;
                    }
                    break block10;
                }
                if (this.capacity - this.position < charCount) {
                    this.writeAscii_slow(value, charCount);
                } else {
                    value.getBytes(0, charCount, this.buffer, this.position);
                    this.position += charCount;
                }
                int n = this.position - 1;
                this.buffer[n] = (byte)(this.buffer[n] | 0x80);
                return;
            }
        }
        this.writeVarIntFlag(true, charCount + 1, true);
        int charIndex = 0;
        if (this.capacity - this.position >= charCount) {
            char c;
            byte[] buffer = this.buffer;
            int p = this.position;
            while ((c = value.charAt(charIndex)) <= '\u007f') {
                buffer[p++] = (byte)c;
                if (++charIndex != charCount) continue;
                this.position = p;
                return;
            }
            this.position = p;
        }
        if (charIndex < charCount) {
            this.writeUtf8_slow(value, charCount, charIndex);
        }
    }

    public void writeAscii(String value) throws KryoException {
        if (value == null) {
            this.writeByte(128);
            return;
        }
        int charCount = value.length();
        switch (charCount) {
            case 0: {
                this.writeByte(129);
                return;
            }
            case 1: {
                this.require(2);
                this.buffer[this.position++] = -126;
                this.buffer[this.position++] = (byte)value.charAt(0);
                return;
            }
        }
        if (this.capacity - this.position < charCount) {
            this.writeAscii_slow(value, charCount);
        } else {
            value.getBytes(0, charCount, this.buffer, this.position);
            this.position += charCount;
        }
        int n = this.position - 1;
        this.buffer[n] = (byte)(this.buffer[n] | 0x80);
    }

    private void writeUtf8_slow(String value, int charCount, int charIndex) {
        while (charIndex < charCount) {
            char c;
            if (this.position == this.capacity) {
                this.require(Math.min(this.capacity, charCount - charIndex));
            }
            if ((c = value.charAt(charIndex)) <= '\u007f') {
                this.buffer[this.position++] = (byte)c;
            } else if (c > '\u07ff') {
                this.buffer[this.position++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.require(2);
                this.buffer[this.position++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.buffer[this.position++] = (byte)(0x80 | c & 0x3F);
            } else {
                this.buffer[this.position++] = (byte)(0xC0 | c >> 6 & 0x1F);
                if (this.position == this.capacity) {
                    this.require(1);
                }
                this.buffer[this.position++] = (byte)(0x80 | c & 0x3F);
            }
            ++charIndex;
        }
    }

    private void writeAscii_slow(String value, int charCount) throws KryoException {
        if (charCount == 0) {
            return;
        }
        if (this.position == this.capacity) {
            this.require(1);
        }
        int charIndex = 0;
        byte[] buffer = this.buffer;
        int charsToWrite = Math.min(charCount, this.capacity - this.position);
        while (charIndex < charCount) {
            value.getBytes(charIndex, charIndex + charsToWrite, buffer, this.position);
            this.position += charsToWrite;
            if (!this.require(charsToWrite = Math.min(charCount - (charIndex += charsToWrite), this.capacity))) continue;
            buffer = this.buffer;
        }
    }

    public void writeInts(int[] array, int offset, int count) throws KryoException {
        if (this.capacity >= count << 2 && this.require(count << 2)) {
            byte[] buffer = this.buffer;
            int p = this.position;
            int n = offset + count;
            while (offset < n) {
                int value = array[offset];
                buffer[p] = (byte)value;
                buffer[p + 1] = (byte)(value >> 8);
                buffer[p + 2] = (byte)(value >> 16);
                buffer[p + 3] = (byte)(value >> 24);
                ++offset;
                p += 4;
            }
            this.position = p;
        } else {
            int n = offset + count;
            while (offset < n) {
                this.writeInt(array[offset]);
                ++offset;
            }
        }
    }

    public void writeInts(int[] array, int offset, int count, boolean optimizePositive) throws KryoException {
        if (this.varEncoding) {
            int n = offset + count;
            while (offset < n) {
                this.writeVarInt(array[offset], optimizePositive);
                ++offset;
            }
        } else {
            this.writeInts(array, offset, count);
        }
    }

    public void writeLongs(long[] array, int offset, int count) throws KryoException {
        if (this.capacity >= count << 3 && this.require(count << 3)) {
            byte[] buffer = this.buffer;
            int p = this.position;
            int n = offset + count;
            while (offset < n) {
                long value = array[offset];
                buffer[p] = (byte)value;
                buffer[p + 1] = (byte)(value >>> 8);
                buffer[p + 2] = (byte)(value >>> 16);
                buffer[p + 3] = (byte)(value >>> 24);
                buffer[p + 4] = (byte)(value >>> 32);
                buffer[p + 5] = (byte)(value >>> 40);
                buffer[p + 6] = (byte)(value >>> 48);
                buffer[p + 7] = (byte)(value >>> 56);
                ++offset;
                p += 8;
            }
            this.position = p;
        } else {
            int n = offset + count;
            while (offset < n) {
                this.writeLong(array[offset]);
                ++offset;
            }
        }
    }

    public void writeLongs(long[] array, int offset, int count, boolean optimizePositive) throws KryoException {
        if (this.varEncoding) {
            int n = offset + count;
            while (offset < n) {
                this.writeVarLong(array[offset], optimizePositive);
                ++offset;
            }
        } else {
            this.writeLongs(array, offset, count);
        }
    }

    public void writeFloats(float[] array, int offset, int count) throws KryoException {
        if (this.capacity >= count << 2 && this.require(count << 2)) {
            byte[] buffer = this.buffer;
            int p = this.position;
            int n = offset + count;
            while (offset < n) {
                int value = Float.floatToIntBits(array[offset]);
                buffer[p] = (byte)value;
                buffer[p + 1] = (byte)(value >> 8);
                buffer[p + 2] = (byte)(value >> 16);
                buffer[p + 3] = (byte)(value >> 24);
                ++offset;
                p += 4;
            }
            this.position = p;
        } else {
            int n = offset + count;
            while (offset < n) {
                this.writeFloat(array[offset]);
                ++offset;
            }
        }
    }

    public void writeDoubles(double[] array, int offset, int count) throws KryoException {
        if (this.capacity >= count << 3 && this.require(count << 3)) {
            byte[] buffer = this.buffer;
            int p = this.position;
            int n = offset + count;
            while (offset < n) {
                long value = Double.doubleToLongBits(array[offset]);
                buffer[p] = (byte)value;
                buffer[p + 1] = (byte)(value >>> 8);
                buffer[p + 2] = (byte)(value >>> 16);
                buffer[p + 3] = (byte)(value >>> 24);
                buffer[p + 4] = (byte)(value >>> 32);
                buffer[p + 5] = (byte)(value >>> 40);
                buffer[p + 6] = (byte)(value >>> 48);
                buffer[p + 7] = (byte)(value >>> 56);
                ++offset;
                p += 8;
            }
            this.position = p;
        } else {
            int n = offset + count;
            while (offset < n) {
                this.writeDouble(array[offset]);
                ++offset;
            }
        }
    }

    public void writeShorts(short[] array, int offset, int count) throws KryoException {
        if (this.capacity >= count << 1 && this.require(count << 1)) {
            byte[] buffer = this.buffer;
            int p = this.position;
            int n = offset + count;
            while (offset < n) {
                short value = array[offset];
                buffer[p] = (byte)value;
                buffer[p + 1] = (byte)(value >>> 8);
                ++offset;
                p += 2;
            }
            this.position = p;
        } else {
            int n = offset + count;
            while (offset < n) {
                this.writeShort(array[offset]);
                ++offset;
            }
        }
    }

    public void writeChars(char[] array, int offset, int count) throws KryoException {
        if (this.capacity >= count << 1 && this.require(count << 1)) {
            byte[] buffer = this.buffer;
            int p = this.position;
            int n = offset + count;
            while (offset < n) {
                char value = array[offset];
                buffer[p] = (byte)value;
                buffer[p + 1] = (byte)(value >>> 8);
                ++offset;
                p += 2;
            }
            this.position = p;
        } else {
            int n = offset + count;
            while (offset < n) {
                this.writeChar(array[offset]);
                ++offset;
            }
        }
    }

    public void writeBooleans(boolean[] array, int offset, int count) throws KryoException {
        if (this.capacity >= count && this.require(count)) {
            byte[] buffer = this.buffer;
            int p = this.position;
            int n = offset + count;
            while (offset < n) {
                buffer[p] = array[offset] ? (byte)1 : 0;
                ++offset;
                ++p;
            }
            this.position = p;
        } else {
            int n = offset + count;
            while (offset < n) {
                this.writeBoolean(array[offset]);
                ++offset;
            }
        }
    }

    public static int varIntLength(int value, boolean optimizePositive) {
        if (!optimizePositive) {
            value = value << 1 ^ value >> 31;
        }
        if (value >>> 7 == 0) {
            return 1;
        }
        if (value >>> 14 == 0) {
            return 2;
        }
        if (value >>> 21 == 0) {
            return 3;
        }
        if (value >>> 28 == 0) {
            return 4;
        }
        return 5;
    }

    public static int varLongLength(long value, boolean optimizePositive) {
        if (!optimizePositive) {
            value = value << 1 ^ value >> 63;
        }
        if (value >>> 7 == 0L) {
            return 1;
        }
        if (value >>> 14 == 0L) {
            return 2;
        }
        if (value >>> 21 == 0L) {
            return 3;
        }
        if (value >>> 28 == 0L) {
            return 4;
        }
        if (value >>> 35 == 0L) {
            return 5;
        }
        if (value >>> 42 == 0L) {
            return 6;
        }
        if (value >>> 49 == 0L) {
            return 7;
        }
        if (value >>> 56 == 0L) {
            return 8;
        }
        return 9;
    }
}

