/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.util;

import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.SerializerFactory;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.kryo.util.Generics;
import com.esotericsoftware.minlog.Log;
import java.lang.reflect.Type;

public class Util {
    public static final boolean isAndroid;
    public static final boolean unsafe;
    public static final int maxArraySize = 0x7FFFFFF7;

    public static boolean isClassAvailable(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Exception ex) {
            Log.debug("kryo", "Class not available: " + className);
            return false;
        }
    }

    public static Class getWrapperClass(Class type) {
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        return Void.class;
    }

    public static Class getPrimitiveClass(Class type) {
        if (type == Integer.class) {
            return Integer.TYPE;
        }
        if (type == Float.class) {
            return Float.TYPE;
        }
        if (type == Boolean.class) {
            return Boolean.TYPE;
        }
        if (type == Byte.class) {
            return Byte.TYPE;
        }
        if (type == Long.class) {
            return Long.TYPE;
        }
        if (type == Character.class) {
            return Character.TYPE;
        }
        if (type == Double.class) {
            return Double.TYPE;
        }
        if (type == Short.class) {
            return Short.TYPE;
        }
        if (type == Void.class) {
            return Void.TYPE;
        }
        return type;
    }

    public static boolean isWrapperClass(Class type) {
        return type == Integer.class || type == Float.class || type == Boolean.class || type == Byte.class || type == Long.class || type == Character.class || type == Double.class || type == Short.class;
    }

    public static boolean isEnum(Class type) {
        return Enum.class.isAssignableFrom(type) && type != Enum.class;
    }

    public static void log(String message, Object object, int position) {
        if (object == null) {
            if (Log.TRACE) {
                Log.trace("kryo", message + ": null" + Util.pos(position));
            }
            return;
        }
        Class<?> type = object.getClass();
        if (type.isPrimitive() || Util.isWrapperClass(type) || type == String.class) {
            if (Log.TRACE) {
                Log.trace("kryo", message + ": " + Util.string(object) + Util.pos(position));
            }
        } else {
            Log.debug("kryo", message + ": " + Util.string(object) + Util.pos(position));
        }
    }

    public static String pos(int position) {
        return position == -1 ? "" : " [" + position + "]";
    }

    public static String string(Object object) {
        if (object == null) {
            return "null";
        }
        Class<?> type = object.getClass();
        if (type.isArray()) {
            return Util.className(type);
        }
        String className = Log.TRACE ? Util.className(type) : type.getSimpleName();
        try {
            if (type.getMethod("toString", new Class[0]).getDeclaringClass() == Object.class) {
                return className;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String value = String.valueOf(object) + " (" + className + ")";
            return value.length() > 97 ? value.substring(0, 97) + "..." : value;
        }
        catch (Throwable ex) {
            return className + " (toString exception: " + ex + ")";
        }
    }

    public static String className(Class type) {
        if (type == null) {
            return "null";
        }
        if (type.isArray()) {
            Class elementClass = Util.getElementClass(type);
            StringBuilder buffer = new StringBuilder(16);
            int n = Util.getDimensionCount(type);
            for (int i2 = 0; i2 < n; ++i2) {
                buffer.append("[]");
            }
            return Util.className(elementClass) + buffer;
        }
        if (type.isPrimitive() || type == Object.class || type == Boolean.class || type == Byte.class || type == Character.class || type == Short.class || type == Integer.class || type == Long.class || type == Float.class || type == Double.class || type == String.class) {
            return type.getSimpleName();
        }
        return type.getName();
    }

    public static String classNames(Class[] types) {
        StringBuilder buffer = new StringBuilder(32);
        int n = types.length;
        for (int i2 = 0; i2 < n; ++i2) {
            if (i2 > 0) {
                buffer.append(", ");
            }
            buffer.append(Util.className(types[i2]));
        }
        return buffer.toString();
    }

    public static String simpleName(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getSimpleName();
        }
        return type.toString();
    }

    public static String simpleName(Class type, Generics.GenericType genericType) {
        int i2;
        int n;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append((type.isArray() ? Util.getElementClass(type) : type).getSimpleName());
        if (genericType.arguments != null) {
            buffer.append('<');
            n = genericType.arguments.length;
            for (i2 = 0; i2 < n; ++i2) {
                if (i2 > 0) {
                    buffer.append(", ");
                }
                buffer.append(genericType.arguments[i2].toString());
            }
            buffer.append('>');
        }
        if (type.isArray()) {
            n = Util.getDimensionCount(type);
            for (i2 = 0; i2 < n; ++i2) {
                buffer.append("[]");
            }
        }
        return buffer.toString();
    }

    public static int getDimensionCount(Class arrayClass) {
        int depth = 0;
        for (Class<?> nextClass = arrayClass.getComponentType(); nextClass != null; nextClass = nextClass.getComponentType()) {
            ++depth;
        }
        return depth;
    }

    public static Class getElementClass(Class arrayClass) {
        Class<?> elementClass = arrayClass;
        while (elementClass.getComponentType() != null) {
            elementClass = elementClass.getComponentType();
        }
        return elementClass;
    }

    public static boolean isAscii(String value) {
        int n = value.length();
        for (int i2 = 0; i2 < n; ++i2) {
            if (value.charAt(i2) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    public static <T extends SerializerFactory> T newFactory(Class<T> factoryClass, Class<? extends Serializer> serializerClass) {
        try {
            if (serializerClass != null) {
                try {
                    return (T)((SerializerFactory)factoryClass.getConstructor(Class.class).newInstance(serializerClass));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            return (T)((SerializerFactory)factoryClass.newInstance());
        }
        catch (Exception ex) {
            if (serializerClass == null) {
                throw new IllegalArgumentException("Unable to create serializer factory: " + factoryClass.getName(), ex);
            }
            throw new IllegalArgumentException("Unable to create serializer factory \"" + factoryClass.getName() + "\" for serializer class: " + Util.className(serializerClass), ex);
        }
    }

    static {
        boolean found;
        block2: {
            isAndroid = "Dalvik".equals(System.getProperty("java.vm.name"));
            found = false;
            try {
                found = Class.forName("com.esotericsoftware.kryo.unsafe.UnsafeUtil", true, FieldSerializer.class.getClassLoader()).getField("unsafe").get(null) != null;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                if (!Log.TRACE) break block2;
                Log.trace("kryo", "Unsafe is unavailable.");
            }
        }
        unsafe = found;
    }
}

