/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.concurrenttrees.radix;

import com.googlecode.concurrenttrees.common.CharSequences;
import com.googlecode.concurrenttrees.common.KeyValuePair;
import com.googlecode.concurrenttrees.common.LazyIterator;
import com.googlecode.concurrenttrees.radix.RadixTree;
import com.googlecode.concurrenttrees.radix.node.Node;
import com.googlecode.concurrenttrees.radix.node.NodeFactory;
import com.googlecode.concurrenttrees.radix.node.util.PrettyPrintable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ConcurrentRadixTree<O>
implements RadixTree<O>,
PrettyPrintable,
Serializable {
    private final NodeFactory nodeFactory;
    protected volatile Node root;
    private final Lock writeLock = new ReentrantLock();

    public ConcurrentRadixTree(NodeFactory nodeFactory) {
        Node rootNode;
        this.nodeFactory = nodeFactory;
        this.root = rootNode = nodeFactory.createNode("", null, Collections.<Node>emptyList(), true);
    }

    protected void acquireWriteLock() {
        this.writeLock.lock();
    }

    protected void releaseWriteLock() {
        this.writeLock.unlock();
    }

    @Override
    public O put(CharSequence key, O value) {
        Object existingValue = this.putInternal(key, value, true);
        return (O)existingValue;
    }

    @Override
    public O putIfAbsent(CharSequence key, O value) {
        Object existingValue = this.putInternal(key, value, false);
        return (O)existingValue;
    }

    @Override
    public O getValueForExactKey(CharSequence key) {
        SearchResult searchResult = this.searchTree(key);
        if (searchResult.classification.equals((Object)SearchResult.Classification.EXACT_MATCH)) {
            Object value = searchResult.nodeFound.getValue();
            return (O)value;
        }
        return null;
    }

    @Override
    public Iterable<CharSequence> getKeysStartingWith(CharSequence prefix) {
        SearchResult searchResult = this.searchTree(prefix);
        SearchResult.Classification classification = searchResult.classification;
        switch (classification) {
            case EXACT_MATCH: {
                return this.getDescendantKeys(prefix, searchResult.nodeFound);
            }
            case KEY_ENDS_MID_EDGE: {
                CharSequence edgeSuffix = CharSequences.getSuffix(searchResult.nodeFound.getIncomingEdge(), searchResult.charsMatchedInNodeFound);
                prefix = CharSequences.concatenate(prefix, edgeSuffix);
                return this.getDescendantKeys(prefix, searchResult.nodeFound);
            }
        }
        return Collections.emptySet();
    }

    @Override
    public Iterable<O> getValuesForKeysStartingWith(CharSequence prefix) {
        SearchResult searchResult = this.searchTree(prefix);
        SearchResult.Classification classification = searchResult.classification;
        switch (classification) {
            case EXACT_MATCH: {
                return this.getDescendantValues(prefix, searchResult.nodeFound);
            }
            case KEY_ENDS_MID_EDGE: {
                CharSequence edgeSuffix = CharSequences.getSuffix(searchResult.nodeFound.getIncomingEdge(), searchResult.charsMatchedInNodeFound);
                prefix = CharSequences.concatenate(prefix, edgeSuffix);
                return this.getDescendantValues(prefix, searchResult.nodeFound);
            }
        }
        return Collections.emptySet();
    }

    @Override
    public Iterable<KeyValuePair<O>> getKeyValuePairsForKeysStartingWith(CharSequence prefix) {
        SearchResult searchResult = this.searchTree(prefix);
        SearchResult.Classification classification = searchResult.classification;
        switch (classification) {
            case EXACT_MATCH: {
                return this.getDescendantKeyValuePairs(prefix, searchResult.nodeFound);
            }
            case KEY_ENDS_MID_EDGE: {
                CharSequence edgeSuffix = CharSequences.getSuffix(searchResult.nodeFound.getIncomingEdge(), searchResult.charsMatchedInNodeFound);
                prefix = CharSequences.concatenate(prefix, edgeSuffix);
                return this.getDescendantKeyValuePairs(prefix, searchResult.nodeFound);
            }
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(CharSequence key) {
        if (key == null) {
            throw new IllegalArgumentException("The key argument was null");
        }
        this.acquireWriteLock();
        try {
            SearchResult searchResult = this.searchTree(key);
            SearchResult.Classification classification = searchResult.classification;
            switch (classification) {
                case EXACT_MATCH: {
                    if (searchResult.nodeFound.getValue() == null) {
                        boolean bl = false;
                        return bl;
                    }
                    List<Node> childEdges = searchResult.nodeFound.getOutgoingEdges();
                    if (childEdges.size() > 1) {
                        Node cloned = this.nodeFactory.createNode(searchResult.nodeFound.getIncomingEdge(), null, searchResult.nodeFound.getOutgoingEdges(), false);
                        searchResult.parentNode.updateOutgoingEdge(cloned);
                    } else if (childEdges.size() == 1) {
                        Node child = childEdges.get(0);
                        CharSequence concatenatedEdges = CharSequences.concatenate(searchResult.nodeFound.getIncomingEdge(), child.getIncomingEdge());
                        Node mergedNode = this.nodeFactory.createNode(concatenatedEdges, child.getValue(), child.getOutgoingEdges(), false);
                        searchResult.parentNode.updateOutgoingEdge(mergedNode);
                    } else {
                        Node newParent;
                        boolean parentIsRoot;
                        List<Node> currentEdgesFromParent = searchResult.parentNode.getOutgoingEdges();
                        List<Node> newEdgesOfParent = Arrays.asList(new Node[searchResult.parentNode.getOutgoingEdges().size() - 1]);
                        int added = 0;
                        int numParentEdges = currentEdgesFromParent.size();
                        for (int i2 = 0; i2 < numParentEdges; ++i2) {
                            Node node = currentEdgesFromParent.get(i2);
                            if (node == searchResult.nodeFound) continue;
                            newEdgesOfParent.set(added++, node);
                        }
                        boolean bl = parentIsRoot = searchResult.parentNode == this.root;
                        if (newEdgesOfParent.size() == 1 && searchResult.parentNode.getValue() == null && !parentIsRoot) {
                            Node parentsRemainingChild = newEdgesOfParent.get(0);
                            CharSequence concatenatedEdges = CharSequences.concatenate(searchResult.parentNode.getIncomingEdge(), parentsRemainingChild.getIncomingEdge());
                            newParent = this.nodeFactory.createNode(concatenatedEdges, parentsRemainingChild.getValue(), parentsRemainingChild.getOutgoingEdges(), parentIsRoot);
                        } else {
                            newParent = this.nodeFactory.createNode(searchResult.parentNode.getIncomingEdge(), searchResult.parentNode.getValue(), newEdgesOfParent, parentIsRoot);
                        }
                        if (parentIsRoot) {
                            this.root = newParent;
                        } else {
                            searchResult.parentNodesParent.updateOutgoingEdge(newParent);
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public Iterable<CharSequence> getClosestKeys(CharSequence candidate) {
        SearchResult searchResult = this.searchTree(candidate);
        SearchResult.Classification classification = searchResult.classification;
        switch (classification) {
            case EXACT_MATCH: {
                return this.getDescendantKeys(candidate, searchResult.nodeFound);
            }
            case KEY_ENDS_MID_EDGE: {
                CharSequence edgeSuffix = CharSequences.getSuffix(searchResult.nodeFound.getIncomingEdge(), searchResult.charsMatchedInNodeFound);
                candidate = CharSequences.concatenate(candidate, edgeSuffix);
                return this.getDescendantKeys(candidate, searchResult.nodeFound);
            }
            case INCOMPLETE_MATCH_TO_MIDDLE_OF_EDGE: {
                CharSequence keyOfParentNode = CharSequences.getPrefix(candidate, searchResult.charsMatched - searchResult.charsMatchedInNodeFound);
                CharSequence keyOfNodeFound = CharSequences.concatenate(keyOfParentNode, searchResult.nodeFound.getIncomingEdge());
                return this.getDescendantKeys(keyOfNodeFound, searchResult.nodeFound);
            }
            case INCOMPLETE_MATCH_TO_END_OF_EDGE: {
                if (searchResult.charsMatched == 0) break;
                CharSequence keyOfNodeFound = CharSequences.getPrefix(candidate, searchResult.charsMatched);
                return this.getDescendantKeys(keyOfNodeFound, searchResult.nodeFound);
            }
        }
        return Collections.emptySet();
    }

    @Override
    public Iterable<O> getValuesForClosestKeys(CharSequence candidate) {
        SearchResult searchResult = this.searchTree(candidate);
        SearchResult.Classification classification = searchResult.classification;
        switch (classification) {
            case EXACT_MATCH: {
                return this.getDescendantValues(candidate, searchResult.nodeFound);
            }
            case KEY_ENDS_MID_EDGE: {
                CharSequence edgeSuffix = CharSequences.getSuffix(searchResult.nodeFound.getIncomingEdge(), searchResult.charsMatchedInNodeFound);
                candidate = CharSequences.concatenate(candidate, edgeSuffix);
                return this.getDescendantValues(candidate, searchResult.nodeFound);
            }
            case INCOMPLETE_MATCH_TO_MIDDLE_OF_EDGE: {
                CharSequence keyOfParentNode = CharSequences.getPrefix(candidate, searchResult.charsMatched - searchResult.charsMatchedInNodeFound);
                CharSequence keyOfNodeFound = CharSequences.concatenate(keyOfParentNode, searchResult.nodeFound.getIncomingEdge());
                return this.getDescendantValues(keyOfNodeFound, searchResult.nodeFound);
            }
            case INCOMPLETE_MATCH_TO_END_OF_EDGE: {
                if (searchResult.charsMatched == 0) break;
                CharSequence keyOfNodeFound = CharSequences.getPrefix(candidate, searchResult.charsMatched);
                return this.getDescendantValues(keyOfNodeFound, searchResult.nodeFound);
            }
        }
        return Collections.emptySet();
    }

    @Override
    public Iterable<KeyValuePair<O>> getKeyValuePairsForClosestKeys(CharSequence candidate) {
        SearchResult searchResult = this.searchTree(candidate);
        SearchResult.Classification classification = searchResult.classification;
        switch (classification) {
            case EXACT_MATCH: {
                return this.getDescendantKeyValuePairs(candidate, searchResult.nodeFound);
            }
            case KEY_ENDS_MID_EDGE: {
                CharSequence edgeSuffix = CharSequences.getSuffix(searchResult.nodeFound.getIncomingEdge(), searchResult.charsMatchedInNodeFound);
                candidate = CharSequences.concatenate(candidate, edgeSuffix);
                return this.getDescendantKeyValuePairs(candidate, searchResult.nodeFound);
            }
            case INCOMPLETE_MATCH_TO_MIDDLE_OF_EDGE: {
                CharSequence keyOfParentNode = CharSequences.getPrefix(candidate, searchResult.charsMatched - searchResult.charsMatchedInNodeFound);
                CharSequence keyOfNodeFound = CharSequences.concatenate(keyOfParentNode, searchResult.nodeFound.getIncomingEdge());
                return this.getDescendantKeyValuePairs(keyOfNodeFound, searchResult.nodeFound);
            }
            case INCOMPLETE_MATCH_TO_END_OF_EDGE: {
                if (searchResult.charsMatched == 0) break;
                CharSequence keyOfNodeFound = CharSequences.getPrefix(candidate, searchResult.charsMatched);
                return this.getDescendantKeyValuePairs(keyOfNodeFound, searchResult.nodeFound);
            }
        }
        return Collections.emptySet();
    }

    @Override
    public int size() {
        LinkedList<Node> stack = new LinkedList<Node>();
        stack.push(this.root);
        int count = 0;
        while (!stack.isEmpty()) {
            Node current = (Node)stack.pop();
            stack.addAll(current.getOutgoingEdges());
            if (current.getValue() == null) continue;
            ++count;
        }
        return count;
    }

    Object putInternal(CharSequence key, Object value, boolean overwrite) {
        if (key == null) {
            throw new IllegalArgumentException("The key argument was null");
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException("The key argument was zero-length");
        }
        if (value == null) {
            throw new IllegalArgumentException("The value argument was null");
        }
        this.acquireWriteLock();
        try {
            SearchResult searchResult = this.searchTree(key);
            SearchResult.Classification classification = searchResult.classification;
            switch (classification) {
                case EXACT_MATCH: {
                    Object existingValue = searchResult.nodeFound.getValue();
                    if (!overwrite && existingValue != null) {
                        Object object = existingValue;
                        return object;
                    }
                    Node replacementNode = this.nodeFactory.createNode(searchResult.nodeFound.getIncomingEdge(), value, searchResult.nodeFound.getOutgoingEdges(), false);
                    searchResult.parentNode.updateOutgoingEdge(replacementNode);
                    Object object = existingValue;
                    return object;
                }
                case KEY_ENDS_MID_EDGE: {
                    CharSequence keyCharsFromStartOfNodeFound = key.subSequence(searchResult.charsMatched - searchResult.charsMatchedInNodeFound, key.length());
                    CharSequence commonPrefix = CharSequences.getCommonPrefix(keyCharsFromStartOfNodeFound, searchResult.nodeFound.getIncomingEdge());
                    CharSequence suffixFromExistingEdge = CharSequences.subtractPrefix(searchResult.nodeFound.getIncomingEdge(), commonPrefix);
                    Node newChild = this.nodeFactory.createNode(suffixFromExistingEdge, searchResult.nodeFound.getValue(), searchResult.nodeFound.getOutgoingEdges(), false);
                    Node newParent = this.nodeFactory.createNode(commonPrefix, value, Arrays.asList(newChild), false);
                    searchResult.parentNode.updateOutgoingEdge(newParent);
                    Object var11_25 = null;
                    return var11_25;
                }
                case INCOMPLETE_MATCH_TO_END_OF_EDGE: {
                    CharSequence keySuffix = key.subSequence(searchResult.charsMatched, key.length());
                    Node newChild = this.nodeFactory.createNode(keySuffix, value, Collections.<Node>emptyList(), false);
                    ArrayList<Node> edges = new ArrayList<Node>(searchResult.nodeFound.getOutgoingEdges().size() + 1);
                    edges.addAll(searchResult.nodeFound.getOutgoingEdges());
                    edges.add(newChild);
                    Node clonedNode = this.nodeFactory.createNode(searchResult.nodeFound.getIncomingEdge(), searchResult.nodeFound.getValue(), edges, searchResult.nodeFound == this.root);
                    if (searchResult.nodeFound == this.root) {
                        this.root = clonedNode;
                    } else {
                        searchResult.parentNode.updateOutgoingEdge(clonedNode);
                    }
                    Object newParent = null;
                    return newParent;
                }
                case INCOMPLETE_MATCH_TO_MIDDLE_OF_EDGE: {
                    CharSequence keyCharsFromStartOfNodeFound = key.subSequence(searchResult.charsMatched - searchResult.charsMatchedInNodeFound, key.length());
                    CharSequence commonPrefix = CharSequences.getCommonPrefix(keyCharsFromStartOfNodeFound, searchResult.nodeFound.getIncomingEdge());
                    CharSequence suffixFromExistingEdge = CharSequences.subtractPrefix(searchResult.nodeFound.getIncomingEdge(), commonPrefix);
                    CharSequence suffixFromKey = key.subSequence(searchResult.charsMatched, key.length());
                    Node n1 = this.nodeFactory.createNode(suffixFromKey, value, Collections.<Node>emptyList(), false);
                    Node n2 = this.nodeFactory.createNode(suffixFromExistingEdge, searchResult.nodeFound.getValue(), searchResult.nodeFound.getOutgoingEdges(), false);
                    Node n3 = this.nodeFactory.createNode(commonPrefix, null, Arrays.asList(n1, n2), false);
                    searchResult.parentNode.updateOutgoingEdge(n3);
                    Object var13_28 = null;
                    return var13_28;
                }
            }
            throw new IllegalStateException("Unexpected classification for search result: " + searchResult);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    Iterable<CharSequence> getDescendantKeys(final CharSequence startKey, final Node startNode) {
        return new Iterable<CharSequence>(){

            @Override
            public Iterator<CharSequence> iterator() {
                return new LazyIterator<CharSequence>(){
                    Iterator<NodeKeyPair> descendantNodes;
                    {
                        this.descendantNodes = ConcurrentRadixTree.this.lazyTraverseDescendants(startKey, startNode).iterator();
                    }

                    @Override
                    protected CharSequence computeNext() {
                        while (this.descendantNodes.hasNext()) {
                            NodeKeyPair nodeKeyPair = this.descendantNodes.next();
                            Object value = nodeKeyPair.node.getValue();
                            if (value == null) continue;
                            CharSequence optionallyTransformedKey = ConcurrentRadixTree.this.transformKeyForResult(nodeKeyPair.key);
                            return CharSequences.toString(optionallyTransformedKey);
                        }
                        return (CharSequence)this.endOfData();
                    }
                };
            }
        };
    }

    <O> Iterable<O> getDescendantValues(final CharSequence startKey, final Node startNode) {
        return new Iterable<O>(){

            @Override
            public Iterator<O> iterator() {
                return new LazyIterator<O>(){
                    Iterator<NodeKeyPair> descendantNodes;
                    {
                        this.descendantNodes = ConcurrentRadixTree.this.lazyTraverseDescendants(startKey, startNode).iterator();
                    }

                    @Override
                    protected O computeNext() {
                        while (this.descendantNodes.hasNext()) {
                            NodeKeyPair nodeKeyPair = this.descendantNodes.next();
                            Object value = nodeKeyPair.node.getValue();
                            if (value == null) continue;
                            Object valueTyped = value;
                            return valueTyped;
                        }
                        return this.endOfData();
                    }
                };
            }
        };
    }

    <O> Iterable<KeyValuePair<O>> getDescendantKeyValuePairs(final CharSequence startKey, final Node startNode) {
        return new Iterable<KeyValuePair<O>>(){

            @Override
            public Iterator<KeyValuePair<O>> iterator() {
                return new LazyIterator<KeyValuePair<O>>(){
                    Iterator<NodeKeyPair> descendantNodes;
                    {
                        this.descendantNodes = ConcurrentRadixTree.this.lazyTraverseDescendants(startKey, startNode).iterator();
                    }

                    @Override
                    protected KeyValuePair<O> computeNext() {
                        while (this.descendantNodes.hasNext()) {
                            NodeKeyPair nodeKeyPair = this.descendantNodes.next();
                            Object value = nodeKeyPair.node.getValue();
                            if (value == null) continue;
                            CharSequence optionallyTransformedKey = ConcurrentRadixTree.this.transformKeyForResult(nodeKeyPair.key);
                            String keyString = CharSequences.toString(optionallyTransformedKey);
                            return new KeyValuePairImpl(keyString, value);
                        }
                        return (KeyValuePair)this.endOfData();
                    }
                };
            }
        };
    }

    protected Iterable<NodeKeyPair> lazyTraverseDescendants(final CharSequence startKey, final Node startNode) {
        return new Iterable<NodeKeyPair>(){

            @Override
            public Iterator<NodeKeyPair> iterator() {
                return new LazyIterator<NodeKeyPair>(){
                    Deque<NodeKeyPair> stack = new LinkedList<NodeKeyPair>();
                    {
                        this.stack.push(new NodeKeyPair(startNode, startKey));
                    }

                    @Override
                    protected NodeKeyPair computeNext() {
                        if (this.stack.isEmpty()) {
                            return (NodeKeyPair)this.endOfData();
                        }
                        NodeKeyPair current = this.stack.pop();
                        List<Node> childNodes = current.node.getOutgoingEdges();
                        for (int i2 = childNodes.size(); i2 > 0; --i2) {
                            Node child = childNodes.get(i2 - 1);
                            this.stack.push(new NodeKeyPair(child, CharSequences.concatenate(current.key, child.getIncomingEdge())));
                        }
                        return current;
                    }
                };
            }
        };
    }

    protected CharSequence transformKeyForResult(CharSequence rawKey) {
        return rawKey;
    }

    SearchResult searchTree(CharSequence key) {
        Node nextNode;
        Node parentNodesParent = null;
        Node parentNode = null;
        Node currentNode = this.root;
        int charsMatched = 0;
        int charsMatchedInNodeFound = 0;
        int keyLength = key.length();
        block0: while (charsMatched < keyLength && (nextNode = currentNode.getOutgoingEdge(Character.valueOf(key.charAt(charsMatched)))) != null) {
            parentNodesParent = parentNode;
            parentNode = currentNode;
            currentNode = nextNode;
            charsMatchedInNodeFound = 0;
            CharSequence currentNodeEdgeCharacters = currentNode.getIncomingEdge();
            int numEdgeChars = currentNodeEdgeCharacters.length();
            for (int i2 = 0; i2 < numEdgeChars && charsMatched < keyLength; ++i2) {
                if (currentNodeEdgeCharacters.charAt(i2) != key.charAt(charsMatched)) break block0;
                ++charsMatched;
                ++charsMatchedInNodeFound;
            }
        }
        return new SearchResult(key, currentNode, charsMatched, charsMatchedInNodeFound, parentNode, parentNodesParent);
    }

    @Override
    public Node getNode() {
        return this.root;
    }

    static class SearchResult {
        final CharSequence key;
        final Node nodeFound;
        final int charsMatched;
        final int charsMatchedInNodeFound;
        final Node parentNode;
        final Node parentNodesParent;
        final Classification classification;

        SearchResult(CharSequence key, Node nodeFound, int charsMatched, int charsMatchedInNodeFound, Node parentNode, Node parentNodesParent) {
            this.key = key;
            this.nodeFound = nodeFound;
            this.charsMatched = charsMatched;
            this.charsMatchedInNodeFound = charsMatchedInNodeFound;
            this.parentNode = parentNode;
            this.parentNodesParent = parentNodesParent;
            this.classification = this.classify(key, nodeFound, charsMatched, charsMatchedInNodeFound);
        }

        protected Classification classify(CharSequence key, Node nodeFound, int charsMatched, int charsMatchedInNodeFound) {
            if (charsMatched == key.length()) {
                if (charsMatchedInNodeFound == nodeFound.getIncomingEdge().length()) {
                    return Classification.EXACT_MATCH;
                }
                if (charsMatchedInNodeFound < nodeFound.getIncomingEdge().length()) {
                    return Classification.KEY_ENDS_MID_EDGE;
                }
            } else if (charsMatched < key.length()) {
                if (charsMatchedInNodeFound == nodeFound.getIncomingEdge().length()) {
                    return Classification.INCOMPLETE_MATCH_TO_END_OF_EDGE;
                }
                if (charsMatchedInNodeFound < nodeFound.getIncomingEdge().length()) {
                    return Classification.INCOMPLETE_MATCH_TO_MIDDLE_OF_EDGE;
                }
            }
            throw new IllegalStateException("Unexpected failure to classify SearchResult: " + this);
        }

        public String toString() {
            return "SearchResult{key=" + this.key + ", nodeFound=" + this.nodeFound + ", charsMatched=" + this.charsMatched + ", charsMatchedInNodeFound=" + this.charsMatchedInNodeFound + ", parentNode=" + this.parentNode + ", parentNodesParent=" + this.parentNodesParent + ", classification=" + (Object)((Object)this.classification) + '}';
        }

        static enum Classification {
            EXACT_MATCH,
            INCOMPLETE_MATCH_TO_END_OF_EDGE,
            INCOMPLETE_MATCH_TO_MIDDLE_OF_EDGE,
            KEY_ENDS_MID_EDGE,
            INVALID;

        }
    }

    protected static class NodeKeyPair {
        public final Node node;
        public final CharSequence key;

        public NodeKeyPair(Node node, CharSequence key) {
            this.node = node;
            this.key = key;
        }
    }

    public static class KeyValuePairImpl<O>
    implements KeyValuePair<O> {
        final String key;
        final O value;

        public KeyValuePairImpl(String key, Object value) {
            this.key = key;
            Object valueTyped = value;
            this.value = valueTyped;
        }

        @Override
        public CharSequence getKey() {
            return this.key;
        }

        @Override
        public O getValue() {
            return this.value;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyValuePairImpl that = (KeyValuePairImpl)o;
            return this.key.equals(that.key);
        }

        @Override
        public int hashCode() {
            return this.key.hashCode();
        }

        @Override
        public String toString() {
            return "(" + this.key + ", " + this.value + ")";
        }
    }
}

