/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.index.support;

import com.googlecode.cqengine.query.option.QueryOptions;
import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;

public class CloseableRequestResources
implements Closeable {
    final Collection<Closeable> requestResources = Collections.newSetFromMap(new IdentityHashMap());

    public void add(Closeable closeable) {
        this.requestResources.add(closeable);
    }

    public CloseableResourceGroup addGroup() {
        CloseableResourceGroup group = new CloseableResourceGroup();
        this.add(group);
        return group;
    }

    @Override
    public void close() {
        Iterator<Closeable> iterator = this.requestResources.iterator();
        while (iterator.hasNext()) {
            Closeable closeable = iterator.next();
            CloseableRequestResources.closeQuietly(closeable);
            iterator.remove();
        }
    }

    public static CloseableRequestResources forQueryOptions(QueryOptions queryOptions) {
        CloseableRequestResources closeableRequestResources = queryOptions.get(CloseableRequestResources.class);
        if (closeableRequestResources == null) {
            closeableRequestResources = new CloseableRequestResources();
            queryOptions.put(CloseableRequestResources.class, closeableRequestResources);
        }
        return closeableRequestResources;
    }

    public static void closeForQueryOptions(QueryOptions queryOptions) {
        CloseableRequestResources.closeQuietly(queryOptions.get(CloseableRequestResources.class));
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public class CloseableResourceGroup
    implements Closeable {
        final Set<Closeable> groupResources = Collections.newSetFromMap(new IdentityHashMap());

        public boolean add(Closeable closeable) {
            return this.groupResources.add(closeable);
        }

        @Override
        public void close() {
            Iterator<Closeable> iterator = this.groupResources.iterator();
            while (iterator.hasNext()) {
                Closeable closeable = iterator.next();
                CloseableRequestResources.closeQuietly(closeable);
                iterator.remove();
            }
            CloseableRequestResources.this.requestResources.remove(this);
        }

        public String toString() {
            return this.groupResources.toString();
        }
    }
}

