/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.query.comparative;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.persistence.support.ObjectSet;
import com.googlecode.cqengine.query.comparative.SimpleComparativeQuery;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.query.simple.SimpleQuery;
import com.googlecode.cqengine.query.support.QueryValidation;
import java.util.ArrayList;

public class LongestPrefix<O, A extends CharSequence>
extends SimpleComparativeQuery<O, A> {
    private final A value;

    public LongestPrefix(Attribute<O, A> attribute, A value) {
        super(attribute);
        this.value = (CharSequence)QueryValidation.checkQueryValueNotNull(value);
    }

    public A getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LongestPrefix)) {
            return false;
        }
        LongestPrefix that = (LongestPrefix)o;
        if (!this.attribute.equals(that.attribute)) {
            return false;
        }
        return this.value.equals(that.value);
    }

    @Override
    protected int calcHashCode() {
        int result = this.attribute.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    @Override
    public Iterable<O> getMatchesForSimpleAttribute(SimpleAttribute<O, A> attribute, ObjectSet<O> objectsInCollection, QueryOptions queryOptions) {
        ArrayList results = new ArrayList();
        int currentCount = -1;
        for (Object object : objectsInCollection) {
            CharSequence attributeValue = (CharSequence)attribute.getValue(object, queryOptions);
            int count = LongestPrefix.countPrefixChars(this.value, attributeValue);
            if (count == 0) continue;
            if (count > currentCount) {
                currentCount = count;
                results.clear();
                results.add(object);
                continue;
            }
            if (count != currentCount) continue;
            results.add(object);
        }
        return results;
    }

    @Override
    public Iterable<O> getMatchesForNonSimpleAttribute(Attribute<O, A> attribute, ObjectSet<O> objectsInCollection, QueryOptions queryOptions) {
        ArrayList results = new ArrayList();
        int currentCount = -1;
        for (Object object : objectsInCollection) {
            Iterable<A> attributeValues = attribute.getValues(object, queryOptions);
            for (CharSequence attributeValue : attributeValues) {
                int count = LongestPrefix.countPrefixChars(this.value, attributeValue);
                if (count == 0) continue;
                if (count > currentCount) {
                    currentCount = count;
                    results.clear();
                    results.add(object);
                    continue;
                }
                if (count != currentCount) continue;
                results.add(object);
            }
        }
        return results;
    }

    public String toString() {
        return "longestPrefix(" + SimpleQuery.asLiteral(super.getAttributeName()) + ", " + SimpleQuery.asLiteral(this.value) + ")";
    }

    static int countPrefixChars(CharSequence mainSequence, CharSequence candidatePrefix) {
        int charsMatched = 0;
        int length = Math.min(mainSequence.length(), candidatePrefix.length());
        for (int i2 = 0; i2 < length && mainSequence.charAt(i2) == candidatePrefix.charAt(i2); ++i2) {
            ++charsMatched;
        }
        return charsMatched == candidatePrefix.length() ? charsMatched : 0;
    }
}

