/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.resultset.iterator;

import com.googlecode.concurrenttrees.common.LazyIterator;
import com.googlecode.cqengine.index.support.KeyValue;
import com.googlecode.cqengine.index.support.KeyValueMaterialized;
import com.googlecode.cqengine.resultset.filter.MaterializedDeduplicatedIterator;
import com.googlecode.cqengine.resultset.iterator.ConcatenatingIterator;
import com.googlecode.cqengine.resultset.iterator.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class IteratorUtil {
    public static <O> boolean iterableContains(Iterable<O> iterable, O element) {
        for (O contained : iterable) {
            if (!contained.equals(element)) continue;
            return true;
        }
        return false;
    }

    public static int countElements(Iterable<?> iterable) {
        int count = 0;
        for (Object object : iterable) {
            ++count;
        }
        return count;
    }

    public static <T> Iterator<T> removeNulls(final Iterator<T> unfiltered) {
        return new LazyIterator<T>(){

            @Override
            protected T computeNext() {
                while (unfiltered.hasNext()) {
                    Object element = unfiltered.next();
                    if (element == null) continue;
                    return element;
                }
                return this.endOfData();
            }
        };
    }

    public static <T> UnmodifiableIterator<T> wrapAsUnmodifiable(final Iterator<T> iterator) {
        return new UnmodifiableIterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }
        };
    }

    public static <A, O> Iterable<KeyValue<A, O>> flatten(final Map<A, ? extends Iterable<O>> map) {
        return new Iterable<KeyValue<A, O>>(){

            @Override
            public Iterator<KeyValue<A, O>> iterator() {
                return new LazyIterator<KeyValue<A, O>>(){
                    Iterator<? extends Map.Entry<A, ? extends Iterable<O>>> entriesIterator;
                    Iterator<KeyValue<A, O>> valuesIterator;
                    {
                        this.entriesIterator = map.entrySet().iterator();
                        this.valuesIterator = Collections.emptySet().iterator();
                    }

                    @Override
                    protected KeyValue<A, O> computeNext() {
                        while (!this.valuesIterator.hasNext()) {
                            if (!this.entriesIterator.hasNext()) {
                                return (KeyValue)this.endOfData();
                            }
                            Map.Entry entry = this.entriesIterator.next();
                            this.valuesIterator = IteratorUtil.flatten(entry.getKey(), entry.getValue()).iterator();
                        }
                        return this.valuesIterator.next();
                    }
                };
            }
        };
    }

    public static <A, O> Iterable<KeyValue<A, O>> flatten(final A key, final Iterable<O> values) {
        return new Iterable<KeyValue<A, O>>(){

            @Override
            public Iterator<KeyValue<A, O>> iterator() {
                return new LazyIterator<KeyValue<A, O>>(){
                    final Iterator<O> valuesIterator;
                    {
                        this.valuesIterator = values.iterator();
                    }

                    @Override
                    protected KeyValue<A, O> computeNext() {
                        return this.valuesIterator.hasNext() ? new KeyValueMaterialized(key, this.valuesIterator.next()) : (KeyValue)this.endOfData();
                    }
                };
            }
        };
    }

    public static <O> Iterator<O> concatenate(final Iterator<? extends Iterable<O>> iterables) {
        return new ConcatenatingIterator<O>(){

            @Override
            public Iterator<O> getNextIterator() {
                return iterables.hasNext() ? ((Iterable)iterables.next()).iterator() : null;
            }
        };
    }

    public static <O> Iterator<Set<O>> groupAndSort(final Iterator<? extends KeyValue<?, O>> values, final Comparator<O> comparator) {
        return new LazyIterator<Set<O>>(){
            final Iterator<? extends KeyValue<?, O>> valuesIterator;
            Set<O> currentGroup;
            Object currentKey;
            {
                this.valuesIterator = values;
                this.currentGroup = new TreeSet(comparator);
                this.currentKey = null;
            }

            @Override
            protected Set<O> computeNext() {
                while (this.valuesIterator.hasNext()) {
                    KeyValue next = this.valuesIterator.next();
                    if (!next.getKey().equals(this.currentKey)) {
                        Set result = this.currentGroup;
                        this.currentKey = next.getKey();
                        this.currentGroup = new TreeSet(comparator);
                        this.currentGroup.add(next.getValue());
                        return result;
                    }
                    this.currentGroup.add(next.getValue());
                }
                if (this.currentGroup.isEmpty()) {
                    return (Set)this.endOfData();
                }
                Set result = this.currentGroup;
                this.currentGroup = new TreeSet(comparator);
                return result;
            }
        };
    }

    public static <O> Iterator<O> materializedSort(Iterator<O> unsortedIterator, Comparator<O> comparator) {
        ArrayList<O> result = new ArrayList<O>();
        while (unsortedIterator.hasNext()) {
            result.add(unsortedIterator.next());
        }
        result.sort(comparator);
        return result.iterator();
    }

    public static <O> Iterator<O> materializedDeduplicate(Iterator<O> iterator) {
        return new MaterializedDeduplicatedIterator<O>(iterator);
    }
}

