/*
 * Decompiled with CFR 0.152.
 */
package com.insidious.common.parser;

import io.kaitai.struct.ByteBufferKaitaiStream;
import io.kaitai.struct.KaitaiStream;
import io.kaitai.struct.KaitaiStruct;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class KaitaiInsidiousClassWeaveParser
extends KaitaiStruct {
    private ArrayList<ClassInfo> classInfo;
    private KaitaiInsidiousClassWeaveParser _root;
    private KaitaiStruct _parent;

    public static KaitaiInsidiousClassWeaveParser fromFile(String fileName) throws IOException {
        return new KaitaiInsidiousClassWeaveParser(new ByteBufferKaitaiStream(fileName));
    }

    public KaitaiInsidiousClassWeaveParser(KaitaiStream _io) {
        this(_io, null, null);
    }

    public KaitaiInsidiousClassWeaveParser(KaitaiStream _io, KaitaiStruct _parent) {
        this(_io, _parent, null);
    }

    public KaitaiInsidiousClassWeaveParser(KaitaiStream _io, KaitaiStruct _parent, KaitaiInsidiousClassWeaveParser _root) {
        super(_io);
        this._parent = _parent;
        this._root = _root == null ? this : _root;
    }

    public void _read() {
        this.classInfo = new ArrayList();
        int i2 = 0;
        while (!this._io.isEof()) {
            this.classInfo.add(new ClassInfo(this._io, this, this._root));
            ++i2;
        }
    }

    public ClassInfo nextClass() {
        if (this._io.isEof()) {
            return null;
        }
        return new ClassInfo(this._io, this, this._root);
    }

    public ArrayList<ClassInfo> classInfo() {
        return this.classInfo;
    }

    public KaitaiInsidiousClassWeaveParser _root() {
        return this._root;
    }

    @Override
    public KaitaiStruct _parent() {
        return this._parent;
    }

    public static class ClassInfo
    extends KaitaiStruct {
        private long classId;
        private StrWithLen container;
        private StrWithLen fileName;
        private StrWithLen className;
        private StrWithLen logLevel;
        private StrWithLen hash;
        private StrWithLen classLoaderIdentifier;
        private long interfaceCount;
        private ArrayList<StrWithLen> interfaceNames;
        private StrWithLen signature;
        private StrWithLen superclass;
        private int isEnum;
        private int isPojo;
        private long probeCount;
        private ArrayList<ProbeInfo> probeList;
        private long methodCount;
        private ArrayList<MethodInfo> methodList;
        private KaitaiInsidiousClassWeaveParser _root;
        private KaitaiInsidiousClassWeaveParser _parent;

        public static ClassInfo fromFile(String fileName) throws IOException {
            return new ClassInfo(new ByteBufferKaitaiStream(fileName));
        }

        public ClassInfo(KaitaiStream _io) {
            this(_io, null, null);
        }

        public ClassInfo(KaitaiStream _io, KaitaiInsidiousClassWeaveParser _parent) {
            this(_io, _parent, null);
        }

        public ClassInfo(KaitaiStream _io, KaitaiInsidiousClassWeaveParser _parent, KaitaiInsidiousClassWeaveParser _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.classId = this._io.readU4be();
            this.container = new StrWithLen(this._io, this, this._root);
            this.fileName = new StrWithLen(this._io, this, this._root);
            this.className = new StrWithLen(this._io, this, this._root);
            this.logLevel = new StrWithLen(this._io, this, this._root);
            this.hash = new StrWithLen(this._io, this, this._root);
            this.classLoaderIdentifier = new StrWithLen(this._io, this, this._root);
            this.interfaceCount = this._io.readU4be();
            this.interfaceNames = new ArrayList();
            int i2 = 0;
            while ((long)i2 < this.interfaceCount()) {
                this.interfaceNames.add(new StrWithLen(this._io, this, this._root));
                ++i2;
            }
            this.signature = new StrWithLen(this._io, this, this._root);
            this.superclass = new StrWithLen(this._io, this, this._root);
            this.isEnum = this._io.readU1();
            this.isPojo = this._io.readU1();
            this.probeCount = this._io.readU4be();
            this.probeList = new ArrayList();
            i2 = 0;
            while ((long)i2 < this.probeCount()) {
                this.probeList.add(new ProbeInfo(this._io, this, this._root));
                ++i2;
            }
            this.methodCount = this._io.readU4be();
            this.methodList = new ArrayList();
            i2 = 0;
            while ((long)i2 < this.methodCount()) {
                this.methodList.add(new MethodInfo(this._io, this, this._root));
                ++i2;
            }
        }

        public long classId() {
            return this.classId;
        }

        public StrWithLen container() {
            return this.container;
        }

        public StrWithLen fileName() {
            return this.fileName;
        }

        public StrWithLen className() {
            return this.className;
        }

        public StrWithLen logLevel() {
            return this.logLevel;
        }

        public StrWithLen hash() {
            return this.hash;
        }

        public StrWithLen classLoaderIdentifier() {
            return this.classLoaderIdentifier;
        }

        public long interfaceCount() {
            return this.interfaceCount;
        }

        public ArrayList<StrWithLen> interfaceNames() {
            return this.interfaceNames;
        }

        public StrWithLen signature() {
            return this.signature;
        }

        public StrWithLen superclass() {
            return this.superclass;
        }

        public int isEnum() {
            return this.isEnum;
        }

        public int isPojo() {
            return this.isPojo;
        }

        public long probeCount() {
            return this.probeCount;
        }

        public ArrayList<ProbeInfo> probeList() {
            return this.probeList;
        }

        public long methodCount() {
            return this.methodCount;
        }

        public ArrayList<MethodInfo> methodList() {
            return this.methodList;
        }

        public KaitaiInsidiousClassWeaveParser _root() {
            return this._root;
        }

        @Override
        public KaitaiInsidiousClassWeaveParser _parent() {
            return this._parent;
        }
    }

    public static class StrWithLen
    extends KaitaiStruct {
        private long len;
        private String value;
        private KaitaiInsidiousClassWeaveParser _root;
        private KaitaiStruct _parent;

        public static StrWithLen fromFile(String fileName) throws IOException {
            return new StrWithLen(new ByteBufferKaitaiStream(fileName));
        }

        public StrWithLen(KaitaiStream _io) {
            this(_io, null, null);
        }

        public StrWithLen(KaitaiStream _io, KaitaiStruct _parent) {
            this(_io, _parent, null);
        }

        public StrWithLen(KaitaiStream _io, KaitaiStruct _parent, KaitaiInsidiousClassWeaveParser _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.len = this._io.readU4be();
            this.value = new String(this._io.readBytes(this.len()), Charset.forName("UTF-8"));
        }

        public long len() {
            return this.len;
        }

        public String value() {
            return this.value;
        }

        public KaitaiInsidiousClassWeaveParser _root() {
            return this._root;
        }

        @Override
        public KaitaiStruct _parent() {
            return this._parent;
        }
    }

    public static class ProbeInfo
    extends KaitaiStruct {
        private long classId;
        private long methodId;
        private long dataId;
        private long lineNumber;
        private long instructionIndex;
        private EventType eventType;
        private Descriptor valueDescriptor;
        private StrWithLen attributes;
        private KaitaiInsidiousClassWeaveParser _root;
        private ClassInfo _parent;

        public static ProbeInfo fromFile(String fileName) throws IOException {
            return new ProbeInfo(new ByteBufferKaitaiStream(fileName));
        }

        public ProbeInfo(KaitaiStream _io) {
            this(_io, null, null);
        }

        public ProbeInfo(KaitaiStream _io, ClassInfo _parent) {
            this(_io, _parent, null);
        }

        public ProbeInfo(KaitaiStream _io, ClassInfo _parent, KaitaiInsidiousClassWeaveParser _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.classId = this._io.readU4be();
            this.methodId = this._io.readU4be();
            this.dataId = this._io.readU4be();
            this.lineNumber = this._io.readU4be();
            this.instructionIndex = this._io.readU4be();
            this.eventType = EventType.byId(this._io.readU4be());
            this.valueDescriptor = Descriptor.byId(this._io.readU4be());
            this.attributes = new StrWithLen(this._io, this, this._root);
        }

        public long classId() {
            return this.classId;
        }

        public long methodId() {
            return this.methodId;
        }

        public long dataId() {
            return this.dataId;
        }

        public long lineNumber() {
            return this.lineNumber;
        }

        public long instructionIndex() {
            return this.instructionIndex;
        }

        public EventType eventType() {
            return this.eventType;
        }

        public Descriptor valueDescriptor() {
            return this.valueDescriptor;
        }

        public StrWithLen attributes() {
            return this.attributes;
        }

        public KaitaiInsidiousClassWeaveParser _root() {
            return this._root;
        }

        @Override
        public ClassInfo _parent() {
            return this._parent;
        }
    }

    public static class MethodInfo
    extends KaitaiStruct {
        private long classId;
        private long methodId;
        private StrWithLen methodName;
        private StrWithLen methodDescriptor;
        private long access;
        private StrWithLen sourceFileName;
        private StrWithLen methodHash;
        private KaitaiInsidiousClassWeaveParser _root;
        private ClassInfo _parent;

        public static MethodInfo fromFile(String fileName) throws IOException {
            return new MethodInfo(new ByteBufferKaitaiStream(fileName));
        }

        public MethodInfo(KaitaiStream _io) {
            this(_io, null, null);
        }

        public MethodInfo(KaitaiStream _io, ClassInfo _parent) {
            this(_io, _parent, null);
        }

        public MethodInfo(KaitaiStream _io, ClassInfo _parent, KaitaiInsidiousClassWeaveParser _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.classId = this._io.readU4be();
            this.methodId = this._io.readU4be();
            this.methodName = new StrWithLen(this._io, this, this._root);
            this.methodDescriptor = new StrWithLen(this._io, this, this._root);
            this.access = this._io.readU4be();
            this.sourceFileName = new StrWithLen(this._io, this, this._root);
            this.methodHash = new StrWithLen(this._io, this, this._root);
        }

        public long classId() {
            return this.classId;
        }

        public long methodId() {
            return this.methodId;
        }

        public StrWithLen methodName() {
            return this.methodName;
        }

        public StrWithLen methodDescriptor() {
            return this.methodDescriptor;
        }

        public long access() {
            return this.access;
        }

        public StrWithLen sourceFileName() {
            return this.sourceFileName;
        }

        public StrWithLen methodHash() {
            return this.methodHash;
        }

        public KaitaiInsidiousClassWeaveParser _root() {
            return this._root;
        }

        @Override
        public ClassInfo _parent() {
            return this._parent;
        }
    }

    public static enum EventType {
        RESERVED(0L),
        METHOD_ENTRY(1L),
        METHOD_PARAM(2L),
        METHOD_OBJECT_INITIALIZED(3L),
        METHOD_NORMAL_EXIT(4L),
        METHOD_THROW(5L),
        METHOD_EXCEPTIONAL_EXIT(6L),
        CALL(7L),
        CALL_PARAM(8L),
        CALL_RETURN(9L),
        CATCH_LABEL(10L),
        CATCH(11L),
        NEW_OBJECT(12L),
        NEW_OBJECT_CREATED(13L),
        GET_INSTANCE_FIELD(14L),
        GET_INSTANCE_FIELD_RESULT(15L),
        GET_STATIC_FIELD(16L),
        PUT_INSTANCE_FIELD(17L),
        PUT_INSTANCE_FIELD_VALUE(18L),
        PUT_INSTANCE_FIELD_BEFORE_INITIALIZATION(19L),
        PUT_STATIC_FIELD(20L),
        ARRAY_LOAD(21L),
        ARRAY_LOAD_INDEX(22L),
        ARRAY_LOAD_RESULT(23L),
        ARRAY_STORE(24L),
        ARRAY_STORE_INDEX(25L),
        ARRAY_STORE_VALUE(26L),
        NEW_ARRAY(27L),
        NEW_ARRAY_RESULT(28L),
        MULTI_NEW_ARRAY(29L),
        MULTI_NEW_ARRAY_OWNER(30L),
        MULTI_NEW_ARRAY_ELEMENT(31L),
        ARRAY_LENGTH(32L),
        ARRAY_LENGTH_RESULT(33L),
        MONITOR_ENTER(34L),
        MONITOR_ENTER_RESULT(35L),
        MONITOR_EXIT(36L),
        OBJECT_CONSTANT_LOAD(37L),
        OBJECT_INSTANCEOF(38L),
        OBJECT_INSTANCEOF_RESULT(39L),
        INVOKE_DYNAMIC(40L),
        INVOKE_DYNAMIC_PARAM(41L),
        INVOKE_DYNAMIC_RESULT(42L),
        LABEL(43L),
        JUMP(44L),
        LOCAL_LOAD(45L),
        LOCAL_STORE(46L),
        LOCAL_INCREMENT(47L),
        RET(48L),
        DIVIDE(49L),
        LINE_NUMBER(50L);

        private final long id;
        private static final Map<Long, EventType> byId;

        private EventType(long id) {
            this.id = id;
        }

        public long id() {
            return this.id;
        }

        public static EventType byId(long id) {
            return byId.get(id);
        }

        static {
            byId = new HashMap<Long, EventType>(51);
            for (EventType e : EventType.values()) {
                byId.put(e.id(), e);
            }
        }
    }

    public static enum Descriptor {
        BOOLEAN(0L),
        BYTE(1L),
        CHAR(2L),
        SHORT(3L),
        INTEGER(4L),
        LONG(5L),
        FLOAT(6L),
        DOUBLE(7L),
        INTEGEROBJECT(8L),
        CHARACTEROBJECT(9L),
        BOOLEANOBJECT(10L),
        FLOATOBJECT(11L),
        DOUBLEOBJECT(12L),
        SHORTOBJECT(13L),
        BYTEOBJECT(14L),
        LONGOBJECT(15L),
        OBJECT(16L),
        VOID(17L);

        private final long id;
        private static final Map<Long, Descriptor> byId;

        private Descriptor(long id) {
            this.id = id;
        }

        public long id() {
            return this.id;
        }

        public static Descriptor byId(long id) {
            return byId.get(id);
        }

        static {
            byId = new HashMap<Long, Descriptor>(18);
            for (Descriptor e : Descriptor.values()) {
                byId.put(e.id(), e);
            }
        }
    }
}

