/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.BitSet;

public class BitSetSerializer
extends Serializer<BitSet> {
    @Override
    public BitSet copy(Kryo kryo, BitSet original) {
        BitSet result = new BitSet();
        int length = original.length();
        for (int i2 = 0; i2 < length; ++i2) {
            result.set(i2, original.get(i2));
        }
        return result;
    }

    @Override
    public void write(Kryo kryo, Output output, BitSet bitSet) {
        int len = bitSet.length();
        output.writeInt(len, true);
        for (int i2 = 0; i2 < len; ++i2) {
            output.writeBoolean(bitSet.get(i2));
        }
    }

    @Override
    public BitSet read(Kryo kryo, Input input, Class<? extends BitSet> bitSetClass) {
        int len = input.readInt(true);
        BitSet ret = new BitSet(len);
        for (int i2 = 0; i2 < len; ++i2) {
            ret.set(i2, input.readBoolean());
        }
        return ret;
    }
}

