/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;

public class UnicodeBlockSerializer
extends Serializer<Character.UnicodeBlock> {
    private static final IdentityHashMap<Character.UnicodeBlock, String> BLOCK_NAMES = new IdentityHashMap();

    @Override
    public void write(Kryo kryo, Output output, Character.UnicodeBlock obj) {
        output.writeAscii(BLOCK_NAMES.get(obj));
    }

    @Override
    public Character.UnicodeBlock copy(Kryo kryo, Character.UnicodeBlock original) {
        return original;
    }

    @Override
    public Character.UnicodeBlock read(Kryo kryo, Input input, Class<? extends Character.UnicodeBlock> unicodeBlockClass) {
        String name = input.readString();
        return name == null ? null : Character.UnicodeBlock.forName(name);
    }

    static {
        for (Field field : Character.UnicodeBlock.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                field.setAccessible(true);
                Object value = field.get(null);
                if (!(value instanceof Character.UnicodeBlock)) continue;
                BLOCK_NAMES.put((Character.UnicodeBlock)value, field.getName());
            }
            catch (IllegalAccessException e) {
                throw new InternalError();
            }
        }
    }
}

