/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers.guava;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Comparator;

public class ImmutableSortedSetSerializer
extends Serializer<ImmutableSortedSet<Object>> {
    private static final boolean DOES_NOT_ACCEPT_NULL = false;
    private static final boolean IMMUTABLE = true;

    public ImmutableSortedSetSerializer() {
        super(false, true);
    }

    @Override
    public void write(Kryo kryo, Output output, ImmutableSortedSet<Object> object) {
        kryo.writeClassAndObject(output, object.comparator());
        output.writeInt(object.size(), true);
        for (Object elm : object) {
            kryo.writeClassAndObject(output, elm);
        }
    }

    @Override
    public ImmutableSortedSet<Object> read(Kryo kryo, Input input, Class<? extends ImmutableSortedSet<Object>> type) {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.orderedBy((Comparator)((Comparator)kryo.readClassAndObject(input)));
        int size = input.readInt(true);
        for (int i2 = 0; i2 < size; ++i2) {
            builder.add(kryo.readClassAndObject(input));
        }
        return builder.build();
    }

    public static void registerSerializers(Kryo kryo) {
        ImmutableSortedSetSerializer serializer = new ImmutableSortedSetSerializer();
        kryo.register(ImmutableSortedSet.class, serializer);
        kryo.register(ImmutableSortedSet.of().getClass(), serializer);
        kryo.register(ImmutableSortedSet.of((Comparable)((Object)"")).getClass(), serializer);
        kryo.register(ImmutableSortedSet.of().descendingSet().getClass(), serializer);
    }
}

