/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers.guava;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.Multimap;
import java.util.Map;

public abstract class MultimapSerializerBase<K, V, T extends Multimap<K, V>>
extends Serializer<T> {
    public MultimapSerializerBase(boolean acceptsNull, boolean immutable) {
        super(acceptsNull, immutable);
    }

    protected void writeMultimap(Kryo kryo, Output output, Multimap<K, V> multimap) {
        output.writeInt(multimap.size(), true);
        for (Map.Entry entry : multimap.entries()) {
            kryo.writeClassAndObject(output, entry.getKey());
            kryo.writeClassAndObject(output, entry.getValue());
        }
    }

    protected void readMultimap(Kryo kryo, Input input, Multimap<K, V> multimap) {
        int size = input.readInt(true);
        for (int i2 = 0; i2 < size; ++i2) {
            Object key = kryo.readClassAndObject(input);
            Object value = kryo.readClassAndObject(input);
            multimap.put(key, value);
        }
    }

    protected abstract Multimap createCopy(Kryo var1, Multimap var2);

    @Override
    public Multimap copy(Kryo kryo, Multimap original) {
        Multimap copy = this.createCopy(kryo, original);
        for (Map.Entry entry : original.entries()) {
            copy.put(kryo.copy(entry.getKey()), kryo.copy(entry.getValue()));
        }
        return copy;
    }
}

