/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers.guava;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.Table;
import java.util.Map;

public abstract class TableSerializerBase<R, C, V, T extends Table<R, C, V>>
extends Serializer<T> {
    public TableSerializerBase(boolean doesNotAcceptNull, boolean immutable) {
        super(doesNotAcceptNull, immutable);
    }

    public void writeTable(Kryo kryo, Output output, Table<R, C, V> table) {
        Map rowMap = table.rowMap();
        output.writeInt(rowMap.size(), true);
        for (Object r : rowMap.keySet()) {
            kryo.writeClassAndObject(output, r);
            Map colMap = (Map)rowMap.get(r);
            output.writeInt(colMap.size(), true);
            for (Object c : colMap.keySet()) {
                Object v = colMap.get(c);
                kryo.writeClassAndObject(output, c);
                kryo.writeClassAndObject(output, v);
            }
        }
    }

    public void readTable(Kryo kryo, Input input, final Table<R, C, V> table) {
        this.readTable(kryo, input, new CellConsumer<R, C, V>(){

            @Override
            public void accept(R r, C c, V v) {
                table.put(r, c, v);
            }
        });
    }

    public void readTable(Kryo kryo, Input input, CellConsumer<R, C, V> cellConsumer) {
        int rows = input.readInt(true);
        for (int i2 = 0; i2 < rows; ++i2) {
            Object r = kryo.readClassAndObject(input);
            int cols = input.readInt(true);
            for (int j = 0; j < cols; ++j) {
                Object c = kryo.readClassAndObject(input);
                Object v = kryo.readClassAndObject(input);
                cellConsumer.accept(r, c, v);
            }
        }
    }

    static interface CellConsumer<R, C, V> {
        public void accept(R var1, C var2, V var3);
    }
}

