/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers.guava;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.TreeBasedTable;
import de.javakaffee.kryoserializers.guava.TableSerializerBase;
import java.util.Comparator;

public class TreeBasedTableSerializer<R extends Comparable, C extends Comparable, V>
extends TableSerializerBase<R, C, V, TreeBasedTable<R, C, V>> {
    private static final boolean HANDLES_NULL = false;
    private static final boolean IMMUTABLE = false;

    public TreeBasedTableSerializer() {
        super(false, false);
    }

    @Override
    public void write(Kryo kryo, Output output, TreeBasedTable<R, C, V> table) {
        kryo.writeClassAndObject(output, table.rowComparator());
        kryo.writeClassAndObject(output, table.columnComparator());
        super.writeTable(kryo, output, table);
    }

    @Override
    public TreeBasedTable<R, C, V> read(Kryo kryo, Input input, Class<? extends TreeBasedTable<R, C, V>> type) {
        Comparator rowComparator = (Comparator)kryo.readClassAndObject(input);
        Comparator columnComparator = (Comparator)kryo.readClassAndObject(input);
        TreeBasedTable table = TreeBasedTable.create((Comparator)rowComparator, (Comparator)columnComparator);
        super.readTable(kryo, input, table);
        return table;
    }

    @Override
    public TreeBasedTable<R, C, V> copy(Kryo kryo, TreeBasedTable<R, C, V> original) {
        return TreeBasedTable.create(original);
    }

    public static void registerSerializers(Kryo kryo) {
        TreeBasedTableSerializer serializer = new TreeBasedTableSerializer();
        kryo.register(TreeBasedTable.class, serializer);
    }
}

