/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers.protobuf;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.protobuf.AbstractMessage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ProtobufSerializer<T extends AbstractMessage>
extends Serializer<T> {
    private Method parseFromMethod = null;

    @Override
    public void write(Kryo kryo, Output output, T protobufMessage) {
        if (protobufMessage == null) {
            output.writeByte((byte)0);
            output.flush();
            return;
        }
        byte[] bytes = protobufMessage.toByteArray();
        output.writeInt(bytes.length + 1, true);
        output.writeBytes(bytes);
        output.flush();
    }

    @Override
    public T read(Kryo kryo, Input input, Class<? extends T> type) {
        int length = input.readInt(true);
        if (length == 0) {
            return null;
        }
        byte[] bytes = input.readBytes(length - 1);
        try {
            return (T)((AbstractMessage)this.getParseFromMethod(type).invoke(type, new Object[]{bytes}));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to deserialize protobuf " + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Unable to deserialize protobuf " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to deserialize protobuf " + e.getMessage(), e);
        }
    }

    private Method getParseFromMethod(Class<? extends T> type) throws NoSuchMethodException {
        if (this.parseFromMethod == null) {
            this.parseFromMethod = type.getMethod("parseFrom", byte[].class);
        }
        return this.parseFromMethod;
    }

    @Override
    public boolean getAcceptsNull() {
        return true;
    }
}

