/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent.atomic;

import java.io.Serializable;

public class AtomicLongArray
implements Serializable {
    private static final long serialVersionUID = -2308431214976778248L;
    private final long[] array;

    public AtomicLongArray(int length) {
        this.array = new long[length];
    }

    public AtomicLongArray(long[] array) {
        if (array == null) {
            throw new NullPointerException();
        }
        int length = array.length;
        this.array = new long[length];
        System.arraycopy(array, 0, this.array, 0, array.length);
    }

    public final int length() {
        return this.array.length;
    }

    public final synchronized long get(int i2) {
        return this.array[i2];
    }

    public final synchronized void set(int i2, long newValue) {
        this.array[i2] = newValue;
    }

    public final synchronized void lazySet(int i2, long newValue) {
        this.array[i2] = newValue;
    }

    public final synchronized long getAndSet(int i2, long newValue) {
        long old = this.array[i2];
        this.array[i2] = newValue;
        return old;
    }

    public final synchronized boolean compareAndSet(int i2, long expect, long update) {
        if (this.array[i2] == expect) {
            this.array[i2] = update;
            return true;
        }
        return false;
    }

    public final synchronized boolean weakCompareAndSet(int i2, long expect, long update) {
        if (this.array[i2] == expect) {
            this.array[i2] = update;
            return true;
        }
        return false;
    }

    public final synchronized long getAndIncrement(int i2) {
        int n = i2;
        long l = this.array[n];
        this.array[n] = l + 1L;
        return l;
    }

    public final synchronized long getAndDecrement(int i2) {
        int n = i2;
        long l = this.array[n];
        this.array[n] = l - 1L;
        return l;
    }

    public final synchronized long getAndAdd(int i2, long delta) {
        long old = this.array[i2];
        int n = i2;
        this.array[n] = this.array[n] + delta;
        return old;
    }

    public final synchronized long incrementAndGet(int i2) {
        int n = i2;
        long l = this.array[n] + 1L;
        this.array[n] = l;
        return l;
    }

    public final synchronized long decrementAndGet(int i2) {
        int n = i2;
        long l = this.array[n] - 1L;
        this.array[n] = l;
        return l;
    }

    public synchronized long addAndGet(int i2, long delta) {
        int n = i2;
        long l = this.array[n] + delta;
        this.array[n] = l;
        return l;
    }

    public synchronized String toString() {
        if (this.array.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        buf.append(this.array[0]);
        for (int i2 = 1; i2 < this.array.length; ++i2) {
            buf.append(", ");
            buf.append(this.array[i2]);
        }
        buf.append("]");
        return buf.toString();
    }
}

