/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent.atomic;

import java.io.Serializable;

public class AtomicReferenceArray
implements Serializable {
    private static final long serialVersionUID = -6209656149925076980L;
    private final Object[] array;

    public AtomicReferenceArray(int length) {
        this.array = new Object[length];
    }

    public AtomicReferenceArray(Object[] array) {
        if (array == null) {
            throw new NullPointerException();
        }
        int length = array.length;
        this.array = new Object[length];
        System.arraycopy(array, 0, this.array, 0, array.length);
    }

    public final int length() {
        return this.array.length;
    }

    public final synchronized Object get(int i2) {
        return this.array[i2];
    }

    public final synchronized void set(int i2, Object newValue) {
        this.array[i2] = newValue;
    }

    public final synchronized void lazySet(int i2, Object newValue) {
        this.array[i2] = newValue;
    }

    public final synchronized Object getAndSet(int i2, Object newValue) {
        Object old = this.array[i2];
        this.array[i2] = newValue;
        return old;
    }

    public final synchronized boolean compareAndSet(int i2, Object expect, Object update) {
        if (this.array[i2] == expect) {
            this.array[i2] = update;
            return true;
        }
        return false;
    }

    public final synchronized boolean weakCompareAndSet(int i2, Object expect, Object update) {
        if (this.array[i2] == expect) {
            this.array[i2] = update;
            return true;
        }
        return false;
    }

    public synchronized String toString() {
        if (this.array.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; i2 < this.array.length; ++i2) {
            if (i2 == 0) {
                buf.append('[');
            } else {
                buf.append(", ");
            }
            buf.append(String.valueOf(this.array[i2]));
        }
        buf.append("]");
        return buf.toString();
    }
}

