/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged;

import io.unlogged.mocking.DeclaredMock;
import io.unlogged.mocking.MethodExitType;
import io.unlogged.mocking.MockHandler;
import io.unlogged.mocking.MockInstance;
import io.unlogged.mocking.ParameterMatcher;
import io.unlogged.mocking.ReturnValue;
import io.unlogged.mocking.ReturnValueType;
import io.unlogged.mocking.ThenParameter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.objenesis.Objenesis;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import selogger.com.fasterxml.jackson.core.JsonProcessingException;
import selogger.com.fasterxml.jackson.databind.JavaType;
import selogger.com.fasterxml.jackson.databind.JsonNode;
import selogger.com.fasterxml.jackson.databind.ObjectMapper;
import selogger.com.fasterxml.jackson.databind.node.TextNode;
import selogger.com.fasterxml.jackson.databind.type.CollectionType;
import selogger.com.fasterxml.jackson.databind.type.TypeFactory;
import selogger.net.bytebuddy.ByteBuddy;
import selogger.net.bytebuddy.dynamic.DynamicType;
import selogger.net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import selogger.net.bytebuddy.implementation.MethodDelegation;
import selogger.net.bytebuddy.matcher.ElementMatchers;

public class ParameterFactory {
    public static final String MULTI_VALUE_MAP_CLASS = "org.springframework.util.MultiValueMap";
    public static final String LINKED_MULTI_VALUE_MAP = "org.springframework.util.LinkedMultiValueMap";
    private final Objenesis objenesis;
    private final ObjectMapper objectMapper;
    private final ByteBuddy byteBuddyInstance;
    private ObjectMapper basicObjectMapper = new ObjectMapper();

    public ParameterFactory(Objenesis objenesis, ObjectMapper objectMapper, ByteBuddy byteBuddyInstance) {
        this.byteBuddyInstance = byteBuddyInstance;
        this.objectMapper = objectMapper;
        this.objenesis = objenesis;
    }

    public Class<?>[] getAllInterfaces(Object o) {
        try {
            HashSet results = new HashSet();
            this.getAllInterfaces(o, results::add);
            return results.toArray(new Class[0]);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void getAllInterfaces(Object o, Function<Class<?>, Boolean> accumulator) throws IllegalArgumentException {
        if (null == o) {
            return;
        }
        if (null == accumulator) {
            throw new IllegalArgumentException("Accumulator cannot be null");
        }
        if (o instanceof Class) {
            Class clazz = (Class)o;
            if (clazz.isInterface()) {
                if (accumulator.apply((Class)o).booleanValue()) {
                    for (Class<?> aClass : clazz.getInterfaces()) {
                        this.getAllInterfaces(aClass, accumulator);
                    }
                }
            } else {
                if (null != clazz.getSuperclass()) {
                    this.getAllInterfaces(clazz.getSuperclass(), accumulator);
                }
                for (Class<?> aClass : clazz.getInterfaces()) {
                    this.getAllInterfaces(aClass, accumulator);
                }
            }
        } else {
            this.getAllInterfaces(o.getClass(), accumulator);
        }
    }

    public Object createParameterUsingObjenesis(JavaType typeReference, String methodParameter) throws JsonProcessingException, IllegalAccessException {
        Class<?> rawClass = typeReference.getRawClass();
        Object parameterObject = this.objenesis.newInstance(rawClass);
        Class<?> currentClass = rawClass;
        JsonNode providedValues = this.objectMapper.readTree(methodParameter);
        while (!currentClass.equals(Object.class)) {
            Field[] declaredFields;
            for (Field declaredField : declaredFields = currentClass.getDeclaredFields()) {
                JsonNode fieldValueInNodeByName = providedValues.get(declaredField.getName());
                Object valueToSet = this.getValueToSet(fieldValueInNodeByName, declaredField.getType());
                if (valueToSet == null) continue;
                declaredField.setAccessible(true);
                declaredField.set(parameterObject, valueToSet);
            }
            currentClass = currentClass.getSuperclass();
        }
        return parameterObject;
    }

    private Object getValueToSet(JsonNode fieldValueInNodeByName, Class<?> type) {
        if (fieldValueInNodeByName == null) {
            return null;
        }
        Object valueToSet = null;
        if (Integer.TYPE.equals(type) || Integer.class.equals(type)) {
            valueToSet = fieldValueInNodeByName.intValue();
            if (fieldValueInNodeByName instanceof TextNode) {
                valueToSet = Integer.parseInt(fieldValueInNodeByName.textValue());
            }
        } else if (Long.TYPE.equals(type) || Long.class.equals(type)) {
            valueToSet = fieldValueInNodeByName.longValue();
            if (fieldValueInNodeByName instanceof TextNode) {
                valueToSet = Long.parseLong(fieldValueInNodeByName.textValue());
            }
        } else if (Double.TYPE.equals(type) || Double.class.equals(type)) {
            valueToSet = fieldValueInNodeByName.doubleValue();
            if (fieldValueInNodeByName instanceof TextNode) {
                valueToSet = Double.parseDouble(fieldValueInNodeByName.textValue());
            }
        } else if (Float.TYPE.equals(type) || Float.class.equals(type)) {
            valueToSet = Float.valueOf(fieldValueInNodeByName.floatValue());
            if (fieldValueInNodeByName instanceof TextNode) {
                valueToSet = Float.valueOf(Float.parseFloat(fieldValueInNodeByName.textValue()));
            }
        } else if (Boolean.TYPE.equals(type) || Boolean.class.equals(type)) {
            valueToSet = fieldValueInNodeByName.booleanValue();
            if (fieldValueInNodeByName instanceof TextNode) {
                valueToSet = Boolean.parseBoolean(fieldValueInNodeByName.textValue());
            }
        } else if (Short.TYPE.equals(type) || Short.class.equals(type)) {
            valueToSet = fieldValueInNodeByName.shortValue();
            if (fieldValueInNodeByName instanceof TextNode) {
                valueToSet = Short.parseShort(fieldValueInNodeByName.textValue());
            }
        } else if (String.class.equals(type)) {
            valueToSet = fieldValueInNodeByName.textValue();
        } else if (StringBuilder.class.equals(type)) {
            valueToSet = new StringBuilder(fieldValueInNodeByName.textValue());
        } else {
            String valAsJsonString = fieldValueInNodeByName.toString();
            if (fieldValueInNodeByName instanceof TextNode) {
                valAsJsonString = fieldValueInNodeByName.textValue();
            }
            valueToSet = this.createObjectInstanceFromStringAndTypeInformation(null, valAsJsonString, type, this.objectMapper.getTypeFactory());
        }
        return valueToSet;
    }

    public Object createObjectInstanceFromStringAndTypeInformation(String targetClassName, String objectJsonRepresentation, Class<?> parameterType, TypeFactory typeFactory) {
        Object parameterObject = null;
        if (parameterType.getCanonicalName().equals(MULTI_VALUE_MAP_CLASS)) {
            try {
                parameterObject = this.objectMapper.readValue(objectJsonRepresentation, Class.forName(LINKED_MULTI_VALUE_MAP));
                return parameterObject;
            }
            catch (ClassNotFoundException | JsonProcessingException exception) {
                // empty catch block
            }
        }
        JavaType typeReference = null;
        try {
            if (targetClassName != null) {
                typeReference = MockHandler.getTypeReference(typeFactory, targetClassName);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (typeReference == null) {
            typeReference = typeFactory.constructType(parameterType);
        }
        try {
            parameterObject = this.objectFromTypeReference(objectJsonRepresentation, parameterType, typeReference);
        }
        catch (ClassNotFoundException | JsonProcessingException exception) {
            // empty catch block
        }
        return parameterObject;
    }

    private Object objectFromTypeReference(String methodParameter, Class<?> parameterType, JavaType typeReference) throws JsonProcessingException, ClassNotFoundException {
        Object parameterObject;
        String rawClassCanonicalName = typeReference != null ? typeReference.getRawClass().getCanonicalName() : "java.util.String";
        JavaType firstComponent = typeReference != null && typeReference.containedTypeCount() > 0 ? typeReference.containedType(0) : null;
        switch (rawClassCanonicalName) {
            case "reactor.core.publisher.Mono": {
                parameterObject = this.objectFromTypeReference(methodParameter, parameterType, firstComponent);
                parameterObject = parameterObject == null ? Mono.empty() : Mono.just((Object)parameterObject);
                break;
            }
            case "java.util.concurrent.CompletableFuture": {
                Object finalObj = this.objectFromTypeReference(methodParameter, parameterType, firstComponent);
                parameterObject = CompletableFuture.supplyAsync(() -> finalObj);
                break;
            }
            case "java.util.Optional": {
                parameterObject = this.objectFromTypeReference(methodParameter, parameterType, firstComponent);
                parameterObject = parameterObject == null ? Optional.empty() : Optional.of(parameterObject);
                break;
            }
            case "reactor.core.publisher.Flux": {
                CollectionType actuallyComponent = this.objectMapper.getTypeFactory().constructCollectionType(ArrayList.class, firstComponent);
                List parameterObjectList = (List)this.objectFromTypeReference(methodParameter, parameterType, actuallyComponent);
                parameterObject = parameterObjectList == null ? Flux.empty() : Flux.fromIterable((Iterable)parameterObjectList);
                break;
            }
            default: {
                try {
                    if (methodParameter.equals("null")) {
                        return null;
                    }
                    parameterObject = this.objectMapper.readValue(methodParameter, typeReference);
                    break;
                }
                catch (Throwable e2) {
                    try {
                        Object parameterObject2 = this.basicObjectMapper.readValue(methodParameter, typeReference);
                        return parameterObject2;
                    }
                    catch (Throwable throwable) {
                        if (methodParameter.startsWith("\"") && methodParameter.endsWith("\"")) {
                            try {
                                Object parameterObject3 = this.objectMapper.readValue(methodParameter.substring(1, methodParameter.length() - 1), typeReference);
                                return parameterObject3;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        try {
                            parameterObject = this.createParameterUsingObjenesis(typeReference, methodParameter);
                            break;
                        }
                        catch (Throwable e3) {
                            parameterObject = this.createParameterUsingMocking(methodParameter, parameterType);
                        }
                    }
                }
            }
        }
        return parameterObject;
    }

    private Object createParameterUsingMocking(String methodParameter, Class<?> parameterType) throws JsonProcessingException {
        MockInstance parameterObject;
        ArrayList<DeclaredMock> mockList = new ArrayList<DeclaredMock>();
        JsonNode providedValues = this.objectMapper.readTree(methodParameter);
        for (Class<?> currentClass = parameterType; currentClass != null && !currentClass.equals(Object.class); currentClass = currentClass.getSuperclass()) {
            Method[] definedMethods;
            for (Method definedMethod : definedMethods = currentClass.getDeclaredMethods()) {
                String methodName;
                String potentialFieldName = methodName = definedMethod.getName();
                Class<?> valueType = null;
                if (methodName.startsWith("get") && definedMethod.getParameterTypes().length == 0) {
                    potentialFieldName = methodName.substring(3);
                    valueType = definedMethod.getReturnType();
                } else if (methodName.startsWith("is") && definedMethod.getParameterTypes().length == 0) {
                    valueType = definedMethod.getReturnType();
                    potentialFieldName = methodName.substring(2);
                }
                potentialFieldName = potentialFieldName.substring(0, 1).toLowerCase() + potentialFieldName.substring(1);
                if (!providedValues.has(potentialFieldName)) continue;
                JsonNode providedValue = providedValues.get(potentialFieldName);
                if (!methodName.startsWith("get") && !methodName.startsWith("is")) continue;
                ArrayList<ThenParameter> thenParameterList = new ArrayList<ThenParameter>();
                ReturnValue returnParameter = this.checkCanClassBeExtended(valueType) ? new ReturnValue(providedValue instanceof TextNode ? providedValue.textValue() : providedValue.toString(), valueType.getCanonicalName(), ReturnValueType.MOCK) : new ReturnValue(providedValue.toString(), valueType.getCanonicalName(), ReturnValueType.REAL);
                DeclaredMock returnParamCallMock = new DeclaredMock();
                returnParameter.addDeclaredMock(returnParamCallMock);
                ThenParameter thenParameter = new ThenParameter(returnParameter, MethodExitType.NORMAL);
                thenParameterList.add(thenParameter);
                DeclaredMock dummyMockDefinition = new DeclaredMock("generated mock for " + methodName, valueType.getCanonicalName(), potentialFieldName, methodName, new ArrayList<ParameterMatcher>(), thenParameterList);
                mockList.add(dummyMockDefinition);
            }
        }
        try {
            parameterObject = this.createMockedInstance(parameterType.getClassLoader(), null, null, mockList, null, parameterType);
        }
        catch (Exception e) {
            return null;
        }
        return parameterObject.getMockedFieldInstance();
    }

    public MockInstance createMockedInstance(ClassLoader targetClassLoader, Object fieldParentInstance, Field field, List<DeclaredMock> parameterCallMocks, Object existingFieldInstance, Class<?> parameterType) {
        DynamicType.Loaded loadedMockedField;
        ClassLoadingStrategy.Default strategy = ClassLoadingStrategy.Default.INJECTION;
        if (fieldParentInstance == null && field != null) {
            System.out.println("objectInstanceByClass is null: " + field.getType().getCanonicalName() + " " + field.getName());
        }
        MockHandler mockHandler = new MockHandler(parameterCallMocks, this.objectMapper, this, this.objenesis, existingFieldInstance, fieldParentInstance, targetClassLoader, field);
        if (parameterType.isInterface()) {
            Class<?>[] implementedInterfaces = this.getAllInterfaces(parameterType);
            HashSet<String> implementedClasses = new HashSet<String>();
            implementedClasses.add(parameterType.getCanonicalName());
            ArrayList pendingImplementations = new ArrayList();
            pendingImplementations.add(parameterType);
            for (Class<?> implementedInterface : implementedInterfaces) {
                if (implementedClasses.contains(implementedInterface.getCanonicalName())) continue;
                implementedClasses.add(implementedInterface.getCanonicalName());
                pendingImplementations.add(implementedInterface);
            }
            loadedMockedField = this.byteBuddyInstance.subclass(Object.class).implement(pendingImplementations).intercept(MethodDelegation.to(mockHandler)).make().load(targetClassLoader, strategy);
        } else {
            loadedMockedField = this.byteBuddyInstance.subclass(parameterType).method(ElementMatchers.isDeclaredBy(parameterType)).intercept(MethodDelegation.to(mockHandler)).make().load(targetClassLoader, strategy);
        }
        Object mockedFieldInstance = this.objenesis.newInstance(loadedMockedField.getLoaded());
        MockInstance existingMockInstance = new MockInstance(mockedFieldInstance, mockHandler);
        return existingMockInstance;
    }

    private boolean checkCanClassBeExtended(Class<?> fieldType) {
        if (fieldType.isPrimitive()) {
            return false;
        }
        if (fieldType.isArray()) {
            return false;
        }
        return (fieldType.getModifiers() & 0x10) == 0;
    }
}

