/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged;

import com.insidious.common.weaver.ClassInfo;
import io.unlogged.AgentCommandExecutorImpl;
import io.unlogged.Constants;
import io.unlogged.Pair;
import io.unlogged.Unlogged;
import io.unlogged.command.AgentCommandServer;
import io.unlogged.command.ServerMetadata;
import io.unlogged.logging.IErrorLogger;
import io.unlogged.logging.IEventLogger;
import io.unlogged.logging.Logging;
import io.unlogged.logging.ObjectMapperFactory;
import io.unlogged.logging.SimpleFileLogger;
import io.unlogged.logging.impl.DetailedEventStreamAggregatedLogger;
import io.unlogged.logging.perthread.PerThreadBinaryFileAggregatedLogger;
import io.unlogged.logging.perthread.RawFileCollector;
import io.unlogged.logging.util.FileNameGenerator;
import io.unlogged.logging.util.NetworkClient;
import io.unlogged.util.ByteTools;
import io.unlogged.util.StreamUtil;
import io.unlogged.weaver.WeaveConfig;
import io.unlogged.weaver.WeaveParameters;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class Runtime {
    private static Runtime instance;
    private static List<Pair<String, String>> pendingClassRegistrations;
    private final ScheduledExecutorService probeReaderExecutor = Executors.newSingleThreadScheduledExecutor();
    private AgentCommandServer httpServer;
    private IErrorLogger errorLogger;
    private IEventLogger logger = Logging.initialiseDiscardLogger();
    private long lastProbesLoadTime;

    private Runtime(String args) {
        if ("true".equals(System.getProperty("UNLOGGED_DISABLE", "false"))) {
            this.logger = Logging.initialiseDiscardLogger();
            return;
        }
        if (System.getProperty("UNLOGGED_ARGS") != null) {
            args = System.getProperty("UNLOGGED_ARGS");
        }
        if (System.getenv("UNLOGGED_ARGS") != null) {
            args = System.getenv("UNLOGGED_ARGS");
        }
        try {
            File outputDir;
            WeaveParameters weaveParameters = new WeaveParameters(args);
            String agentServerPort1 = weaveParameters.getAgentServerPort();
            if (agentServerPort1 == null || agentServerPort1.equalsIgnoreCase("null")) {
                agentServerPort1 = "0";
            }
            int agentServerPort = Integer.parseInt(agentServerPort1);
            String portFromEnv = System.getenv().get("UNLOGGED_AGENT_PORT");
            if (portFromEnv != null) {
                try {
                    agentServerPort = Integer.parseInt(portFromEnv);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!(outputDir = new File(weaveParameters.getOutputDirname())).exists()) {
                outputDir.mkdirs();
            }
            if (!outputDir.isDirectory() || !outputDir.canWrite()) {
                System.err.println("[unlogged] ERROR: " + outputDir.getAbsolutePath() + " is not writable.");
                return;
            }
            WeaveConfig config = new WeaveConfig(weaveParameters);
            if (!config.isValid()) {
                System.out.println("[unlogged] no weaving option is specified.");
                return;
            }
            this.errorLogger = new SimpleFileLogger(outputDir);
            String hostname = NetworkClient.getHostname();
            ServerMetadata serverMetadata = new ServerMetadata(weaveParameters.getIncludedNames().toString(), Constants.AGENT_VERSION, hostname, 0, weaveParameters.getServerAddress() == null || weaveParameters.getServerAddress().isEmpty() ? "local" : "remote");
            this.httpServer = new AgentCommandServer(agentServerPort, serverMetadata);
            StringBuilder firstLogLine = new StringBuilder();
            firstLogLine.append("Java version: " + System.getProperty("java.version") + "\n");
            firstLogLine.append("Agent version: " + Constants.AGENT_VERSION + "\n");
            firstLogLine.append("Params: " + args + "\n");
            this.httpServer.start(5000, false);
            serverMetadata.setAgentServerUrl("http://localhost:" + this.httpServer.getListeningPort());
            serverMetadata.setAgentServerPort(this.httpServer.getListeningPort());
            firstLogLine.append(serverMetadata + "\n");
            this.errorLogger.log(firstLogLine.toString());
            System.out.println("[unlogged] session Id: [" + config.getSessionId() + "] " + serverMetadata);
            switch (weaveParameters.getMode().ordinal()) {
                case 3: {
                    this.logger = Logging.initialiseDiscardLogger();
                    break;
                }
                case 5: {
                    NetworkClient networkClient = new NetworkClient(weaveParameters.getServerAddress(), config.getSessionId(), weaveParameters.getAuthToken(), this.errorLogger);
                    FileNameGenerator fileNameGenerator1 = new FileNameGenerator(outputDir, "index-", ".zip");
                    RawFileCollector fileCollector = new RawFileCollector(weaveParameters.getFilesPerIndex(), fileNameGenerator1, networkClient, this.errorLogger, outputDir);
                    FileNameGenerator fileNameGenerator = new FileNameGenerator(outputDir, "log-", ".selog");
                    PerThreadBinaryFileAggregatedLogger perThreadBinaryFileAggregatedLogger = new PerThreadBinaryFileAggregatedLogger(fileNameGenerator, this.errorLogger, fileCollector);
                    this.logger = Logging.initialiseAggregatedLogger(perThreadBinaryFileAggregatedLogger, outputDir);
                    break;
                }
                case 6: {
                    NetworkClient networkClient1 = new NetworkClient(weaveParameters.getServerAddress(), config.getSessionId(), weaveParameters.getAuthToken(), this.errorLogger);
                    FileNameGenerator archiveFileNameGenerator = new FileNameGenerator(outputDir, "index-", ".zip");
                    RawFileCollector fileCollector1 = new RawFileCollector(weaveParameters.getFilesPerIndex(), archiveFileNameGenerator, networkClient1, this.errorLogger, outputDir);
                    FileNameGenerator logFileNameGenerator = new FileNameGenerator(outputDir, "log-", ".selog");
                    PerThreadBinaryFileAggregatedLogger perThreadBinaryFileAggregatedLogger1 = new PerThreadBinaryFileAggregatedLogger(logFileNameGenerator, this.errorLogger, fileCollector1);
                    this.logger = Logging.initialiseDetailedAggregatedLogger(perThreadBinaryFileAggregatedLogger1, outputDir);
                    DetailedEventStreamAggregatedLogger detailedEventStreamAggregatedLogger = (DetailedEventStreamAggregatedLogger)this.logger;
                }
            }
            this.httpServer.setAgentCommandExecutor(new AgentCommandExecutorImpl(ObjectMapperFactory.createObjectMapperReactive(), this.logger));
            java.lang.Runtime.getRuntime().addShutdownHook(new Thread(this::close));
        }
        catch (Throwable thx) {
            this.logger = Logging.initialiseDiscardLogger();
            thx.printStackTrace();
            System.err.println("[unlogged] agent init failed, this session will not be recorded => " + thx.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Runtime getInstance(String args) {
        if (instance != null) {
            return instance;
        }
        Class<Runtime> clazz = Runtime.class;
        synchronized (Runtime.class) {
            if (instance != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return instance;
            }
            try {
                StackTraceElement callerClassAndMethodStack = new Exception().getStackTrace()[1];
                Class<?> callerClass = Class.forName(callerClassAndMethodStack.getClassName());
                for (Method method : callerClass.getMethods()) {
                    if (method.getAnnotation(Unlogged.class) == null) continue;
                    Unlogged annotationData = method.getAnnotation(Unlogged.class);
                    if (!annotationData.enable()) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return null;
                    }
                    break;
                }
            }
            catch (ClassNotFoundException e) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            instance = new Runtime(args);
            for (Pair<String, String> pendingClassRegistration : pendingClassRegistrations) {
                Runtime.registerClass(pendingClassRegistration.getFirst(), pendingClassRegistration.getSecond());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public static void registerClass(String classInfoBytes, String probesToRecordBase64) {
        StackTraceElement callerClassAndMethodStack = new Exception().getStackTrace()[1];
        try {
            Class<?> callerClass = Class.forName(callerClassAndMethodStack.getClassName());
            String args = "";
            for (Method method : callerClass.getMethods()) {
                if (!method.isAnnotationPresent(Unlogged.class)) continue;
                Unlogged annotationData = method.getAnnotation(Unlogged.class);
                if (annotationData.enable()) {
                    String includedPackageName = annotationData.includePackage()[0];
                    if ((includedPackageName == null || includedPackageName.isEmpty()) && (includedPackageName = callerClassAndMethodStack.getClassName()).contains(".")) {
                        includedPackageName = includedPackageName.substring(0, includedPackageName.lastIndexOf("."));
                    }
                    args = "i=" + includedPackageName + (annotationData.serverEndpoint() == null ? "" : ",server=" + annotationData.serverEndpoint()) + ",agentserverport=" + annotationData.port();
                    break;
                }
                args = "format=discard";
                break;
            }
            if (args.isEmpty()) {
                args = "i=" + callerClass.getPackage().getName();
            }
            Runtime.getInstance(args);
        }
        catch (ClassNotFoundException callerClass) {
            // empty catch block
        }
        if (instance != null) {
            byte[] decodedClassWeaveInfo = new byte[]{};
            List<Integer> probesToRecord = null;
            try {
                decodedClassWeaveInfo = ByteTools.decompressBase64String(classInfoBytes);
                byte[] decodedProbesToRecord = ByteTools.decompressBase64String(probesToRecordBase64);
                probesToRecord = Runtime.bytesToIntList(decodedProbesToRecord);
            }
            catch (IOException e) {
                System.out.println("Registration for class failed: " + e.getMessage());
                return;
            }
            ClassInfo classInfo = new ClassInfo();
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(decodedClassWeaveInfo);
                classInfo.readFromDataStream(in);
            }
            catch (IOException e) {
                return;
            }
            Runtime.instance.logger.recordWeaveInfo(decodedClassWeaveInfo, classInfo, probesToRecord);
        } else {
            pendingClassRegistrations.add(new Pair<String, String>(classInfoBytes, probesToRecordBase64));
        }
    }

    public static List<Integer> bytesToIntList(byte[] probeToRecordBytes) throws IOException {
        ArrayList<Integer> probesToRecord = new ArrayList<Integer>();
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(probeToRecordBytes));
        try {
            while (true) {
                int probeId = dis.readInt();
                probesToRecord.add(probeId);
            }
        }
        catch (EOFException eOFException) {
            return probesToRecord;
        }
    }

    private List<Integer> probeFileToIdList(File file) throws IOException {
        InputStream probesFile = this.getClass().getClassLoader().getResourceAsStream(file.getName());
        return this.probeFileStreamToIdList(probesFile);
    }

    private List<Integer> probeFileStreamToIdList(InputStream probesFile) throws IOException {
        if (probesFile == null) {
            return new ArrayList<Integer>();
        }
        byte[] probeToRecordBytes = StreamUtil.streamToBytes(probesFile);
        return Runtime.bytesToIntList(probeToRecordBytes);
    }

    private static boolean frequencyLogging(long methodCounter, long divisor) {
        return (methodCounter - 1L) % divisor == 0L;
    }

    public static boolean probeCounter(long methodCounter, long divisor, Object ... arguments) {
        System.out.println("--------");
        for (Object localArgument : arguments) {
            System.out.println(localArgument);
        }
        System.out.println("--------");
        return Runtime.frequencyLogging(methodCounter, divisor);
    }

    public static boolean probeCounter(long methodCounter, long divisor) {
        return Runtime.frequencyLogging(methodCounter, divisor);
    }

    public void close() {
        if (this.logger != null) {
            this.logger.close();
        }
        if (this.httpServer != null) {
            this.httpServer.stop();
        }
        if (this.errorLogger != null) {
            this.errorLogger.close();
        }
        System.out.println("[unlogged] shutdown complete");
    }

    static {
        pendingClassRegistrations = new ArrayList<Pair<String, String>>();
    }

    public static enum Mode {
        STREAM,
        FREQUENCY,
        FIXED_SIZE,
        DISCARD,
        NETWORK,
        PER_THREAD,
        TESTING;

    }
}

