/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.atomic;

import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import selogger.com.fasterxml.jackson.databind.JsonNode;
import selogger.com.fasterxml.jackson.databind.node.ArrayNode;
import selogger.com.fasterxml.jackson.databind.node.TextNode;
import selogger.org.slf4j.Logger;
import selogger.org.slf4j.LoggerFactory;

public enum AssertionType {
    ALLOF,
    ANYOF,
    NOTALLOF,
    NOTANYOF,
    EQUAL,
    EQUAL_IGNORE_CASE,
    NOT_EQUAL,
    FALSE,
    MATCHES_REGEX,
    NOT_MATCHES_REGEX,
    TRUE,
    LESS_THAN,
    LESS_THAN_OR_EQUAL,
    GREATER_THAN,
    GREATER_THAN_OR_EQUAL,
    NOT_NULL,
    NULL,
    EMPTY,
    NOT_EMPTY,
    CONTAINS_KEY,
    CONTAINS_ITEM,
    NOT_CONTAINS_ITEM,
    CONTAINS_STRING,
    NOT_CONTAINS_KEY,
    STARTS_WITH,
    ENDS_WITH,
    NOT_STARTS_WITH,
    NOT_ENDS_WITH,
    NOT_CONTAINS_STRING;

    private static final Logger logger;

    public static boolean arrayNodeContains(ArrayNode arrayNode, JsonNode node) {
        Stream<JsonNode> nodeStream = StreamSupport.stream(arrayNode.spliterator(), false);
        return nodeStream.anyMatch(j -> j.equals(node));
    }

    public String toString() {
        switch (this.ordinal()) {
            case 1: {
                return "any of";
            }
            case 0: {
                return "all of";
            }
            case 2: {
                return "not all of";
            }
            case 3: {
                return "not any of";
            }
            case 4: {
                return "equals";
            }
            case 5: {
                return "equals case insensitive";
            }
            case 6: {
                return "not equals";
            }
            case 7: {
                return "false";
            }
            case 10: {
                return "true";
            }
            case 11: {
                return "less than";
            }
            case 12: {
                return "less than or equal";
            }
            case 13: {
                return "greater than";
            }
            case 14: {
                return "greater than or equal";
            }
            case 8: {
                return "matches regex";
            }
            case 9: {
                return "not matches regex";
            }
            case 15: {
                return "is not null";
            }
            case 16: {
                return "is null";
            }
            case 17: {
                return "is empty array";
            }
            case 18: {
                return "is not empty array";
            }
            case 19: {
                return "object has field";
            }
            case 20: {
                return "array has item";
            }
            case 21: {
                return "array does not have item";
            }
            case 22: {
                return "has substring";
            }
            case 23: {
                return "object does not have field";
            }
            case 28: {
                return "not has substring";
            }
            case 24: {
                return "starts with";
            }
            case 26: {
                return "not starts with";
            }
            case 25: {
                return "ends with";
            }
            case 27: {
                return "not ends with";
            }
        }
        return "unknown-assertion-type";
    }

    public boolean verify(JsonNode actualValue, JsonNode expectedValue) {
        try {
            String expectedValueString = expectedValue instanceof TextNode ? expectedValue.textValue() : expectedValue.toString();
            String actualValueString = actualValue instanceof TextNode ? actualValue.textValue() : actualValue.toString();
            switch (this.ordinal()) {
                case 4: {
                    if (actualValue.isBoolean()) {
                        if (actualValue.booleanValue()) {
                            if (expectedValueString.equals("1") || expectedValueString.equals("true")) {
                                return true;
                            }
                            if (expectedValueString.equals("0") || expectedValueString.equals("false")) {
                                return false;
                            }
                        } else {
                            if (expectedValueString.equals("1") || expectedValueString.equals("true")) {
                                return false;
                            }
                            if (expectedValueString.equals("0") || expectedValueString.equals("false")) {
                                return true;
                            }
                        }
                    }
                    if (expectedValue.isBoolean()) {
                        if (expectedValue.booleanValue()) {
                            if (actualValueString.equals("1") || actualValueString.equals("true")) {
                                return true;
                            }
                            if (actualValueString.equals("0") || actualValueString.equals("false")) {
                                return false;
                            }
                        } else {
                            if (actualValueString.equals("1") || actualValueString.equals("true")) {
                                return false;
                            }
                            if (actualValueString.equals("0") || actualValueString.equals("false")) {
                                return true;
                            }
                        }
                    }
                    if (actualValue instanceof TextNode || expectedValue instanceof TextNode) {
                        return Objects.equals(actualValueString, expectedValueString);
                    }
                    return Objects.equals(actualValue, expectedValue);
                }
                case 5: {
                    return Objects.equals(actualValueString.toLowerCase(), expectedValueString.toLowerCase());
                }
                case 6: {
                    if (actualValue.isBoolean()) {
                        if (actualValue.booleanValue()) {
                            if (expectedValueString.equals("1") || expectedValueString.equals("true")) {
                                return false;
                            }
                            if (expectedValueString.equals("0") || expectedValueString.equals("false")) {
                                return true;
                            }
                        } else {
                            if (expectedValueString.equals("1") || expectedValueString.equals("true")) {
                                return true;
                            }
                            if (expectedValueString.equals("0") || expectedValueString.equals("false")) {
                                return false;
                            }
                        }
                    }
                    if (expectedValue.isBoolean()) {
                        if (expectedValue.booleanValue()) {
                            if (actualValueString.equals("1") || actualValueString.equals("true")) {
                                return false;
                            }
                            if (actualValueString.equals("0") || actualValueString.equals("false")) {
                                return true;
                            }
                        } else {
                            if (actualValueString.equals("1") || actualValueString.equals("true")) {
                                return true;
                            }
                            if (actualValueString.equals("0") || actualValueString.equals("false")) {
                                return false;
                            }
                        }
                    }
                    if (actualValue instanceof TextNode || expectedValue instanceof TextNode) {
                        return !Objects.equals(actualValueString, expectedValueString);
                    }
                    return !Objects.equals(actualValue, expectedValue);
                }
                case 7: {
                    return Objects.equals(actualValue.asBoolean(), false);
                }
                case 10: {
                    return Objects.equals(actualValue.asBoolean(), true);
                }
                case 11: {
                    return actualValue.asDouble() < expectedValue.asDouble();
                }
                case 13: {
                    return actualValue.asDouble() > expectedValue.asDouble();
                }
                case 12: {
                    return actualValue.asDouble() <= expectedValue.asDouble();
                }
                case 14: {
                    return actualValue.asDouble() >= expectedValue.asDouble();
                }
                case 16: {
                    return actualValue.isNull();
                }
                case 17: {
                    return actualValue.isEmpty();
                }
                case 18: {
                    return !actualValue.isEmpty();
                }
                case 15: {
                    return !actualValue.isNull();
                }
                case 8: {
                    return Pattern.compile(expectedValueString).matcher(actualValueString).matches();
                }
                case 9: {
                    return !Pattern.compile(expectedValueString).matcher(actualValueString).matches();
                }
                case 19: {
                    return actualValue.has(expectedValueString);
                }
                case 23: {
                    return !actualValue.has(expectedValueString);
                }
                case 20: {
                    return AssertionType.arrayNodeContains((ArrayNode)actualValue, expectedValue);
                }
                case 21: {
                    return !AssertionType.arrayNodeContains((ArrayNode)actualValue, expectedValue);
                }
                case 22: {
                    return actualValueString.contains(expectedValueString);
                }
                case 28: {
                    return !actualValueString.contains(expectedValueString);
                }
                case 25: {
                    return actualValueString.endsWith(expectedValueString);
                }
                case 27: {
                    return !actualValueString.endsWith(expectedValueString);
                }
                case 24: {
                    return actualValueString.startsWith(expectedValueString);
                }
                case 26: {
                    return !actualValueString.startsWith(expectedValueString);
                }
            }
            return false;
        }
        catch (Exception e) {
            logger.warn("Assertion exception: ", e);
            return false;
        }
    }

    static {
        logger = LoggerFactory.getLogger(AssertionType.class);
    }
}

