/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.command;

import fi.iki.elonen.NanoHTTPD;
import io.unlogged.Runtime;
import io.unlogged.command.AgentCommandErrorResponse;
import io.unlogged.command.AgentCommandExecutor;
import io.unlogged.command.AgentCommandRequest;
import io.unlogged.command.AgentCommandResponse;
import io.unlogged.command.ResponseType;
import io.unlogged.command.ServerMetadata;
import io.unlogged.logging.ObjectMapperFactory;
import java.io.IOException;
import java.util.HashMap;
import selogger.com.fasterxml.jackson.core.JsonProcessingException;
import selogger.com.fasterxml.jackson.databind.ObjectMapper;

public class AgentCommandServer
extends NanoHTTPD {
    private final ServerMetadata serverMetadata;
    ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapperReactive();
    private AgentCommandExecutor agentCommandExecutor;
    private String pingResponseBody;

    public AgentCommandServer(int port, ServerMetadata serverMetadata) {
        super(port);
        this.serverMetadata = serverMetadata;
        this.init();
    }

    public AgentCommandServer(String hostname, int port, ServerMetadata serverMetadata) {
        super(hostname, port);
        this.serverMetadata = serverMetadata;
        this.init();
    }

    public void init() {
        AgentCommandResponse pingResponse = new AgentCommandResponse();
        pingResponse.setMessage("ok");
        pingResponse.setResponseType(ResponseType.NORMAL);
        try {
            pingResponse.setMethodReturnValue(this.serverMetadata);
            this.pingResponseBody = this.objectMapper.writeValueAsString(pingResponse);
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    @Override
    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        String requestBodyText = null;
        HashMap<String, String> bodyParams = new HashMap<String, String>();
        try {
            session.parseBody(bodyParams);
        }
        catch (NanoHTTPD.ResponseException | IOException e) {
            return AgentCommandServer.newFixedLengthResponse("{\"message\": \"" + e.getMessage() + "\", }");
        }
        requestBodyText = (String)bodyParams.get("postData");
        String postBody = session.getQueryParameterString();
        String requestPath = session.getUri();
        NanoHTTPD.Method requestMethod = session.getMethod();
        if (requestPath.equals("/ping")) {
            return AgentCommandServer.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, "application/json", this.pingResponseBody);
        }
        if (requestPath.equals("/index.html")) {
            return AgentCommandServer.newChunkedResponse(NanoHTTPD.Response.Status.OK, "application/json", this.getClass().getClassLoader().getResourceAsStream("index.html"));
        }
        try {
            AgentCommandResponse commandResponse;
            AgentCommandRequest agentCommandRequest = this.objectMapper.readValue(postBody != null ? postBody : requestBodyText, AgentCommandRequest.class);
            switch (agentCommandRequest.getCommand()) {
                case EXECUTE: {
                    commandResponse = this.agentCommandExecutor.executeCommand(agentCommandRequest);
                    break;
                }
                case INJECT_MOCKS: {
                    commandResponse = this.agentCommandExecutor.injectMocks(agentCommandRequest);
                    break;
                }
                case REGISTER_CLASS: {
                    String classWeaveInfoData = agentCommandRequest.getMethodParameters().get(0);
                    String probesToRecord = agentCommandRequest.getMethodParameters().get(1);
                    Runtime.registerClass(classWeaveInfoData, probesToRecord);
                    commandResponse = new AgentCommandResponse();
                    commandResponse.setResponseType(ResponseType.NORMAL);
                    break;
                }
                case REMOVE_MOCKS: {
                    commandResponse = this.agentCommandExecutor.removeMocks(agentCommandRequest);
                    break;
                }
                default: {
                    System.err.println("Unknown request [" + (Object)((Object)requestMethod) + "] " + requestPath + " - " + agentCommandRequest);
                    commandResponse = new AgentCommandResponse();
                    commandResponse.setMessage("unknown command: " + (Object)((Object)agentCommandRequest.getCommand()));
                    commandResponse.setResponseType(ResponseType.FAILED);
                }
            }
            String responseBody = this.objectMapper.writeValueAsString(commandResponse);
            return AgentCommandServer.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, "application/json", responseBody);
        }
        catch (Throwable e) {
            e.printStackTrace();
            AgentCommandErrorResponse agentCommandErrorResponse = new AgentCommandErrorResponse(e.getMessage());
            if (e instanceof NoSuchMethodException) {
                agentCommandErrorResponse.setResponseType(ResponseType.FAILED);
            } else {
                agentCommandErrorResponse.setResponseType(ResponseType.EXCEPTION);
            }
            String errorResponseBody = null;
            try {
                errorResponseBody = this.objectMapper.writeValueAsString(agentCommandErrorResponse);
            }
            catch (JsonProcessingException ex) {
                return AgentCommandServer.newFixedLengthResponse("{\"message\": \"" + ex.getMessage() + "\"}");
            }
            return AgentCommandServer.newFixedLengthResponse(errorResponseBody);
        }
    }

    public void setAgentCommandExecutor(AgentCommandExecutor agentCommandExecutor) {
        this.agentCommandExecutor = agentCommandExecutor;
    }
}

