/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.logging.impl;

import com.googlecode.concurrenttrees.radix.node.concrete.DefaultCharArrayNodeFactory;
import com.googlecode.concurrenttrees.radixinverted.ConcurrentInvertedRadixTree;
import com.googlecode.concurrenttrees.radixinverted.InvertedRadixTree;
import com.insidious.common.weaver.ClassInfo;
import io.unlogged.logging.IEventLogger;
import io.unlogged.logging.ObjectMapperFactory;
import io.unlogged.logging.SerializationMode;
import io.unlogged.logging.util.AggregatedFileLogger;
import io.unlogged.logging.util.ObjectIdAggregatedStream;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import selogger.com.fasterxml.jackson.core.JsonProcessingException;
import selogger.com.fasterxml.jackson.databind.JsonMappingException;
import selogger.com.fasterxml.jackson.databind.ObjectMapper;

public class DetailedEventStreamAggregatedLogger
implements IEventLogger {
    public static final String FAILED_TO_RECORD_MESSAGE = "{\"error\": \"failed to serialize object\", \"message\":\"";
    private static boolean isReactive = false;
    private final AggregatedFileLogger aggregatedLogger;
    private final ObjectIdAggregatedStream objectIdMap;
    private final Boolean DEBUG = Boolean.parseBoolean(System.getProperty("UNLOGGED_DEBUG"));
    private final ThreadLocal<Boolean> isRecording = ThreadLocal.withInitial(() -> false);
    private final boolean serializeValues = true;
    private final Set<Integer> probesToRecord = new HashSet<Integer>();
    private final Set<Long> valueToSkip = new HashSet<Long>();
    private final SerializationMode SERIALIZATION_MODE = SerializationMode.JACKSON;
    private final Map<String, WeakReference<Object>> objectMap = new HashMap<String, WeakReference<Object>>();
    private final ThreadLocal<ObjectMapper> objectMapper = ThreadLocal.withInitial(ObjectMapperFactory::createObjectMapperReactive);
    private final ByteBuffer buffer = ByteBuffer.allocate(8);
    private final Map<Integer, Integer> firstProbeId = new HashMap<Integer, Integer>();
    InvertedRadixTree<Boolean> invertedRadixTree = new ConcurrentInvertedRadixTree<Boolean>(new DefaultCharArrayNodeFactory());
    private ClassLoader targetClassLoader;

    public DetailedEventStreamAggregatedLogger(ObjectIdAggregatedStream objectIdMap, AggregatedFileLogger aggregatedLogger) {
        this.aggregatedLogger = aggregatedLogger;
        this.objectIdMap = objectIdMap;
        try {
            Class.forName("reactor.core.publisher.Mono");
            isReactive = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initSkipPackages();
    }

    private void initSkipPackages() {
        this.invertedRadixTree.put("com.google", true);
        this.invertedRadixTree.put("java.util.stream", true);
        this.invertedRadixTree.put("org.pf4j", true);
        this.invertedRadixTree.put("org.elasticsearch.client", true);
        this.invertedRadixTree.put("org.apache", true);
        this.invertedRadixTree.put("io.lettuce", true);
        this.invertedRadixTree.put("com.querydsl", true);
        this.invertedRadixTree.put("org.hibernate", true);
        this.invertedRadixTree.put("org.jgrapht", true);
        this.invertedRadixTree.put("ch.qos", true);
        this.invertedRadixTree.put("io.dropwizard", true);
        this.invertedRadixTree.put("org.redis", true);
        this.invertedRadixTree.put("redis", true);
        this.invertedRadixTree.put("co.elastic", true);
        this.invertedRadixTree.put("io.unlogged", true);
        this.invertedRadixTree.put("com.insidious", true);
        this.invertedRadixTree.put("java.awt", true);
        this.invertedRadixTree.put("sun.nio", true);
        this.invertedRadixTree.put("javax.swing", true);
        this.invertedRadixTree.put("com.j256", true);
        this.invertedRadixTree.put("net.openhft", true);
        this.invertedRadixTree.put("com.intellij", true);
        this.invertedRadixTree.put("java.lang.Class", true);
        this.invertedRadixTree.put("reactor.util", true);
        this.invertedRadixTree.put("io.undertow", true);
        this.invertedRadixTree.put("org.thymeleaf", true);
        this.invertedRadixTree.put("tech.jhipster", true);
        this.invertedRadixTree.put("com.github", true);
        this.invertedRadixTree.put("com.zaxxer", true);
        this.invertedRadixTree.put("com.fasterxml", true);
        this.invertedRadixTree.put("selogger.org.slf4j", true);
        this.invertedRadixTree.put("java.io", true);
        this.invertedRadixTree.put("java.util.regex", true);
        this.invertedRadixTree.put("java.util.Base64", true);
        this.invertedRadixTree.put("com.amazon", true);
        this.invertedRadixTree.put("com.hubspot", true);
    }

    @Override
    public void close() {
        this.objectIdMap.close();
        try {
            this.aggregatedLogger.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object getObjectByClassName(String className) {
        if (!this.objectMap.containsKey(className)) {
            return null;
        }
        WeakReference<Object> objectWeakReference = this.objectMap.get(className);
        Object objectInstance = objectWeakReference.get();
        if (objectInstance == null) {
            this.objectMap.remove(className);
            return null;
        }
        if (this.targetClassLoader == null) {
            this.targetClassLoader = objectInstance.getClass().getClassLoader();
        }
        return objectInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object recordEvent(int dataId, Object value) {
        String className;
        Class valueClass;
        if (this.isRecording.get().booleanValue()) {
            return value;
        }
        Class clazz = valueClass = value == null ? Object.class : value.getClass();
        if (value != null) {
            className = valueClass.getCanonicalName();
            if (className == null) {
                className = valueClass.getName();
            }
        } else {
            className = "";
        }
        if (!className.contains("Lambda") && !className.contains("$Unlogged")) {
            String originalClassName = className;
            if (className.contains("_$")) {
                className = className.substring(0, className.indexOf("_$"));
            } else if (className.contains("$")) {
                className = className.substring(0, className.indexOf(36));
            }
            if (!this.objectMap.containsKey(className)) {
                this.objectMap.put(className, new WeakReference<Object>(value));
            } else if (originalClassName.contains("$EnhancerBySpringCGLIB")) {
                this.objectMap.put(className, new WeakReference<Object>(value));
            } else if (originalClassName.contains("$SpringCGLIB")) {
                this.objectMap.put(className, new WeakReference<Object>(value));
            }
            if (this.targetClassLoader == null && value != null) {
                this.targetClassLoader = valueClass.getClassLoader();
            }
        }
        long objectId = this.objectIdMap.getId(value);
        if (this.probesToRecord.size() > 0 && this.probesToRecord.contains(dataId) && !this.valueToSkip.contains(objectId)) {
            if (this.DEBUG.booleanValue() && value != null) {
                System.out.println("record serialized value for probe [" + dataId + "] -> " + valueClass);
            }
            byte[] bytes = new byte[]{};
            try {
                this.isRecording.set(true);
                if (value instanceof Class) {
                    bytes = ((Class)value).getCanonicalName().getBytes(StandardCharsets.UTF_8);
                } else if (this.invertedRadixTree.getKeysPrefixing(className).iterator().hasNext() || className.contains("java.lang.reflect") || className.contains("reactor.core.scheduler") || className.contains("com.mongodb") || className.startsWith("org.glassfish") && !className.equals("org.glassfish.jersey.message.internal.OutboundJaxrsResponse") || className.startsWith("org.springframework") && !className.startsWith("org.springframework.http") && !className.startsWith("org.springframework.data.domain") || value instanceof Iterator || value instanceof Stream) {
                    this.probesToRecord.remove(dataId);
                } else if (this.SERIALIZATION_MODE == SerializationMode.JACKSON) {
                    if (isReactive && value instanceof Mono) {
                        long newValueId = System.nanoTime();
                        Mono value1 = (Mono)value;
                        this.buffer.clear();
                        this.buffer.putLong(newValueId);
                        this.aggregatedLogger.writeEvent(dataId, objectId, this.buffer.array());
                        Integer firstProbeIdFinal = this.firstProbeId.get(dataId);
                        Mono mono = value1.doOnError(result -> {
                            try {
                                byte[] bytesAllocatedNew = this.objectMapper.get().writeValueAsBytes(result);
                                this.aggregatedLogger.writeEvent((int)firstProbeIdFinal, newValueId, bytesAllocatedNew);
                            }
                            catch (JsonProcessingException e) {
                                byte[] bytesAllocatedNew = result.toString().getBytes(StandardCharsets.UTF_8);
                                this.aggregatedLogger.writeEvent((int)firstProbeIdFinal, newValueId, bytesAllocatedNew);
                            }
                        }).doOnNext(result -> {
                            try {
                                byte[] bytesAllocatedNew = this.objectMapper.get().writeValueAsBytes(result);
                                this.aggregatedLogger.writeEvent((int)firstProbeIdFinal, newValueId, bytesAllocatedNew);
                            }
                            catch (JsonProcessingException e) {
                                byte[] bytesAllocatedNew = result.toString().getBytes(StandardCharsets.UTF_8);
                                this.aggregatedLogger.writeEvent((int)firstProbeIdFinal, newValueId, bytesAllocatedNew);
                            }
                        });
                        return mono;
                    }
                    if (isReactive && value instanceof Flux) {
                        long newValueId = System.nanoTime();
                        Flux fluxValue = (Flux)value;
                        this.buffer.clear();
                        this.buffer.putLong(newValueId);
                        this.aggregatedLogger.writeEvent(dataId, objectId, this.buffer.array());
                        Integer firstProbeIdFinal = this.firstProbeId.get(dataId);
                        Flux flux = fluxValue.doOnError(result -> {
                            try {
                                byte[] bytesAllocatedNew = this.objectMapper.get().writeValueAsBytes(result);
                                this.aggregatedLogger.writeEvent((int)firstProbeIdFinal, newValueId, bytesAllocatedNew);
                            }
                            catch (JsonProcessingException e) {
                                byte[] bytesAllocatedNew = result.toString().getBytes(StandardCharsets.UTF_8);
                                this.aggregatedLogger.writeEvent((int)firstProbeIdFinal, newValueId, bytesAllocatedNew);
                            }
                        }).doOnNext(result -> {
                            try {
                                byte[] bytesAllocatedNew = this.objectMapper.get().writeValueAsBytes(result);
                                this.aggregatedLogger.writeEvent((int)firstProbeIdFinal, newValueId, bytesAllocatedNew);
                            }
                            catch (JsonProcessingException e) {
                                byte[] bytesAllocatedNew = result.toString().getBytes(StandardCharsets.UTF_8);
                                this.aggregatedLogger.writeEvent((int)firstProbeIdFinal, newValueId, bytesAllocatedNew);
                            }
                        });
                        return flux;
                    }
                    if (value instanceof Future) {
                        Future futureValue = (Future)value;
                        try {
                            Object value1 = futureValue.get(100L, TimeUnit.MILLISECONDS);
                            bytes = this.objectMapper.get().writeValueAsBytes(value1);
                        }
                        catch (TimeoutException te) {
                            bytes = this.objectMapper.get().writeValueAsBytes("{\"message\": \"failed to read future\"}");
                        }
                    } else {
                        bytes = value instanceof byte[] ? (byte[])value : this.objectMapper.get().writeValueAsBytes(value);
                    }
                    if (this.DEBUG.booleanValue()) {
                        System.err.println("[" + dataId + "] record serialized value for probe [" + valueClass + "] [" + objectId + "] -> " + new String(bytes));
                    }
                } else if (this.SERIALIZATION_MODE == SerializationMode.FST) {
                } else if (this.SERIALIZATION_MODE == SerializationMode.OOS) {
                } else if (this.SERIALIZATION_MODE == SerializationMode.KRYO) {
                    // empty if block
                }
            }
            catch (Throwable e) {
                if (e instanceof JsonMappingException) {
                    bytes = (FAILED_TO_RECORD_MESSAGE + e.getMessage() + "\"}").getBytes();
                }
                this.probesToRecord.remove(dataId);
                this.valueToSkip.add(objectId);
            }
            finally {
                this.isRecording.set(false);
            }
            this.aggregatedLogger.writeEvent(dataId, objectId, bytes);
        } else {
            this.aggregatedLogger.writeEvent(dataId, objectId);
        }
        return value;
    }

    @Override
    public void recordEvent(int dataId, int value) {
        if (this.isRecording.get().booleanValue()) {
            return;
        }
        this.aggregatedLogger.writeEvent(dataId, value);
    }

    @Override
    public void recordEvent(int dataId, long value) {
        if (this.isRecording.get().booleanValue()) {
            return;
        }
        this.aggregatedLogger.writeEvent(dataId, value);
    }

    @Override
    public void recordEvent(int dataId, byte value) {
        if (this.isRecording.get().booleanValue()) {
            return;
        }
        this.aggregatedLogger.writeEvent(dataId, value);
    }

    @Override
    public void recordEvent(int dataId, short value) {
        if (this.isRecording.get().booleanValue()) {
            return;
        }
        this.aggregatedLogger.writeEvent(dataId, value);
    }

    @Override
    public void recordEvent(int dataId, char value) {
        if (this.isRecording.get().booleanValue()) {
            return;
        }
        this.aggregatedLogger.writeEvent(dataId, value);
    }

    @Override
    public void recordEvent(int dataId, boolean value) {
        if (this.isRecording.get().booleanValue()) {
            return;
        }
        int longValue = value ? 1 : 0;
        this.aggregatedLogger.writeEvent(dataId, longValue);
    }

    @Override
    public void recordEvent(int dataId, double value) {
        if (this.isRecording.get().booleanValue()) {
            return;
        }
        long longValue = Double.doubleToRawLongBits(value);
        this.aggregatedLogger.writeEvent(dataId, longValue);
    }

    @Override
    public void recordEvent(int dataId, float value) {
        if (this.isRecording.get().booleanValue()) {
            return;
        }
        int longValue = Float.floatToRawIntBits(value);
        this.aggregatedLogger.writeEvent(dataId, longValue);
    }

    @Override
    public void recordWeaveInfo(byte[] byteArray, ClassInfo classIdEntry, List<Integer> probeIdsToRecord) {
        if (probeIdsToRecord.size() > 0) {
            Integer firstProbeIdThisBatch = probeIdsToRecord.get(0);
            for (Integer i2 : probeIdsToRecord) {
                this.firstProbeId.put(i2, firstProbeIdThisBatch);
            }
            this.probesToRecord.addAll(probeIdsToRecord);
        }
        this.aggregatedLogger.writeWeaveInfo(byteArray);
    }

    @Override
    public void setRecordingPaused(boolean b) {
        this.isRecording.set(b);
    }

    @Override
    public ClassLoader getTargetClassLoader() {
        return this.targetClassLoader;
    }

    @Override
    public void registerClass(Integer id, Class<?> type) {
    }
}

