/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.logging.perthread;

import com.insidious.common.UploadFile;
import io.unlogged.logging.IErrorLogger;
import io.unlogged.logging.perthread.FileEventCountThresholdChecker;
import io.unlogged.logging.perthread.RawFileCollector;
import io.unlogged.logging.perthread.ThreadEventCountProvider;
import io.unlogged.logging.util.AggregatedFileLogger;
import io.unlogged.logging.util.FileNameGenerator;
import io.unlogged.logging.util.NetworkClient;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.ClosedChannelException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class PerThreadBinaryFileAggregatedLogger
implements AggregatedFileLogger,
ThreadEventCountProvider {
    public static final int MAX_EVENTS_PER_FILE = 100000;
    public static final int WRITE_BYTE_BUFFER_SIZE = 163840;
    private static final AtomicInteger nextThreadId = new AtomicInteger(0);
    private final ThreadLocal<Integer> threadId = ThreadLocal.withInitial(nextThreadId::getAndIncrement);
    private final BlockingQueue<UploadFile> fileList;
    private final Map<Integer, OutputStream> threadFileMap = new ConcurrentHashMap<Integer, OutputStream>();
    private final Map<Integer, String> currentFileMap = new ConcurrentHashMap<Integer, String>();
    private final Map<Integer, Integer> count = new ConcurrentHashMap<Integer, Integer>();
    private final String hostname;
    private final FileNameGenerator fileNameGenerator;
    private final IErrorLogger errorLogger;
    private final ThreadLocal<byte[]> threadLocalByteBuffer = ThreadLocal.withInitial(() -> {
        byte[] bytes = new byte[33];
        bytes[0] = 4;
        bytes[29] = 0;
        return bytes;
    });
    private final AtomicLong eventId = new AtomicLong(0L);
    ScheduledExecutorService threadPoolExecutor5Seconds = Executors.newScheduledThreadPool(2);
    ExecutorService threadPoolExecutor = Executors.newFixedThreadPool(4);
    private long currentTimestamp = System.currentTimeMillis();
    private RawFileCollector fileCollector = null;
    private FileEventCountThresholdChecker logFileTimeAgeChecker = null;
    private boolean skipUploads = false;
    private ScheduledFuture<?> skipResetFuture;
    private boolean shutdown;
    private DataOutputStream fileIndex;
    private int offloadTaskQueueReadIndex;
    private ThreadLocal<ByteArrayOutputStream> baos = ThreadLocal.withInitial(ByteArrayOutputStream::new);

    public PerThreadBinaryFileAggregatedLogger(FileNameGenerator fileNameGenerator, IErrorLogger logger, RawFileCollector fileCollector) {
        this.hostname = NetworkClient.getHostname();
        this.errorLogger = logger;
        this.fileNameGenerator = fileNameGenerator;
        this.fileCollector = fileCollector;
        this.fileList = fileCollector.getFileQueue();
        this.threadPoolExecutor.submit(fileCollector);
        this.logFileTimeAgeChecker = new FileEventCountThresholdChecker(this.threadFileMap, this, theThreadId -> {
            try {
                this.currentTimestamp = System.currentTimeMillis();
                this.prepareNextFile((int)theThreadId);
            }
            catch (IOException e) {
                this.errorLogger.log(e);
            }
            return null;
        }, this.errorLogger);
        this.threadPoolExecutor5Seconds.scheduleAtFixedRate(this.logFileTimeAgeChecker, 0L, 731L, TimeUnit.MILLISECONDS);
    }

    private OutputStream getStreamForThread(int threadId) {
        if (this.threadFileMap.containsKey(threadId)) {
            return this.threadFileMap.get(threadId);
        }
        try {
            this.prepareNextFile(threadId);
        }
        catch (IOException e) {
            this.errorLogger.log(e);
        }
        return this.threadFileMap.get(threadId);
    }

    private synchronized void prepareNextFile(int currentThreadId) throws IOException {
        int eventCount;
        if (this.count.containsKey(currentThreadId) && this.threadFileMap.get(currentThreadId) != null && (eventCount = this.count.get(currentThreadId).intValue()) < 1) {
            return;
        }
        String currentFile = this.currentFileMap.get(currentThreadId);
        OutputStream currentOutputStream = this.threadFileMap.get(currentThreadId);
        File nextFile = this.fileNameGenerator.getNextFile(String.valueOf(currentThreadId));
        this.currentFileMap.put(currentThreadId, nextFile.getPath());
        BufferedOutputStream outNew = new BufferedOutputStream(Files.newOutputStream(nextFile.toPath(), new OpenOption[0]), 163840);
        this.threadFileMap.put(currentThreadId, outNew);
        if (currentOutputStream != null) {
            try {
                currentOutputStream.close();
            }
            catch (ClosedChannelException cce) {
                this.errorLogger.log("[unlogged] channel already closed - flush existing file for thread [" + currentThreadId + "] -> " + currentFile);
            }
            UploadFile newLogFile = new UploadFile(currentFile, currentThreadId, null, null);
            this.fileList.offer(newLogFile);
        }
        if (this.shutdown) {
            outNew.close();
            return;
        }
        this.count.put(currentThreadId, 0);
    }

    public void close() {
        for (Map.Entry<Integer, OutputStream> threadStreamEntrySet : this.threadFileMap.entrySet()) {
            OutputStream out = threadStreamEntrySet.getValue();
            int streamTheadId = threadStreamEntrySet.getKey();
            System.out.print("[unlogged] close file for thread [" + streamTheadId + "]\n");
            try {
                out.close();
            }
            catch (IOException e) {
                this.errorLogger.log(e);
            }
        }
    }

    @Override
    public void writeNewObjectType(long id, long typeId) {
        if (this.skipUploads) {
            return;
        }
        this.fileCollector.indexObjectTypeEntry(id, (int)typeId);
    }

    @Override
    public void writeEvent(int probeId, long valueId) {
        long timestamp = System.nanoTime();
        int currentThreadId = this.threadId.get();
        try {
            byte[] buffer = this.threadLocalByteBuffer.get();
            buffer[0] = 7;
            long currentEventId = this.getNextEventId();
            buffer[1] = (byte)(currentEventId >>> 56);
            buffer[2] = (byte)(currentEventId >>> 48);
            buffer[3] = (byte)(currentEventId >>> 40);
            buffer[4] = (byte)(currentEventId >>> 32);
            buffer[5] = (byte)(currentEventId >>> 24);
            buffer[6] = (byte)(currentEventId >>> 16);
            buffer[7] = (byte)(currentEventId >>> 8);
            buffer[8] = (byte)(currentEventId >>> 0);
            buffer[9] = (byte)(timestamp >>> 56);
            buffer[10] = (byte)(timestamp >>> 48);
            buffer[11] = (byte)(timestamp >>> 40);
            buffer[12] = (byte)(timestamp >>> 32);
            buffer[13] = (byte)(timestamp >>> 24);
            buffer[14] = (byte)(timestamp >>> 16);
            buffer[15] = (byte)(timestamp >>> 8);
            buffer[16] = (byte)(timestamp >>> 0);
            buffer[17] = (byte)(probeId >>> 24);
            buffer[18] = (byte)(probeId >>> 16);
            buffer[19] = (byte)(probeId >>> 8);
            buffer[20] = (byte)(probeId >>> 0);
            buffer[21] = (byte)(valueId >>> 56);
            buffer[22] = (byte)(valueId >>> 48);
            buffer[23] = (byte)(valueId >>> 40);
            buffer[24] = (byte)(valueId >>> 32);
            buffer[25] = (byte)(valueId >>> 24);
            buffer[26] = (byte)(valueId >>> 16);
            buffer[27] = (byte)(valueId >>> 8);
            buffer[28] = (byte)(valueId >>> 0);
            buffer[29] = 0;
            buffer[30] = 0;
            buffer[31] = 0;
            buffer[32] = 0;
            this.getStreamForThread(currentThreadId).write(buffer);
            if (this.getThreadEventCountAddAndGet(currentThreadId, 1) >= 100000) {
                this.prepareNextFile(currentThreadId);
            }
        }
        catch (Exception e) {
            this.errorLogger.log(e);
        }
    }

    public synchronized long getNextEventId() {
        return this.eventId.getAndIncrement();
    }

    @Override
    public void writeNewTypeRecord(int typeId, String typeName, byte[] toString) {
        this.fileCollector.indexTypeEntry(typeId, typeName, toString);
    }

    @Override
    public void writeWeaveInfo(byte[] byteArray) {
        this.fileCollector.addClassWeaveInfo(byteArray);
    }

    @Override
    public void shutdown() throws IOException, InterruptedException {
        System.err.println("[unlogged] shutdown logger");
        this.skipUploads = true;
        this.shutdown = true;
        this.logFileTimeAgeChecker.shutdown();
        this.fileCollector.shutdown();
        this.threadPoolExecutor5Seconds.shutdown();
        this.threadPoolExecutor.shutdown();
    }

    @Override
    public void writeEvent(int probeId, long valueId, byte[] toByteArray) {
        long timestamp = System.nanoTime();
        int currentThreadId = this.threadId.get();
        try {
            ByteArrayOutputStream boasTh = this.baos.get();
            boasTh.reset();
            DataOutputStream dos = new DataOutputStream(boasTh);
            dos.write(7);
            dos.writeLong(this.getNextEventId());
            dos.writeLong(timestamp);
            dos.writeInt(probeId);
            dos.writeLong(valueId);
            dos.writeInt(toByteArray.length);
            dos.write(toByteArray);
            this.getStreamForThread(currentThreadId).write(boasTh.toByteArray());
            if (this.getThreadEventCountAddAndGet(currentThreadId, 1) >= 100000) {
                this.prepareNextFile(currentThreadId);
            }
        }
        catch (IOException e) {
            this.errorLogger.log(e);
        }
    }

    @Override
    public void writeEvent(int probeId, long valueId, ByteArrayOutputStream outputStream) {
        long timestamp = System.nanoTime();
        int currentThreadId = this.threadId.get();
        try {
            ByteArrayOutputStream baosTh = this.baos.get();
            baosTh.reset();
            DataOutputStream dos = new DataOutputStream(baosTh);
            dos.write(7);
            dos.writeLong(this.getNextEventId());
            dos.writeLong(timestamp);
            dos.writeInt(probeId);
            dos.writeLong(valueId);
            dos.writeInt(outputStream.size());
            outputStream.writeTo(dos);
            outputStream.flush();
            this.getStreamForThread(currentThreadId).write(baosTh.toByteArray());
            this.getThreadEventCountAddAndGet(currentThreadId, 1);
        }
        catch (IOException e) {
            this.errorLogger.log(e);
        }
    }

    @Override
    public void errorLog(String message) {
        this.errorLogger.log(message);
    }

    @Override
    public void errorLog(Throwable throwable) {
        this.errorLogger.log(throwable);
    }

    @Override
    public int getThreadEventCount(int currentThreadId) {
        if (!this.count.containsKey(currentThreadId)) {
            this.count.put(currentThreadId, 0);
        }
        return this.count.get(currentThreadId);
    }

    public int getThreadEventCountAddAndGet(int currentThreadId, int incVal) {
        if (!this.count.containsKey(currentThreadId)) {
            this.count.put(currentThreadId, incVal);
            return incVal;
        }
        int countOldVal = this.count.get(currentThreadId);
        int value = countOldVal + incVal;
        this.count.put(currentThreadId, value);
        return value;
    }
}

