/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.logging.perthread;

import com.insidious.common.UploadFile;
import com.insidious.common.cqengine.ObjectInfoDocument;
import com.insidious.common.cqengine.StringInfoDocument;
import com.insidious.common.cqengine.TypeInfoDocument;
import io.unlogged.logging.IErrorLogger;
import io.unlogged.logging.perthread.ArchivedIndexWriter;
import io.unlogged.logging.util.FileNameGenerator;
import io.unlogged.logging.util.NetworkClient;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class RawFileCollector
implements Runnable {
    public static final int MAX_CONSECUTIVE_FAILURE_COUNT = 10;
    public static final int FAILURE_SLEEP_DELAY = 10;
    public static final ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool(4);
    private final IErrorLogger errorLogger;
    private final BlockingQueue<UploadFile> fileList;
    private final FileNameGenerator indexFileNameGenerator;
    private final Queue<TypeInfoDocument> typeInfoDocuments;
    private final NetworkClient networkClient;
    private final BlockingQueue<TypeInfoDocument> typesToIndex;
    private final List<ObjectInfoDocument> EMPTY_LIST = new ArrayList<ObjectInfoDocument>();
    private final List<StringInfoDocument> EMPTY_STRING_LIST = new ArrayList<StringInfoDocument>();
    private final Queue<TypeInfoDocument> EMPTY_TYPE_LIST = new ArrayBlockingQueue<TypeInfoDocument>(1);
    private final FileOutputStream classWeaveFileRaw;
    private final File outputDir;
    private final BlockingQueue<StringInfoDocument> stringsToIndex;
    private final BlockingQueue<ObjectInfoDocument> objectsToIndex;
    private final ArchiveCloser archiveCloser;
    private final BlockingQueue<ArchivedIndexWriter> archiveQueue = new ArrayBlockingQueue<ArchivedIndexWriter>(100);
    public int filesPerArchive = 0;
    private boolean shutdown = false;
    private boolean shutdownComplete = false;
    private boolean skipUploads;
    private ArchivedIndexWriter archivedIndexWriter;
    private int fileCount = 0;
    private AtomicBoolean isDraining = new AtomicBoolean(false);
    private final Lock archiveSwapLock = new ReentrantLock();

    public RawFileCollector(int filesPerArchive, FileNameGenerator indexFileNameGenerator, NetworkClient networkClient, IErrorLogger errorLogger, File outputDir) throws IOException {
        this.filesPerArchive = filesPerArchive;
        this.networkClient = networkClient;
        this.indexFileNameGenerator = indexFileNameGenerator;
        this.errorLogger = errorLogger;
        this.fileList = new ArrayBlockingQueue<UploadFile>(131072);
        this.typeInfoDocuments = new ArrayBlockingQueue<TypeInfoDocument>(0x100000);
        this.typesToIndex = new ArrayBlockingQueue<TypeInfoDocument>(0x100000);
        this.stringsToIndex = new ArrayBlockingQueue<StringInfoDocument>(0x100000);
        this.objectsToIndex = new ArrayBlockingQueue<ObjectInfoDocument>(0x100000);
        this.outputDir = outputDir;
        this.finalizeArchiveAndUpload();
        this.classWeaveFileRaw = new FileOutputStream(new File(outputDir + "/class.weave.dat"));
        this.archiveCloser = new ArchiveCloser(this.archiveQueue, errorLogger);
        EXECUTOR_SERVICE.submit(this.archiveCloser);
    }

    private void finalizeArchiveAndUpload() throws IOException {
        boolean added;
        this.archiveSwapLock.lock();
        ArchivedIndexWriter archivedIndexWriterOld = this.archivedIndexWriter;
        this.archivedIndexWriter = new ArchivedIndexWriter(this.indexFileNameGenerator.getNextFile(), this.outputDir + "/class.weave.dat", this.errorLogger);
        this.archiveSwapLock.unlock();
        this.fileCount = 0;
        if (archivedIndexWriterOld != null && !(added = this.archiveQueue.offer(archivedIndexWriterOld))) {
            this.errorLogger.log("Failed to close archive queue, queue is full");
        }
    }

    @Override
    public void run() {
        try {
            while (true) {
                long start = System.currentTimeMillis();
                if (this.shutdown) {
                    return;
                }
                try {
                    EXECUTOR_SERVICE.submit(() -> {
                        try {
                            if (!this.archiveSwapLock.tryLock()) {
                                return;
                            }
                            this.drainItemsToIndex(this.archivedIndexWriter);
                            this.archiveSwapLock.unlock();
                        }
                        catch (Throwable e) {
                            this.errorLogger.log(e);
                        }
                    });
                    this.upload();
                }
                catch (IOException e) {
                    this.errorLogger.log(e);
                }
                Thread.sleep(1000L);
            }
        }
        catch (Throwable e) {
            this.errorLogger.log("failed to write archived index to disk: " + e.getMessage());
            return;
        }
    }

    public void shutdown() {
        this.shutdown = true;
        this.errorLogger.log("shutting down raw file collector");
        EXECUTOR_SERVICE.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload() throws IOException {
        if (this.shutdownComplete) {
            return;
        }
        try {
            UploadFile logFile = this.fileList.poll(1L, TimeUnit.SECONDS);
            if (logFile == null) {
                if (this.fileCount > 0 || this.shutdown) {
                    this.errorLogger.log("files from queue, currently [" + this.fileCount + "] files in list : shutdown: " + this.shutdown);
                    this.finalizeArchiveAndUpload();
                    return;
                }
                return;
            }
            LinkedList<UploadFile> logFiles = new LinkedList<UploadFile>();
            this.fileList.drainTo(logFiles, this.filesPerArchive - this.archivedIndexWriter.fileCount());
            logFiles.add(logFile);
            for (UploadFile file : logFiles) {
                File fileToAddToArchive = new File(file.path);
                this.archivedIndexWriter.writeFileEntry(file);
                ++this.fileCount;
                this.errorLogger.log("delete [" + file.path + "]");
                fileToAddToArchive.delete();
            }
        }
        catch (IOException e) {
            System.err.println("[unlogged] failed to upload file: " + e.getMessage());
            this.errorLogger.log(e);
        }
        catch (InterruptedException e) {
            this.errorLogger.log("file upload cron interrupted, shutting down");
        }
        finally {
            if (this.archivedIndexWriter.fileCount() >= this.filesPerArchive || this.shutdown) {
                this.finalizeArchiveAndUpload();
            }
            if (this.shutdown) {
                this.shutdownComplete = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drainItemsToIndex(ArchivedIndexWriter writer) {
        if (!this.isDraining.compareAndSet(false, true)) {
            return;
        }
        try {
            this.errorLogger.log("[" + writer.getArchiveFile().getName() + "] Drain items to index: " + this.objectsToIndex.size() + ", " + this.typesToIndex.size() + ", " + this.stringsToIndex.size());
            ArrayList<StringInfoDocument> stringInfoDocuments = new ArrayList<StringInfoDocument>();
            ArrayList<ObjectInfoDocument> objectInfoDocuments = new ArrayList<ObjectInfoDocument>(this.objectsToIndex.size());
            this.objectsToIndex.drainTo(objectInfoDocuments);
            ArrayList newTypes = new ArrayList();
            this.typesToIndex.drainTo(newTypes);
            this.typeInfoDocuments.addAll(newTypes);
            this.stringsToIndex.drainTo(stringInfoDocuments);
            if (objectInfoDocuments.size() == 0 && stringInfoDocuments.size() == 0 && this.typeInfoDocuments.size() == 0) {
                this.errorLogger.log("no new data to record, return");
                return;
            }
            writer.drainQueueToIndex(objectInfoDocuments, this.EMPTY_TYPE_LIST, stringInfoDocuments);
            this.errorLogger.log("[" + writer.getArchiveFile().getName() + "] Drained");
        }
        finally {
            this.isDraining.set(false);
        }
    }

    public void indexObjectTypeEntry(long id, int typeId) {
        this.objectsToIndex.offer(new ObjectInfoDocument(id, typeId));
    }

    public void indexStringEntry(long id, String stringObject) {
        this.stringsToIndex.offer(new StringInfoDocument(id, stringObject));
    }

    public void addValueId(long valueId) {
        this.archivedIndexWriter.addValueId(valueId);
    }

    public void addProbeId(int probeId) {
        this.archivedIndexWriter.addProbeId(probeId);
    }

    public void indexTypeEntry(int typeId, String typeName, byte[] typeInfoBytes) {
        this.typesToIndex.offer(new TypeInfoDocument(typeId, typeName, typeInfoBytes));
    }

    public synchronized void addClassWeaveInfo(byte[] byteArray) {
        try {
            this.classWeaveFileRaw.write(byteArray);
            this.classWeaveFileRaw.flush();
        }
        catch (IOException e) {
            this.errorLogger.log("Failed to write class weave information: " + e.getMessage());
        }
    }

    public BlockingQueue<UploadFile> getFileQueue() {
        return this.fileList;
    }

    static /* synthetic */ List access$000(RawFileCollector x0) {
        return x0.EMPTY_LIST;
    }

    static /* synthetic */ Queue access$100(RawFileCollector x0) {
        return x0.typeInfoDocuments;
    }

    static /* synthetic */ List access$200(RawFileCollector x0) {
        return x0.EMPTY_STRING_LIST;
    }

    static /* synthetic */ NetworkClient access$300(RawFileCollector x0) {
        return x0.networkClient;
    }

    public class ArchiveCloser
    implements Runnable {
        private final BlockingQueue<ArchivedIndexWriter> archiveQueue;
        private final IErrorLogger errorLogger;

        public ArchiveCloser(BlockingQueue<ArchivedIndexWriter> archiveQueue, IErrorLogger errorLogger) {
            this.archiveQueue = archiveQueue;
            this.errorLogger = errorLogger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) lbl-1000:
                    // 5 sources

                    {
                        archivedIndexWriterOld = this.archiveQueue.take();
                        try {
                            RawFileCollector.this.drainItemsToIndex(archivedIndexWriterOld);
                            archivedIndexWriterOld.drainQueueToIndex(RawFileCollector.access$000(RawFileCollector.this), RawFileCollector.access$100(RawFileCollector.this), RawFileCollector.access$200(RawFileCollector.this));
                            archivedIndexWriterOld.close();
                            this.errorLogger.log("closed archive: " + archivedIndexWriterOld.getArchiveFile().getName());
                        }
                        catch (Throwable e) {
                            this.errorLogger.log(e);
                        }
                        if (RawFileCollector.access$300(RawFileCollector.this) == null || RawFileCollector.access$300(RawFileCollector.this).getServerUrl().equals("") || RawFileCollector.access$300(RawFileCollector.this).getServerUrl().equals("null")) continue;
                        archiveFile = archivedIndexWriterOld.getArchiveFile();
                        try {
                            this.errorLogger.log("uploading file: " + archiveFile.getAbsolutePath());
                            RawFileCollector.access$300(RawFileCollector.this).uploadFile(archiveFile.getAbsolutePath(), this.errorLogger.getPath());
                        }
                        catch (IOException e) {
                            this.errorLogger.log("failed to upload archive file: " + e.getMessage());
                        }
                        finally {
                            archiveFile.delete();
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    this.errorLogger.log("Archive closer worker was interrupted: " + e.getMessage());
                    break;
                }
                catch (Exception somethingElse) {
                    this.errorLogger.log("Archive closer worker was interrupted but not closing: " + somethingElse.getMessage());
                    this.errorLogger.log(somethingElse);
                    continue;
                }
                ** GOTO lbl-1000
                break;
            }
        }
    }
}

