/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.logging.util;

import java.io.File;
import java.util.Date;

public class FileNameGenerator {
    private final File dir;
    private final String prefix;
    private final String suffix;
    private int fileCount = 0;

    public FileNameGenerator(File dir, String prefix, String suffix) {
        this.dir = dir;
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public File getNextFile() {
        return new File(this.dir, this.prefix + String.format("%05d", ++this.fileCount) + "-" + new Date().getTime() + this.suffix);
    }

    public File getNextFile(String threadId) {
        return new File(this.dir, this.prefix + String.format("%06d", ++this.fileCount) + "-" + threadId + this.suffix);
    }

    public String getOutputDir() {
        return this.dir.getAbsolutePath();
    }
}

