/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.logging.util;

import io.unlogged.logging.util.AggregatedFileLogger;
import io.unlogged.logging.util.ObjectIdMap;
import io.unlogged.logging.util.TypeIdAggregatedStreamMap;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;

public class ObjectIdAggregatedStream
extends ObjectIdMap {
    private final String lineSeparator = "\n";
    private final AggregatedFileLogger aggregatedLogger;
    private final TypeIdAggregatedStreamMap typeToId;

    public ObjectIdAggregatedStream(AggregatedFileLogger aggregatedLogger, TypeIdAggregatedStreamMap typeToId, File outputDir) throws IOException {
        super(0x800000, outputDir);
        this.typeToId = typeToId;
        this.aggregatedLogger = aggregatedLogger;
    }

    @Override
    protected void onNewObject(Object o) {
        this.typeToId.getTypeIdString(o.getClass());
    }

    @Override
    protected void onNewObjectId(Object o, long id) {
        int typeId = this.typeToId.getTypeIdString(o.getClass());
        this.aggregatedLogger.writeNewObjectType(id, typeId);
        if (o instanceof Throwable) {
            try {
                Throwable t = (Throwable)o;
                long causeId = this.getId(t.getCause());
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                DataOutputStream output = new DataOutputStream(outputStream);
                output.writeLong(id);
                byte[] messageBytes = t.getMessage().getBytes();
                output.writeInt(messageBytes.length);
                output.write(messageBytes);
                output.writeLong(causeId);
                StackTraceElement[] trace = t.getStackTrace();
                for (int i2 = 0; i2 < 1; ++i2) {
                    StackTraceElement e = trace[i2];
                    byte[] classNameBytes = e.getClassName().getBytes();
                    byte[] methodNameBytes = e.getMethodName().getBytes();
                    byte[] fileNameBytes = e.getFileName().getBytes();
                    output.writeBoolean(e.isNativeMethod());
                    output.writeInt(classNameBytes.length);
                    output.write(classNameBytes);
                    output.writeInt(methodNameBytes.length);
                    output.write(methodNameBytes);
                    output.writeInt(fileNameBytes.length);
                    output.write(fileNameBytes);
                    output.writeInt(e.getLineNumber());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void close() {
    }
}

