/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.logging.util;

import io.unlogged.logging.util.AggregatedFileLogger;
import io.unlogged.logging.util.TypeIdUtil;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;

public class TypeIdAggregatedStreamMap {
    public static final int TYPEID_NULL = -1;
    public static final int TYPEID_VOID = 0;
    public static final int TYPEID_BOOLEAN = 1;
    public static final int TYPEID_BYTE = 2;
    public static final int TYPEID_CHAR = 3;
    public static final int TYPEID_DOUBLE = 4;
    public static final int TYPEID_FLOAT = 5;
    public static final int TYPEID_INT = 6;
    public static final int TYPEID_LONG = 7;
    public static final int TYPEID_SHORT = 8;
    public static final int TYPEID_OBJECT = 9;
    private static final Class<?>[] BASIC_TYPE_CLASS = new Class[]{Void.TYPE, Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Object.class, String.class};
    private static final String SEPARATOR = ",";
    private final AggregatedFileLogger aggregatedLogger;
    private final HashMap<Class<?>, Integer> classToIdMap;
    private int nextId;

    public TypeIdAggregatedStreamMap(AggregatedFileLogger aggregatedLogger) {
        this.aggregatedLogger = aggregatedLogger;
        this.classToIdMap = new HashMap(65536);
        for (int i2 = 0; i2 < BASIC_TYPE_CLASS.length; ++i2) {
            Integer id = this.createTypeRecord(BASIC_TYPE_CLASS[i2]);
            assert (i2 >= 10 || id.equals(i2));
        }
    }

    public static boolean isPrimitiveTypeOrNull(int typeId) {
        switch (typeId) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    private int createTypeRecord(Class<?> type) {
        int superClass = this.getTypeIdString(type.getSuperclass());
        int componentType = this.getTypeIdString(type.getComponentType());
        LinkedList<Integer> interfaceClasses = new LinkedList<Integer>();
        for (Class<?> anInterface : type.getInterfaces()) {
            int interfaceClassId = this.getTypeIdString(anInterface);
            interfaceClasses.add(interfaceClassId);
        }
        String classLocation = this.getClassLocation(type);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream record = new DataOutputStream(byteArrayOutputStream);
        String typeNameFromClass = this.getTypeNameFromClass(type);
        String classLoaderIdentifier = TypeIdUtil.getClassLoaderIdentifier(type.getName());
        int newId = this.nextId++;
        this.classToIdMap.put(type, newId);
        try {
            record.writeInt(newId);
            record.writeInt(typeNameFromClass.getBytes().length);
            record.write(typeNameFromClass.getBytes());
            record.writeInt(classLocation.getBytes().length);
            record.write(classLocation.getBytes());
            record.writeInt(superClass);
            record.writeInt(componentType);
            record.writeInt(classLoaderIdentifier.getBytes().length);
            record.write(classLoaderIdentifier.getBytes());
            record.writeInt(interfaceClasses.size());
            for (Integer interfaceClass : interfaceClasses) {
                record.writeInt(interfaceClass);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.aggregatedLogger.writeNewTypeRecord(newId, typeNameFromClass, byteArrayOutputStream.toByteArray());
        return newId;
    }

    public int getTypeIdString(Class<?> type) {
        if (type == null) {
            return -1;
        }
        if (this.classToIdMap.containsKey(type)) {
            return this.classToIdMap.get(type);
        }
        return this.createTypeRecord(type);
    }

    private String getTypeNameFromClass(Class<?> type) {
        if (type.isArray()) {
            int count = 0;
            while (type.isArray()) {
                ++count;
                type = type.getComponentType();
            }
            StringBuilder b = new StringBuilder(type.getName().length() + count * 2);
            b.append(type.getName());
            for (int i2 = 0; i2 < count; ++i2) {
                b.append("[]");
            }
            return b.toString();
        }
        return type.getName();
    }

    private String getClassLocation(Class<?> c) {
        URL resource;
        String name;
        ClassLoader loader = c.getClassLoader();
        if (loader == null) {
            for (loader = ClassLoader.getSystemClassLoader(); loader != null && loader.getParent() != null; loader = loader.getParent()) {
            }
        }
        if (loader != null && (name = c.getName()) != null && (resource = loader.getResource(name.replace(".", "/") + ".class")) != null) {
            return resource.toString();
        }
        return "";
    }
}

