/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.mocking;

import io.unlogged.mocking.DeclaredMock;
import io.unlogged.mocking.ReturnValueType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ReturnValue {
    private String value;
    private ReturnValueType returnValueType;
    private final List<DeclaredMock> declaredMocks = new ArrayList<DeclaredMock>();
    private String className;

    public ReturnValue(String value, String returnValueClassName, ReturnValueType returnValueType) {
        this.value = value;
        this.className = returnValueClassName;
        this.returnValueType = returnValueType;
    }

    public ReturnValue(String value, String returnValueClassName, ReturnValueType returnValueType, List<DeclaredMock> declaredMocks) {
        this.value = value;
        this.className = returnValueClassName;
        this.returnValueType = returnValueType;
        this.declaredMocks.addAll(declaredMocks);
    }

    public ReturnValue() {
    }

    public ReturnValue(ReturnValue returnParameter) {
        this.value = returnParameter.value;
        this.className = returnParameter.className;
        this.returnValueType = returnParameter.returnValueType;
        this.declaredMocks.addAll(returnParameter.declaredMocks.stream().map(DeclaredMock::new).collect(Collectors.toList()));
    }

    public String getClassName() {
        return this.className;
    }

    public String getValue() {
        return this.value;
    }

    public ReturnValueType getReturnValueType() {
        return this.returnValueType;
    }

    public void addDeclaredMock(DeclaredMock mockDefinition) {
        this.declaredMocks.add(mockDefinition);
    }

    public List<DeclaredMock> getDeclaredMocks() {
        return this.declaredMocks;
    }

    public String toString() {
        return "ReturnValue{value='" + this.value + '\'' + ", returnValueType=" + (Object)((Object)this.returnValueType) + ", className='" + this.className + '\'' + '}';
    }
}

