/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.runner;

import io.unlogged.AgentCommandExecutorImpl;
import io.unlogged.AgentCommandRawResponse;
import io.unlogged.MethodSignatureParser;
import io.unlogged.Runtime;
import io.unlogged.atomic.AssertionEngine;
import io.unlogged.atomic.AssertionResult;
import io.unlogged.atomic.AssertionType;
import io.unlogged.atomic.AtomicAssertion;
import io.unlogged.atomic.Expression;
import io.unlogged.atomic.MethodUnderTest;
import io.unlogged.atomic.StoredCandidate;
import io.unlogged.command.AgentCommandRequest;
import io.unlogged.command.AgentCommandResponse;
import io.unlogged.command.ResponseType;
import io.unlogged.logging.DiscardEventLogger;
import io.unlogged.logging.ObjectMapperFactory;
import io.unlogged.mocking.DeclaredMock;
import io.unlogged.runner.AssertionResultWithRawObject;
import io.unlogged.runner.AtomicAssertionUtils;
import io.unlogged.runner.AtomicRecord;
import io.unlogged.runner.AtomicRecordService;
import io.unlogged.runner.ClassUnderTest;
import io.unlogged.runner.JsonTreeUtils;
import io.unlogged.runner.MethodUtils;
import io.unlogged.runner.ParameterUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import junit.framework.AssertionFailedError;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import selogger.com.fasterxml.jackson.core.JsonProcessingException;
import selogger.com.fasterxml.jackson.databind.JsonNode;
import selogger.com.fasterxml.jackson.databind.ObjectMapper;
import selogger.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import selogger.org.slf4j.Logger;
import selogger.org.slf4j.LoggerFactory;

public class UnloggedTestRunner
extends Runner {
    private static final ObjectMapper objectMapper;
    private static final Logger logger;
    private static final List<String> JACKSON_PROPERTY_NAMES_SET_FALSE;
    private static boolean isLombokPresent;
    private final AtomicRecordService atomicRecordService = new AtomicRecordService();
    private final AgentCommandExecutorImpl commandExecutor;
    private final AtomicInteger testCounter = new AtomicInteger();
    private boolean isSpringPresent;
    private Method getBeanMethod;
    private Object applicationContext;
    private final Description testDescription;
    private final Map<String, Description> descriptionMap = new HashMap<String, Description>();
    private final Map<Description, StoredCandidate> descriptionStoredCandidateMap = new HashMap<Description, StoredCandidate>();

    public UnloggedTestRunner(Class<?> testClass) {
        DiscardEventLogger eventLogger = new DiscardEventLogger(){

            @Override
            public Object getObjectByClassName(String className) {
                if (UnloggedTestRunner.this.applicationContext == null) {
                    return null;
                }
                try {
                    return UnloggedTestRunner.this.getBeanMethod.invoke(UnloggedTestRunner.this.applicationContext, Class.forName(className));
                }
                catch (Throwable e) {
                    return null;
                }
            }
        };
        this.commandExecutor = new AgentCommandExecutorImpl(ObjectMapperFactory.createObjectMapperReactive(), eventLogger);
        this.testDescription = Description.createTestDescription(testClass, (String)"Unlogged test runner");
        this.commandExecutor.enableSpringIntegration(testClass);
        this.collectTests();
        Runtime.getInstance("format=discard");
    }

    public Description getDescription() {
        logger.debug("getDescription: " + this.testDescription);
        return this.testDescription;
    }

    public void run(RunNotifier notifier) {
        Map<String, AtomicRecord> recordsMap = this.atomicRecordService.updateMap();
        Map<String, DeclaredMock> mocksById = recordsMap.values().stream().map(AtomicRecord::getDeclaredMockMap).map(Map::values).flatMap(Collection::stream).flatMap(Collection::stream).collect(Collectors.toMap(DeclaredMock::getId, e -> e));
        for (Description description : this.testDescription.getChildren()) {
            this.executeByDescription(notifier, mocksById, description);
        }
    }

    private void executeByDescription(RunNotifier notifier, Map<String, DeclaredMock> mocksById, Description description) {
        StoredCandidate candidate = this.descriptionStoredCandidateMap.get(description);
        if (candidate != null) {
            notifier.fireTestStarted(description);
            Throwable throwable = this.fireTest(mocksById, candidate);
            if (throwable != null) {
                notifier.fireTestFailure(new Failure(description, throwable));
            }
        }
        if (description.getChildren() != null) {
            for (Description child : description.getChildren()) {
                this.executeByDescription(notifier, mocksById, child);
            }
        }
        if (candidate != null) {
            notifier.fireTestFinished(description);
        }
    }

    public void collectTests() {
        this.descriptionStoredCandidateMap.clear();
        try {
            Map<String, AtomicRecord> recordsMap = this.atomicRecordService.updateMap();
            for (String className : recordsMap.keySet()) {
                Class<?> testClass1;
                AtomicRecord classRecords = recordsMap.get(className);
                Map<String, List<StoredCandidate>> storedCandidateMap = classRecords.getStoredCandidateMap();
                int candidateCount = storedCandidateMap.values().stream().mapToInt(Collection::size).sum();
                if (candidateCount < 1) continue;
                try {
                    testClass1 = Class.forName(className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println("Class not found: " + className);
                    continue;
                }
                Description suiteDescription = Description.createSuiteDescription(testClass1);
                this.testDescription.addChild(suiteDescription);
                for (String methodHashKey : storedCandidateMap.keySet()) {
                    List<StoredCandidate> candidates = storedCandidateMap.get(methodHashKey);
                    if (candidates.size() == 0) continue;
                    for (StoredCandidate candidate : candidates) {
                        String candidateId = candidate.getName() == null ? candidate.getCandidateId() : candidate.getName();
                        Class<?> targetClassTypeInstance = Class.forName(candidate.getMethod().getClassName());
                        Description testDescription = this.getTestDescription(targetClassTypeInstance, candidateId, candidate.getCandidateId());
                        suiteDescription.addChild(testDescription);
                        this.descriptionStoredCandidateMap.put(testDescription, candidate);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new RuntimeException(throwable);
        }
    }

    private Description getTestDescription(Class<?> targetClassTypeInstance, String name, String id) {
        String key = targetClassTypeInstance.getCanonicalName() + name + id;
        if (this.descriptionMap.containsKey(key)) {
            return this.descriptionMap.get(key);
        }
        Description testDescription1 = null;
        try {
            testDescription1 = Description.createTestDescription(Class.forName(targetClassTypeInstance.getCanonicalName()), (String)name);
        }
        catch (ClassNotFoundException e) {
            testDescription1 = Description.createTestDescription((String)targetClassTypeInstance.getCanonicalName(), (String)name, (Serializable)((Object)id));
        }
        this.descriptionMap.put(key, testDescription1);
        return testDescription1;
    }

    private Throwable fireTest(Map<String, DeclaredMock> mocksById, StoredCandidate candidate) {
        MethodUnderTest methodUnderTest = candidate.getMethod();
        ArrayList<DeclaredMock> mockList = new ArrayList<DeclaredMock>();
        List<String> mocksToUse = candidate.getMockIds();
        if (mocksToUse != null) {
            for (String mockId : mocksToUse) {
                DeclaredMock mockDefinition = mocksById.get(mockId);
                if (mockDefinition == null) {
                    return new UndeclaredThrowableException(new Throwable("Could not find mock " + mockId + " used in candidate: " + candidate.getCandidateId()), "Could not find mock " + mockId + " used in candidate: " + candidate.getCandidateId());
                }
                mockList.add(mockDefinition);
            }
        }
        AtomicAssertion assertions = candidate.getTestAssertions();
        AssertionResultWithRawObject verificationResultRaw = this.executeAndVerify(candidate, mockList);
        AgentCommandResponse agentCommandResponse = verificationResultRaw.getResponseObject().getAgentCommandResponse();
        AssertionResult verificationResult = verificationResultRaw.getAssertionResult();
        boolean isVerificationPassing = verificationResult.isPassing();
        if (isVerificationPassing) {
            return null;
        }
        if (agentCommandResponse == null) {
            return new AssertionFailedError("Response is null");
        }
        if (verificationResultRaw.getResponseObject().getResponseObject() instanceof Throwable) {
            return (Throwable)verificationResultRaw.getResponseObject().getResponseObject();
        }
        List<AtomicAssertion> assertionList = AtomicAssertionUtils.flattenAssertionMap(assertions);
        AssertionResult assertionResultMap = verificationResultRaw.getAssertionResult();
        if (verificationResultRaw.getResponseObject() == null) {
            return new AssertionFailedError(String.valueOf(verificationResultRaw));
        }
        AgentCommandRawResponse rawResponse = verificationResultRaw.getResponseObject();
        AgentCommandResponse acr = rawResponse.getAgentCommandResponse();
        Object responseObject = rawResponse.getResponseObject();
        if (responseObject instanceof Throwable) {
            // empty if block
        }
        for (AtomicAssertion atomicAssertion : assertionList) {
            JsonNode objectNode;
            String methodReturnValue;
            Boolean status = assertionResultMap.getResults().get(atomicAssertion.getId());
            if (status.booleanValue() || atomicAssertion.getAssertionType() == AssertionType.ANYOF || atomicAssertion.getAssertionType() == AssertionType.ALLOF || atomicAssertion.getAssertionType() == AssertionType.NOTANYOF || atomicAssertion.getAssertionType() == AssertionType.NOTALLOF) continue;
            String string = methodReturnValue = acr.getMethodReturnValue() instanceof String ? (String)acr.getMethodReturnValue() : String.valueOf(acr.getMethodReturnValue());
            if (methodReturnValue == null) {
                try {
                    methodReturnValue = objectMapper.writeValueAsString(responseObject);
                }
                catch (JsonProcessingException e) {
                    methodReturnValue = String.valueOf(responseObject);
                }
            }
            try {
                objectNode = objectMapper.readTree(methodReturnValue);
            }
            catch (Exception e) {
                objectNode = objectMapper.getNodeFactory().textNode(methodReturnValue);
            }
            JsonNode valueFromJsonNode = JsonTreeUtils.getValueFromJsonNode(objectNode, atomicAssertion.getKey());
            Expression expression = atomicAssertion.getExpression();
            JsonNode expressedValue = expression.compute(valueFromJsonNode);
            String className = methodUnderTest.getClassName();
            if (className.contains(".")) {
                className = className.substring(className.lastIndexOf(".") + 1);
            }
            String message = "Expected " + (Object)((Object)atomicAssertion.getExpression()) + "([" + atomicAssertion.getExpectedValue() + "]) " + atomicAssertion.getAssertionType().toString() + "  actual [" + expressedValue + "]\n\t when the return value from method [" + className + "." + methodUnderTest.getName() + methodUnderTest.getSignature() + "]\n\t value [" + (expression == Expression.SELF ? atomicAssertion.getKey() : expression.name() + "(" + atomicAssertion.getKey() + ")") + "] as expected in test candidate [" + candidate.getCandidateId() + "][" + candidate.getName() + "]";
            List<String> methodParameterTypes = MethodSignatureParser.parseMethodSignature(methodUnderTest.getSignature());
            ArrayList<Object> messageTemplateValues = new ArrayList<Object>();
            messageTemplateValues.add(className + "." + methodUnderTest.getName() + "()");
            messageTemplateValues.add(candidate.getCandidateId());
            int parameterCount = methodParameterTypes.size() - 1;
            messageTemplateValues.add(methodParameterTypes.get(parameterCount));
            messageTemplateValues.add(candidate.getMockIds().size());
            String messageTemplate = "\n\n\u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2510\n\u2502 %-91s %-36s \u2502\n\u2502                                                                                                                                  \u2502\n\u2502 Returns: %-120s\u2502\n\u2502                                                                                                                                  \u2502\n\u2502 Mocks: %-122s\u2502\n\u2502                                                                                                                                  \u2502\n\u2502 Parameters: %-117s\u2502\n\u2502                                                                                                                                  \u2502\n";
            messageTemplateValues.add(parameterCount);
            for (int i2 = 0; i2 < parameterCount; ++i2) {
                String paramType = methodParameterTypes.get(i2);
                messageTemplate = messageTemplate + "\u2502   %-127s\u2502\n";
                messageTemplateValues.add(paramType + ": " + candidate.getMethodArguments().get(i2));
            }
            if (parameterCount > 0) {
                messageTemplate = messageTemplate + "\u2502                                                                                                                                  \u2502\n";
            }
            messageTemplate = messageTemplate + "\u2502 Failed Assertion                                                                                                                 \u2502\n\u2502                                                                                                                                  \u2502\n\u2502  Key:            %-112s\u2502\n\u2502  Expression:     %-112s\u2502\n\u2502  Assertion:      %-112s\u2502\n\u2502  Expected Value: %-112s\u2502\n\u2502  Actual Value:   %-112s\u2502\n\u2502                                                                                                                                  \u2502\n\u2502                                                                                                                                  \u2502\n\u2502 %-88s                UnloggedReplayTestReport \u2502\n\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2518";
            messageTemplateValues.add(atomicAssertion.getKey());
            messageTemplateValues.add((Object)atomicAssertion.getExpression());
            messageTemplateValues.add((Object)atomicAssertion.getAssertionType());
            messageTemplateValues.add(atomicAssertion.getExpectedValue());
            messageTemplateValues.add(expressedValue);
            messageTemplateValues.add(new Date().toString());
            AssertionFailedError thrownException = new AssertionFailedError(String.format(messageTemplate, messageTemplateValues.toArray(new Object[0])));
            return thrownException;
        }
        return null;
    }

    private AssertionResultWithRawObject executeAndVerify(StoredCandidate candidate, List<DeclaredMock> mockList) {
        AssertionResult assertionResult;
        AgentCommandResponse acr;
        List<String> methodArgumentValues = candidate.getMethodArguments();
        ArrayList<String> newArgumentValues = new ArrayList<String>(methodArgumentValues.size());
        List<String> methodSignatureTypes = MethodSignatureParser.parseMethodSignature(candidate.getMethod().getSignature());
        String methodReturnType = methodSignatureTypes.remove(methodSignatureTypes.size() - 1);
        boolean processReturnValueAsFloatDouble = Objects.equals(methodReturnType, "F") || Objects.equals(methodReturnType, "f") || Objects.equals(methodReturnType, "java.lang.Float") || Objects.equals(methodReturnType, "Ljava/lang/Float;") || Objects.equals(methodReturnType, "Ljava/lang/Double;") || Objects.equals(methodReturnType, "java.lang.Double") || Objects.equals(methodReturnType, "D");
        block15: for (int i2 = 0; i2 < methodSignatureTypes.size(); ++i2) {
            String methodSignatureType;
            String newValue = methodArgumentValues.get(i2);
            switch (methodSignatureType = methodSignatureTypes.get(i2)) {
                case "F": 
                case "f": 
                case "java.lang.Float": 
                case "Ljava/lang/Float;": 
                case "D": 
                case "d": 
                case "java.lang.Double": 
                case "Ljava/lang/Double;": {
                    newValue = ParameterUtils.processResponseForFloatAndDoubleTypes(methodSignatureType, newValue);
                    newArgumentValues.add(newValue);
                    continue block15;
                }
                default: {
                    newArgumentValues.add(newValue);
                }
            }
        }
        candidate.setMethodArguments(newArgumentValues);
        AgentCommandRawResponse executionResult = this.executeCandidate(candidate, mockList);
        if (executionResult.getResponseObject() instanceof Exception) {
            ((Exception)executionResult.getResponseObject()).printStackTrace();
        }
        if ((acr = executionResult.getAgentCommandResponse()) != null && processReturnValueAsFloatDouble) {
            Object returnValue = acr.getMethodReturnValue();
            String processedReturnValue = ParameterUtils.processResponseForFloatAndDoubleTypes(methodReturnType, String.valueOf(returnValue));
            acr.setMethodReturnValue(processedReturnValue);
        }
        if (executionResult == null) {
            assertionResult = new AssertionResult();
            assertionResult.setPassing(false);
            return new AssertionResultWithRawObject(assertionResult, new AgentCommandRawResponse(new AgentCommandResponse(), (Object)new AssertionFailedError("execution result is null")));
        }
        try {
            assertionResult = this.verifyCandidateExecution(executionResult.getAgentCommandResponse(), candidate);
        }
        catch (AssertionFailedError assertionFailedError) {
            assertionResult = new AssertionResult();
            assertionResult.setPassing(false);
            return new AssertionResultWithRawObject(assertionResult, new AgentCommandRawResponse(new AgentCommandResponse(), (Object)assertionFailedError));
        }
        return new AssertionResultWithRawObject(assertionResult, executionResult);
    }

    private AssertionResult verifyCandidateExecution(AgentCommandResponse executionResult, StoredCandidate candidate) {
        if (executionResult == null) {
            logger.warn("response is null [" + candidate + "]");
            AssertionResult assertionResult = new AssertionResult();
            assertionResult.setPassing(false);
            return assertionResult;
        }
        String responseClassName = executionResult.getResponseClassName();
        List<String> params = MethodSignatureParser.parseMethodSignature(candidate.getMethod().getSignature());
        responseClassName = params.get(params.size() - 1);
        return AssertionEngine.executeAssertions(candidate.getTestAssertions(), this.getResponseNode(String.valueOf(executionResult.getMethodReturnValue()), responseClassName));
    }

    private AgentCommandRawResponse executeCandidate(StoredCandidate candidate, List<DeclaredMock> mockList) {
        try {
            MethodUnderTest methodUnderTest = candidate.getMethod();
            ClassUnderTest classUnderTest = new ClassUnderTest(methodUnderTest.getClassName());
            AgentCommandRequest agentCommandRequest = MethodUtils.createExecuteRequestWithParameters(methodUnderTest, classUnderTest, candidate.getMethodArguments(), true);
            if (agentCommandRequest == null) {
                return new AgentCommandRawResponse(new AgentCommandResponse(), new Exception("Failed to create request for candidate [" + candidate + "]"));
            }
            agentCommandRequest.setDeclaredMocks(mockList);
            logger.info("Execute candidate: " + agentCommandRequest);
            return this.commandExecutor.executeCommandRaw(agentCommandRequest);
        }
        catch (Exception e) {
            AgentCommandResponse agentCommandResponse = new AgentCommandResponse();
            agentCommandResponse.setResponseType(ResponseType.FAILED);
            return new AgentCommandRawResponse(agentCommandResponse, e);
        }
    }

    private JsonNode getResponseNode(String methodReturnValue, String responseClassName) {
        try {
            if (methodReturnValue == null) {
                return JsonNodeFactory.instance.nullNode();
            }
            if (responseClassName.equals("char") || responseClassName.equals("C")) {
                try {
                    methodReturnValue = String.valueOf(objectMapper.readTree(methodReturnValue).textValue().codePointAt(0));
                    return objectMapper.getNodeFactory().numberNode(Integer.valueOf(methodReturnValue));
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
            }
            return objectMapper.readTree(methodReturnValue);
        }
        catch (JsonProcessingException e) {
            if ("java.lang.String".equals(responseClassName) && !methodReturnValue.startsWith("\"") && !methodReturnValue.endsWith("\"")) {
                try {
                    return objectMapper.readTree("\"" + methodReturnValue + "\"");
                }
                catch (JsonProcessingException e1) {
                    throw new AssertionFailedError("Failed to parse response: " + methodReturnValue + " => " + e1.getMessage());
                }
            }
            return null;
        }
    }

    static {
        logger = LoggerFactory.getLogger(UnloggedTestRunner.class);
        JACKSON_PROPERTY_NAMES_SET_FALSE = Arrays.asList("FAIL_ON_UNKNOWN_PROPERTIES", "FAIL_ON_IGNORED_PROPERTIES", "FAIL_ON_NULL_FOR_PRIMITIVES", "FAIL_ON_NULL_CREATOR_PROPERTIES", "FAIL_ON_MISSING_CREATOR_PROPERTIES", "FAIL_ON_NUMBERS_FOR_ENUMS", "FAIL_ON_TRAILING_TOKENS");
        System.setProperty("UNLOGGED_DISABLE", "true");
        try {
            Class<?> lombokBuilderAnnotation = Class.forName("lombok.Builder");
            isLombokPresent = true;
        }
        catch (ClassNotFoundException e) {
            isLombokPresent = false;
        }
        objectMapper = ObjectMapperFactory.createObjectMapperReactive();
    }

    private static class DummyClosable
    implements Closeable {
        private DummyClosable() {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

