/*
 * Decompiled with CFR 0.152.
 */
package io.unlogged.weaver;

import io.unlogged.Runtime;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WeaveParameters {
    private static final String[] SYSTEM_PACKAGES = new String[]{"sun/", "com/sun/", "java/", "javax/"};
    private static final String ARG_SEPARATOR = ",";
    private static final String SELOGGER_DEFAULT_OUTPUT_DIR = System.getProperty("user.home") + "/.unlogged/sessions/selogger-output-{time}";
    private static final Pattern timePattern = Pattern.compile(".*(\\{time:([^}]+)\\}).*");
    private final ArrayList<String> excludedNames;
    private final ArrayList<String> includedNames;
    private final ArrayList<String> excludedLocations;
    private String authToken = "localhost-token";
    private String output_dirname = SELOGGER_DEFAULT_OUTPUT_DIR;
    private String serverAddress;
    private String username;
    private String password;
    private String weaveOption = "ALL";
    private boolean outputJson = false;
    private boolean dumpClass = false;
    private int bufferSize = 32;
    private boolean weaveSecurityManagerClass = false;
    private Runtime.Mode mode = Runtime.Mode.TESTING;
    private int filesPerIndex = 10;
    private String agentServerPort = "0";

    public WeaveParameters(String args) {
        if (args == null) {
            args = "";
        }
        String[] a = args.split(ARG_SEPARATOR);
        SimpleDateFormat f = new SimpleDateFormat("yyyyMMdd-HHmmssSSS");
        this.output_dirname = this.output_dirname.replace("{time}", f.format(new Date()));
        this.excludedNames = new ArrayList<String>(Arrays.asList(SYSTEM_PACKAGES));
        this.includedNames = new ArrayList();
        this.excludedLocations = new ArrayList();
        for (String arg : a) {
            String prefix;
            if (arg.startsWith("output=")) {
                this.output_dirname = arg.substring("output=".length());
                if (this.output_dirname.contains("{time}")) {
                    this.output_dirname = this.output_dirname.replace("{time}", f.format(new Date()));
                    continue;
                }
                Matcher m = timePattern.matcher(this.output_dirname);
                if (!m.matches()) continue;
                this.output_dirname = this.output_dirname.replace(m.group(1), f.format(new Date()));
                continue;
            }
            if (arg.startsWith("weave=")) {
                this.weaveOption = arg.substring("weave=".length());
                continue;
            }
            if (arg.startsWith("agentserverport=")) {
                this.agentServerPort = arg.substring("agentserverport=".length());
                continue;
            }
            if (arg.startsWith("server=")) {
                this.serverAddress = arg.substring("server=".length());
                continue;
            }
            if (arg.startsWith("token=")) {
                this.authToken = arg.substring("token=".length());
                continue;
            }
            if (arg.startsWith("username=")) {
                this.username = arg.substring("username=".length());
                continue;
            }
            if (arg.startsWith("filePerIndex=")) {
                this.filesPerIndex = Integer.parseInt(arg.substring("filePerIndex=".length()));
                continue;
            }
            if (arg.startsWith("password=")) {
                this.password = arg.substring("password=".length());
                continue;
            }
            if (arg.startsWith("dump=")) {
                String classDumpOption = arg.substring("dump=".length());
                this.dumpClass = classDumpOption.equalsIgnoreCase("true");
                continue;
            }
            if (arg.startsWith("size=")) {
                this.bufferSize = Integer.parseInt(arg.substring("size=".length()));
                if (this.bufferSize >= 4) continue;
                this.bufferSize = 4;
                continue;
            }
            if (arg.startsWith("weavesecuritymanager=")) {
                this.weaveSecurityManagerClass = Boolean.parseBoolean(arg.substring("weavesecuritymanager=".length()));
                continue;
            }
            if (arg.startsWith("json=")) {
                String param = arg.substring("json=".length());
                this.outputJson = param.equalsIgnoreCase("true");
                continue;
            }
            if (arg.startsWith("e=")) {
                prefix = arg.substring("e=".length());
                if (prefix.length() <= 0) continue;
                prefix = prefix.replace('.', '/');
                this.excludedNames.add(prefix);
                continue;
            }
            if (arg.startsWith("i=")) {
                prefix = arg.substring("i=".length());
                if (prefix.length() <= 0) continue;
                prefix = prefix.replace('.', '/');
                this.includedNames.add(prefix);
                continue;
            }
            if (arg.startsWith("exlocation=")) {
                String location = arg.substring("exlocation=".length());
                if (location.length() <= 0) continue;
                this.excludedLocations.add(location);
                continue;
            }
            if (!arg.startsWith("format=")) continue;
            String opt = arg.substring("format=".length()).toLowerCase();
            if (opt.startsWith("freq")) {
                this.mode = Runtime.Mode.FREQUENCY;
                continue;
            }
            if (opt.startsWith("discard")) {
                this.mode = Runtime.Mode.DISCARD;
                continue;
            }
            if (opt.startsWith("omni") || opt.startsWith("stream")) {
                this.mode = Runtime.Mode.STREAM;
                continue;
            }
            if (opt.startsWith("replay")) {
                this.mode = Runtime.Mode.PER_THREAD;
                continue;
            }
            if (opt.startsWith("testing")) {
                this.mode = Runtime.Mode.TESTING;
                continue;
            }
            if (opt.startsWith("network")) {
                this.mode = Runtime.Mode.NETWORK;
                continue;
            }
            if (!opt.startsWith("latest") && !opt.startsWith("nearomni") && !opt.startsWith("near-omni")) continue;
            this.mode = Runtime.Mode.FIXED_SIZE;
        }
    }

    public String getOutputDirname() {
        return this.output_dirname;
    }

    public String getWeaveOption() {
        return this.weaveOption;
    }

    public boolean isDumpClassEnabled() {
        return this.dumpClass;
    }

    public Runtime.Mode getMode() {
        return this.mode;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public boolean isOutputJsonEnabled() {
        return this.outputJson;
    }

    public boolean isWeaveSecurityManagerClassEnabled() {
        return this.weaveSecurityManagerClass;
    }

    public ArrayList<String> getExcludedNames() {
        return this.excludedNames;
    }

    public ArrayList<String> getIncludedNames() {
        return this.includedNames;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public ArrayList<String> getExcludedLocations() {
        return this.excludedLocations;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public int getFilesPerIndex() {
        return this.filesPerIndex;
    }

    public void setFilesPerIndex(int filesPerIndex) {
        this.filesPerIndex = filesPerIndex;
    }

    public String getAgentServerPort() {
        return this.agentServerPort;
    }

    public void setAgentServerPort(String agentServerPort) {
        this.agentServerPort = agentServerPort;
    }
}

